/*
 * ADC.c
 *
 *  Created on: Feb 10, 2012
 *      Author: B40150
 */

#include "TIM.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/

extern MOTOR Motor[4];

/**********************************************************************************************
* Global variables
**********************************************************************************************/

UINT16 u16_testPer = 1200;

/**********************************************************************************************
* Local function prototypes
**********************************************************************************************/

void TIM_CH0_ISR(void);

/**********************************************************************************************
* Global functions
**********************************************************************************************/


/***********************************************************************************************
*
* @brief    TIM_Enabled() - Returns if the TIM module is enabled
* @param    none
* @return   Status of the TIM module
*
************************************************************************************************/
UINT8 TIM_Enabled(){
	return (UINT8)TIM0TSCR1_TEN; 
}

/***********************************************************************************************
*
* @brief    TIM_InterruptCfg(UINT8 en) - Allows enabling or disabling the TIM module
* @param    Enable/Disable command
* @return   none
*
************************************************************************************************/
void TIM_InterruptCfg(UINT8 en){
	TIM0TSCR1_TEN = en;						// TIM enable	
}

/***********************************************************************************************
*
* @brief    TIM_Init   Initializes the Timer Module
* @param    none
* @return   none
*
************************************************************************************************/  
void TIM_Init(){
		
	TIM0TIOS_IOS0 = 1;						// TIMCH0 as output compare
	TIM0TIE_C0I = 1;						// TIMCH0 interrupt enable
	TIM0TFLG1_C0F = 1;						// Clear interrupt flag
	
	TIM0TC0 = u16_testPer; 						// Interrupt period
	
	TIM0TSCR2_PR = 0;						// Clock Prescaler FBUS/2^PR		
	TIM0TSCR1_PRNT = 1;						// Precision Timer enable
	TIM0TSCR1_TEN = 1;						// TIM enable
		
}

/***********************************************************************************************
* @brief    Timer Module interruption for Timer Input Capture/Output Compare Register, where the 
* 			interruption to move the steppers gets called every u16_testPer.
*
************************************************************************************************/

interrupt VectorNumber_Vtim0ch0 void TIM_CH0_ISR(){
	TIM0TFLG1_C0F = 1;						// Clear interrupt flag
	TIM0TC0 = TIM0TC0 + u16_testPer;	
	Move_Stepper();
}


