/*
 * Tasks.c
 *
 *  Created on: Feb 9, 2012
 *      Author: B40150
 */

#include "Tasks.h"

/******************************************************************************
* Global variables
******************************************************************************/
UINT16 u16_posLarge = 56000;
UINT16 u16_posShort = 28000;

UINT8 u8_Demo_stp;
UINT8 u8_Choose_stp=0;
UINT8 u8_dimming = 1;
UINT8 u8_adc_right = 0;	

UINT8 u8_Clock_Mode_Enabled=0;
extern UINT8 u8_LCD_OdometerOption;
UINT8 u8_ODO_Variable2=0;

UINT8 u8_TurnRight = 0;
UINT8 u8_TurnLeft = 0;
UINT8 u8_LCD_ClockOption = 0;
UINT8 u8_ClockSet = 0;
UINT8 u8_LCD_DataOption = 0;
UINT8 u8_LCD_OdometerOption = 0;


/******************************************************************************
* Local Prototypes
******************************************************************************/
void KBI_Callback(void);
void CAN_Callback(UINT32 ID);






/******************************************************************************
* 
* Local functions
* @brief    System_Init() - Enables Application level interrupt callbacks
* @param    none
* @return   none
* 
******************************************************************************/
void System_Init()
{
	GPIO_Set_Callback(KBI_Callback);
	
	/* LCD Setups */
	setEcoMode(1);
	setGasIndicators(1);
	setFreescale(1);
	
}


/******************************************************************************
* Local functions
* @brief    SSG plays single tone
* @param    none
* @return   none
* 
******************************************************************************/

void SSG_TonePlay(void)
{	
	SSG_PlaySingleTone();
}

 /******************************************************************************
 * Local functions
 * @brief    Sets the SSG Volume from the left potentiometer
 * @param    none
 * @return   none
 * 
 ******************************************************************************/

 void Volume(void)
{
UINT8 u8_ADC_Volume = 0;
UINT16 u16_ssgAmp = 0;

	 u8_ADC_Volume = ~u16_ADC_Read(2);			
	 u16_ssgAmp = u8_ADC_Volume*2;
	 SSG0AMP = u16_ssgAmp;					//Tone amplitude	
}
 

	
 /******************************************************************************
 * Local functions
 * @brief    MC_Stepper If a motor is stopped and in the position 0 it will move to u16_posLarge 	
 * 			(motors 0 & 3) or to u16_posShort (motors 1 & 2), else if a motor is stopped and in any
 * 			other position it will move to position 0
 * @param    none
 * @return   none
 * 
 ******************************************************************************/

 
void MC_Stepper(void)
{
UINT32 u32_speed;
UINT8 u8_case;

	if(MC_StepperStopped(0)){
		if(MC_GetMotorPosition(0) == 0){MC_SetMotorPosition(0, u16_posLarge);}
		else if(MC_GetMotorPosition(0) != 0){MC_SetMotorPosition(0, 0);}
		}
	
	if(MC_StepperStopped(1)){
		if(MC_GetMotorPosition(1) == 0){MC_SetMotorPosition(1, u16_posShort);}
		else if(MC_GetMotorPosition(1) != 0){MC_SetMotorPosition(1, 0);}
		}	

	if(MC_StepperStopped(2)){
		if(MC_GetMotorPosition(2) == 0){MC_SetMotorPosition(2, u16_posShort);}
		else if(MC_GetMotorPosition(2) != 0){MC_SetMotorPosition(2, 0);}
		}
	
		
	u32_speed=MC_GetMotorPosition(0)/232;
	if (u32_speed<=20){u8_case = 1;}
	else if (u32_speed>20 && u32_speed<=40){u8_case = 2;}
	else if (u32_speed>40 && u32_speed<=80){u8_case = 3;}
	else if (u32_speed>80 && u32_speed<=120){u8_case = 4;}
	else {u8_case = 5;}
		
	if(MC_StepperStopped(3)){
			if(MC_GetMotorPosition(3) <= 8000)
			{
				MC_SetMotorSpeed(3, 1); 
				MC_SetMotorPosition(3, 40000);
			}
			else if(MC_GetMotorPosition(3) != 0)
			{
				MC_SetMotorSpeed(3, 4); 
				MC_SetMotorPosition(3, 8000);
			}
		}
	
	switch (u8_case)
	{
	case 1:
		SetG(1);
		break;	
	
	case 2:
		SetG(2);
		break;	
		
	case 3:
		SetG(3);
		break;	
	
	case 4:
		SetG(4);
		break;	
	
	case 5:
		SetG(5);
		break;	
		
	default:
		u8_case = 1;
	}		

	
}
 

/******************************************************************************
* Local functions
* @brief   	Time Sets the clock in the LCD according to the real time counter
* @param    none
* @return   none
* 
******************************************************************************/

void Time(void){
	static UINT8 u8_ClockDisplayMode = 0;	
	static UINT8 u8_BlinkTimeout = 0;

	
    static UINT32 u32_substracter, u32_adder;
	
    u8_BlinkTimeout += 8;						/* Blink Timeout Counter */

	
	if (u8_LCD_ClockOption)						/* If clock mode button is pressed (24H or AM/PM modes) */
	{
		u8_LCD_ClockOption = 0;
		
		if(u8_ClockDisplayMode){				/* Toggle between 24H or AM/PM modes */
			u8_ClockDisplayMode = 0;
		}
		else{
			u8_ClockDisplayMode = 1;
		}
	}
	

	if(u8_ClockDisplayMode)						/* If AM/PM Mode */
	{

		if (RTCHRR > 12){						/* Select if AM or PM */
			setPMMode();
		}
		else {
			setAMMode();
		}			
		
		if (u8_BlinkTimeout >= 128 && u8_Clock_Mode_Enabled){
			SetClk_Blink();
		}
		else {
			SetClk(RTCHRR%12, RTCMINR, RTCSECR); 	
			SEG_CCOL = 1;
		}
					
	}
	else{										/* If 24H Mode */
		set24HMode();
		if (u8_BlinkTimeout >= 128 && u8_Clock_Mode_Enabled){
			SetClk_Blink();
		}
		else {
			SetClk(RTCHRR, RTCMINR, RTCSECR); 	
			SEG_CCOL = 1;
		}				
	}	
	
	
	if (u8_ClockSet)							/* If the set clock button is pressed */
	{
		u8_ClockSet = 0;
		
		if(u8_Clock_Mode_Enabled){				/* Toggle between normal and clock mode */
			u8_Clock_Mode_Enabled = 0;
		}
		else{
			u8_Clock_Mode_Enabled = 1;
		}		
	}
	
	
	
	if(u8_Clock_Mode_Enabled){					/* Set Clock Mode enabled */
		
		u8_adc_right = ~u16_ADC_Read(3);
		
		RTCSECR = 0;		
		
		if (u8_adc_right >= 0 && u8_adc_right <= 120)
		{
			u32_substracter = u32_substracter + 120 - u8_adc_right;
			if (u32_substracter>=250)
			{
				u32_substracter = 0;
				if (RTCMINR == 0)
				{
					RTCMINR = 59;
					if (RTCHRR == 0){
						RTCHRR=23;
					}
					else {
						RTCHRR--;
					}
				}
				else
				{
					RTCMINR--;	
				}
			}
		}
		else if (u8_adc_right > 140)
		{
			u32_adder = u32_adder - 140 + u8_adc_right;
			if (u32_adder >= 250)
			{
				u32_adder = 0;
				if (RTCMINR==59){
					RTCMINR = 0;
					if (RTCHRR==23){
						RTCHRR=0;
					}
					else {
						RTCHRR++;
					}
				}
				else{
					RTCMINR++;	
				}
			}
		}
	}
	else{
		u8_Clock_Mode_Enabled = 0;
	}
	
}


/******************************************************************************
* Local functions
* @brief    Turn - Controls the Left or Right turn indicators
* @param    none
* @return   none
* 
******************************************************************************/
void Turn(void)
 {
	static UINT8 u8_left_status;
	static UINT8 u8_right_status;
	static UINT8 toggle = 0;
	
	toggle = ~toggle;
	
	if (u8_TurnLeft)
	{
		u8_TurnLeft = 0;
		u8_left_status = ~u8_left_status;
	}
	
	if (u8_TurnRight)
	{
		u8_TurnRight = 0;
		u8_right_status = ~u8_right_status;
	}	
		
	if (u8_left_status)
	{
		if(toggle){Left_Led(ON);}
		else {Left_Led(OFF);}
	}
	else
	{
		Left_Led(OFF);
	}
	
	if (u8_right_status)
	{
		if(toggle){Right_Led(ON);}
		else {Right_Led(OFF);}		
	}
	else
	{
		Right_Led(OFF);
	}	
	
 }

/******************************************************************************
* Local functions
* @brief    Switches which function will the ODO block display between Odometer, Trip A, Trip B, 
* 			Temperature and Range
* @param    none
* @return   none
* 
******************************************************************************/

void Odometer(void)
 {
	static UINT8 u8_submode = 3;
	static UINT32 u32_seg=0, u32_segtripa, u32_segtripb, u32_segtemp, u32_segrange=999999;
	
	/*ODO_COUNT*/
	u32_seg++;
	u32_segtripa++;
	u32_segtripb++;
	u32_segtemp++;
	u32_segrange--;
	/*ODO_COUNT*/ 
	

	
	if (u8_LCD_OdometerOption)
	{
		u8_LCD_OdometerOption=0;
		u8_submode++;
	}
	
	if (u8_ODO_Variable2)
	{
		u8_ODO_Variable2=0;
		if (u8_submode==1)
		{
			u32_segtripa=0;
		}
		else if (u8_submode==2)
		{
			u32_segtripb=0;
		}
	}
	switch (u8_submode)
	{
	case 0:
		setRangeMode();
		Range_Mode(u32_segrange);
		break;
	case 1:
		setTripAMode();
		TripA_Mode(u32_segtripa);
		break;
	case 2:
		setTripBMode();
		TripB_Mode(u32_segtripb);
		break;
	case 3:
		setOdoMode();
		ODO_Mode(u32_seg);
		break;
	case 4:
		setTempMode();
		Temp_Mode(u32_segtemp);
		break;
	default:
		u8_submode=0;
		break;
	}

 }


/******************************************************************************
* Local functions
* @brief    Fuel, controls the Fuel bars and the fuel_led
* @param    none
* @return   none
* 
******************************************************************************/

void Fuel(void)
{
	static UINT8 u8_low_fuel=0;
	
	if (MC_GetMotorPosition(2)==0){setBar(0,1);}
	else if (MC_GetMotorPosition(2)>=1 && MC_GetMotorPosition(2)<3500){setBar(1,1);}
	else if (MC_GetMotorPosition(2)>=3500 && MC_GetMotorPosition(2)<7000){setBar(2,1);}
	else if (MC_GetMotorPosition(2)>=7000 && MC_GetMotorPosition(2)<10500){setBar(3,1);}
	else if (MC_GetMotorPosition(2)>=10500 && MC_GetMotorPosition(2)<14000){setBar(4,1);}
	else if (MC_GetMotorPosition(2)>=14000 && MC_GetMotorPosition(2)<17500){setBar(5,1);}
	else if (MC_GetMotorPosition(2)>=17500 && MC_GetMotorPosition(2)<21000){setBar(6,1);}	
	else if (MC_GetMotorPosition(2)>=21000 && MC_GetMotorPosition(2)<24500){setBar(7,1);}
	else if (MC_GetMotorPosition(2)>=24500){setBar(8,1);}
	
	if (MC_GetMotorPosition(2)<=7000)
	{
		u8_low_fuel=1;
	}
	else
	{
		u8_low_fuel=0;
	}
	
	
	if (u8_low_fuel==1)
	{
		Fuel_Led(ON);
	}
	else
	{
		Fuel_Led(OFF);
	}
}

/******************************************************************************
* Local functions
* @brief    Temperature, controls the check_temperature_led
* @param    none
* @return   none
* 
******************************************************************************/
void Temperature(void)
{
	static UINT8 u8_high_temp=0;
	
	if (MC_GetMotorPosition(1)>= 24500)
	{
		u8_high_temp=1;
	}
	else
	{
		u8_high_temp=0;
	}
	
	
	if (u8_high_temp==1)
	{
		Check_Temperature_Led(ON);
	}
	else
	{
		Check_Temperature_Led(OFF);
	}
}

/******************************************************************************
* Local functions
* @brief    Switches which function will the LCD_Data block display between Avarage Consumption, E/T 
* 			(estimated time to arrival) and Speed
* @param    none
* @return   none
* 
******************************************************************************/

void LCD_Data(void)
 {
	static UINT8 u8_mode,u8_counter1=0, u8_m,u8_s;
	static UINT32 u32_segAFM, u32_segET;
	static UINT32 u32_totaltime=3600; 
	static UINT32 u32_segSpeed;
	
	/*LCD DATA COUNT*/
	u32_segAFM++;
	u8_counter1++;
	u32_segSpeed=MC_GetMotorPosition(0)/232;
	/*LCD DATA COUNT*/ 	
	
		if (u8_counter1==50)
	{
		u32_totaltime--;
		u8_counter1=0;
		u8_m=u32_totaltime/60;
		u8_s=(u32_totaltime%60);
		u32_segET=u8_m*100+u8_s;
	}
		
	if (u8_LCD_DataOption)
	{
		u8_LCD_DataOption=0;
		u8_mode++;
	}
	
	switch (u8_mode)
	{
	case 0:
		setSpeedMode();
		Speed_Mode(u32_segSpeed);
		break;
	case 1:
		setFuelEfficiencyMode();
		Avarage_Fuel_Mode(u32_segAFM);
		break;
	case 2:
		setETMode();
		Estimated_Time_Mode(u32_segET);
		break;

	default:
		u8_mode=0;
		break;
	}

 }

/******************************************************************************
* Local functions
* @brief    Controls all the lights in the Cluster
* @param    none
* @return   none
* 
******************************************************************************/
void Illumination(void)
 {
	UINT8 u8_Motor_Position,u8_kc,u8_kp,u8_kf;
	static UINT16 u16_TT_Random_Counter;
	static UINT8 u8_ChkEng_TT, u8_ChkOil_TT, u8_HiBeam_TT, u8_FogLights_TT;
	
	u8_adc_right = ~u16_ADC_Read(3);					/* Read ADC for right potentiometer */
	
	u16_TT_Random_Counter++;
	if (u16_TT_Random_Counter == 1384){
		u8_ChkEng_TT = ~u8_ChkEng_TT;		
	}
	else if (u16_TT_Random_Counter == 3276) {
		u8_ChkOil_TT = ~u8_ChkOil_TT;	
	}
	else if (u16_TT_Random_Counter == 4912) {
		u8_HiBeam_TT = ~u8_HiBeam_TT;
	}
	else if (u16_TT_Random_Counter == 7456){
		u8_FogLights_TT = ~u8_FogLights_TT;
		u16_TT_Random_Counter = 0;
	}
	
	
	/* Tell tales random toggling */
	Pointers_Led(ON);
	Check_Engine_Led(u8_ChkEng_TT & 0x01);
	setCheckService(u8_ChkEng_TT);						/* Set the service logo on the LCD with the Check engine TT */
	
	Check_Oil_Led(u8_ChkOil_TT & 0x01);
	High_Lights_Led(u8_HiBeam_TT & 0x01);
	Low_Lights_Led(u8_FogLights_TT & 0x01)			
	
	
	/* Backlight dimming */
	if (!u8_Clock_Mode_Enabled)
	{		
			PWM_SetDuty(PWM_LCD_BACKLIGHT_CH, u8_adc_right);					
			PWM_SetDuty(PWM_TEMP_WHITE_CH, u8_adc_right);
			PWM_SetDuty(PWM_GAS_WHITE_CH, u8_adc_right);

	/* Speed Gauge Dimming */
		u8_Motor_Position=MC_GetMotorPosition(0)/232;
		
		if (u8_Motor_Position <= 190)
		{
			PWM_SetDuty(PWM_SPEED_RED_CH,0);
			PWM_SetDuty(PWM_SPEED_WHITE_CH, u8_adc_right);
		}
		else
		{
			u8_kc = (u8_Motor_Position - 190)* 5;
			u8_kp = 102 -(u8_kc * 100 / 250);
			u8_kf = u8_adc_right * u8_kp/100;
			PWM_SetDuty(PWM_SPEED_RED_CH, u8_kc);
			PWM_SetDuty(PWM_SPEED_WHITE_CH, u8_kf);
		}
		
	/* RPM Gauge Dimming */		
		u8_Motor_Position=MC_GetMotorPosition(3)/232;
		if (u8_Motor_Position > 50)
		{
			PWM_SetDuty(PWM_RPM_RED_CH,0);
			PWM_SetDuty(PWM_RPM_WHITE_CH, u8_adc_right);
		}
		else
		{
			u8_Motor_Position = (~u8_Motor_Position - 205) * 5;
			u8_kp = 100 - (u8_Motor_Position * 100 / 250);
			u8_kf = u8_adc_right * u8_kp / 100;
			PWM_SetDuty(PWM_RPM_RED_CH, u8_Motor_Position);
			PWM_SetDuty(PWM_RPM_WHITE_CH, u8_kf);
		}
	}
 }


/******************************************************************************
* Interrupt Callbacks
******************************************************************************/
void KBI_Callback(void)
{	
	if(PTS_PTS7){
		GPIO_PIF(S,7,1);
		u8_LCD_OdometerOption = 1;
	}
	else if(PTS_PTS6){
		GPIO_PIF(S,6,1);
		u8_LCD_DataOption = 1;
	}
	else if(PTS_PTS5){
		GPIO_PIF(S,5,1);
		u8_TurnLeft = 1;
	}
	else if(PTS_PTS4){
		GPIO_PIF(S,4,1);
		u8_TurnRight = 1;
	}
	else if(PTS_PTS3){
		GPIO_PIF(S,3,1);
		u8_LCD_ClockOption = 1;
	}
	else if(PTS_PTS2){
		GPIO_PIF(S,2,1);
		u8_ClockSet = 1;
	}	
		
}


void CAN_Callback(UINT32 ID)
{
	
	MC_SetMotorSpeed(0,1);
	MC_SetMotorSpeed(1,1);
	MC_SetMotorSpeed(2,1);
	MC_SetMotorSpeed(3,1);
	
	MC_SetMotorPosition(0, Rx_Struct.u8Rx_Buffer[0] * 14000);
	MC_SetMotorPosition(1, Rx_Struct.u8Rx_Buffer[0] * 7000);
	MC_SetMotorPosition(2, Rx_Struct.u8Rx_Buffer[0] * 7000);
	MC_SetMotorPosition(3, Rx_Struct.u8Rx_Buffer[0] * 14000);	
}
