/******************************************************************************								
*    S12ZVH128 Cluster Reference Design                                       *								
*                                                                             *								
*       Created on: 05/03/2012                                                *								
*       Author: B34981                                                        *								
*       Version: 0.2                                                          *								
*                                                                             *								
*       This Reference Design resembles a Low-End cluster with the following  *								
*    features:                                                                *								
*       - 160 Segment LCD                                                     *								
*       - 4 Stepper motors with Return-to-Zero detection                      *								
*       - Real Time Counter on LCD                                            *								
*       - Dynamic backlighting (dimmable from Analog Input)                   *								
*       - CAN Communications                                                  *								
*       - Simple Sound Generation                                             *								
*                                                                             *								
******************************************************************************/								
#include "derivative.h" /* include peripheral declarations */

void main(void) {
  
	EnableInterrupts;
	
	CPMUCOP_CR = 0x0;		/* Disable COP */

	PLL_Init();				/* Initialise the PLL to increase operating frequency */
	GPIO_Init();			/* Configures inputs, outputs, pull-ups and KBI interrupts*/
	SSG_Init();				/* Initialises the SSG module to play a single Gong Decay tone */
	PWM_Init();				/* Configures 7 PWM channels for Backlight dimming */
	LCD_Init();				/* Configures the LCD controller for 4x40 operation */
	SSD_Init();				/* Configures four channels of stepper stall detection */
	MC_Init();				/* Configures four stepper motors in Full H-Bridge Configuration */
	TIM_Init();				/* Configures one TIM periodic interrupt for stepper control */
	ADC_Init();				/* Configures three ADC channels, two pots and the temperature sensor */
	RTC_Init();				/* Configures the Real Time Counter from the 32 KHz oscillator */
	RTI_Init();				/* Configures the RTI interrupt as scheduler tick source */
	CANPHY_Init();			/* Configures the internal CANPHY module */
	MSCAN_Init();			/* Configures the digital CAN module (125 Kbit/s) */
	System_Init();			/* Initialises application level interrupt callbacks */
	Scheduler_Init();		/* Execute the Scheduler... never returns */

  for(;;) {
	  // Intentionally empty
  } 

}
