/*
 * LED.h
 *
 *  Created on: Dec 19, 2016
 *      Author: B50961
 */

#ifndef LED_H_
#define LED_H_
#include "szk_ff_tpm.h"
#include "user_configuration.h"

/* 
 * Be careful: LED5 and LED6 are driven by PTB0 and PTB1 which are also used in priority by the LF block 
 * So when the LF block is ON, LED5 and LED6 cannot be used 
 * 
 * LED1 : PTA0
 * LED2 : PTA1
 * LED3 : PTA2
 * LED4 : PTA3
 * LED5 : PTB0
 * LED6 : PTB1
 */

#if (LEDS == USE_LEDS)

#define INIT_LED1			PTAD_PTAD0 = 0;PTADD_PTADD0 = 1  
#define INIT_LED2			PTAD_PTAD1 = 0;PTADD_PTADD1 = 1  
#define INIT_LED3			PTAD_PTAD2 = 0;PTADD_PTADD2 = 1  
#define INIT_LED4			PTAD_PTAD3 = 0;PTADD_PTADD3 = 1  
#define INIT_LED5			PTBD_PTBD0 = 0;PTBDD_PTBDD0 = 1  
#define INIT_LED6			PTBD_PTBD1 = 0;PTBDD_PTBDD1 = 1 

#define LED1_ON				PTAD_PTAD0 = 1 
#define LED2_ON				PTAD_PTAD1 = 1 
#define LED3_ON				PTAD_PTAD2 = 1 
#define LED4_ON				PTAD_PTAD3 = 1 
#define LED5_ON				PTBD_PTBD0 = 1
#define LED6_ON				PTBD_PTBD1 = 1 

#define LED1_OFF			PTAD_PTAD0 = 0 
#define LED2_OFF			PTAD_PTAD1 = 0
#define LED3_OFF			PTAD_PTAD2 = 0 
#define LED4_OFF			PTAD_PTAD3 = 0 
#define LED5_OFF			PTBD_PTBD0 = 0 
#define LED6_OFF			PTBD_PTBD1 = 0 

#define FLASH_LED1			INIT_LED1; LED1_ON; vfnWaitMSec(100); LED1_OFF
#define FLASH_LED2			INIT_LED2; LED2_ON; vfnWaitMSec(100); LED2_OFF
#define FLASH_LED3			INIT_LED3; LED3_ON; vfnWaitMSec(100); LED3_OFF
#define FLASH_LED4			INIT_LED4; LED4_ON; vfnWaitMSec(100); LED4_OFF
#define FLASH_LED5			INIT_LED5; LED5_ON; vfnWaitMSec(100); LED5_OFF
#define FLASH_LED6			INIT_LED6; LED6_ON; vfnWaitMSec(100); LED6_OFF

#define FLASH_LED5_30ms		INIT_LED5; LED5_ON; vfnWaitMSec(30); LED5_OFF

#else

#define INIT_LED1			__asm nop  
#define INIT_LED2			__asm nop  
#define INIT_LED3			__asm nop  
#define INIT_LED4			__asm nop  
#define INIT_LED5			__asm nop  
#define INIT_LED6			__asm nop 

#define LED1_ON				__asm nop 
#define LED2_ON				__asm nop 
#define LED3_ON				__asm nop 
#define LED4_ON				__asm nop 
#define LED5_ON				__asm nop
#define LED6_ON				__asm nop 

#define LED1_OFF			__asm nop 
#define LED2_OFF			__asm nop
#define LED3_OFF			__asm nop 
#define LED4_OFF			__asm nop 
#define LED5_OFF			__asm nop 
#define LED6_OFF			__asm nop 

#define FLASH_LED1			__asm nop
#define FLASH_LED2			__asm nop
#define FLASH_LED3			__asm nop
#define FLASH_LED4			__asm nop
#define FLASH_LED5			__asm nop
#define FLASH_LED6			__asm nop

#define FLASH_LED5_30ms		__asm nop

#endif

#endif /* LED_H_ */
