/*
  Copyright (c) 2008 - 2014 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	"main.h"
  \brief    	
  \author   	Freescale Semiconductor
  
*/
#ifndef MAIN_INCLUDED
#define MAIN_INCLUDED  /* MAIN_INCLUDED  */

/*--- TARGET Related ---*/
#define THIS_IS_SUZUKA 0x1234
#define THIS_IS_7X7    0x9ABC


/* 
 *****************************************************************************
 *
 * DEFINES 
 *
 ****************************************************************************/
/*
 ******************************************************************************
 *
 *  General bit positions.
 *
 ******************************************************************************
 */
#define BIT0	((UINT8)1u)
#define BIT1	((UINT8)2u)
#define BIT2	((UINT8)4u)
#define BIT3	((UINT8)8u)
#define BIT4	((UINT8)16u)
#define BIT5	((UINT8)32u)
#define BIT6	((UINT8)64u)
#define BIT7	((UINT8)128u)

/*
 ******************************************************************************
 *
 *  Define SET and CLEAR.
 *
 ******************************************************************************
 */
#ifndef CLEAR
#define CLEAR 0u
#endif
#ifndef SET
#define SET   1u
#endif


/*
 ******************************************************************************
 *
 * The following define STOP mode entries.
 *
 ******************************************************************************
 */  
#define STOP1 ((UINT8)1u) 
#define STOP4 ((UINT8)4u)
/*
 ******************************************************************************
 *
 *  General typedefs.
 *
 ******************************************************************************
 */
typedef unsigned char  UINT8;
typedef   signed char   INT8;
typedef unsigned short UINT16;
typedef   signed short  INT16;
typedef unsigned long  UINT32;
typedef   signed long   INT32;

 
 
/*
 ******************************************************************************
 *
 * Global Variables
 *
 ******************************************************************************
 */
#pragma DATA_SEG BATTERY_BACKED_RAM
extern UINT16 gu16UUMA[];
extern UINT16 FrameID;
extern UINT32 Tire_ID;
extern UINT8 Firmware_Version;
extern UINT8 Derivative_Descriptor;
extern volatile UINT8 RF_Interrupt;
extern UINT8 PWUDIV_1sec_calibrated;


#pragma DATA_SEG FIRMWARE_GLOBAL_RAM
extern UINT8 TPMS_CONT_ACCEL_GV  @ 0x008Eu; /* Embedded Firmware maps this location */
extern UINT8 TPMS_INTERRUPT_FLAG @ 0x008Fu; /* Embedded Firmware maps this location */

/*
 ******************************************************************************
 *
 * Function Prototypes
 *
 ******************************************************************************
 */
#pragma CODE_SEG DEFAULT

void main(void);
void vfnSetupMCU(void);
void vfnSetSTOPMode(UINT8 u8Mode);
void vfnSetPWU(void);
void vfnUpdateTireID(void);
void Init_RF(void);
void delay (unsigned char);
UINT8 CheckSum_FSL_Full(UINT8 *array, UINT8 u8Size);
void Fill_RFBUFFER(void);
void Measure_P_T_V_AccZ(void);
void vfnSetupGPIO(void);
UINT16 u16fnAccessUUMA(UINT8 u8Index);
UINT16 Calculate_CRC_MKW01( UINT8 *buffer, UINT8 length );
UINT16 ComputeCrc_MKW01( UINT16 crc, UINT8 dataByte, UINT16 polynomial );

#pragma CODE_SEG DEFAULT
#endif /* MAIN_INCLUDED */
/*
 ******************************************************************************
 *
 * End of file.
 *
 ******************************************************************************
 */
