/**
  Copyright (c) 2013 - 2014 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file      DAL.c
  \brief     Derivative Abstraction Layer: Choses correct derivative and 
             fns based entirely on Firmware in the part.
  \author    Freescale Semiconductor
  \author    SSD Automotive     
  \author    R11515 
  \version    
  \date     	
  \warning    (If needed)

  * History:
  
*/
#include "derivative.h"                 /* Derivative */
#include "common.h"
#include "DAL.h"

/*
 ******************************************************************************
 * cau16DALDerivativeFnTable - Used to find address for a particular fn
 * given a derivative.
 ******************************************************************************
 */
const UINT16 cau16DALDerivativeFnTable[] = 
{
  /* 2-axes fns.                 1-axis fns */
  /* 00 */ TWO_AXES_RESET,              ONE_AXIS_RESET,
  /* 02 */ TWO_AXES_READ_VOLT,          ONE_AXIS_READ_VOLT,
  /* 04 */ TWO_AXES_COMP_VOLT,          ONE_AXIS_COMP_VOLT,
  /* 06 */ TWO_AXES_READ_TEMP,          ONE_AXIS_READ_TEMP,
  /* 08 */ TWO_AXES_COMP_TEMP,          ONE_AXIS_COMP_TEMP,
  /* 0A */ TWO_AXES_READ_PRESSURE,      ONE_AXIS_READ_PRESSURE,
  /* 0C */ TWO_AXES_COMP_PRESSURE,      ONE_AXIS_COMP_PRESSURE,
  /* 0E */ TWO_AXES_READ_ACCEL_X,       NO_EQUIVALENT_FN,         
  /* 10 */ TWO_AXES_READ_DYN_X,         NO_EQUIVALENT_FN,
  /* 12 */ TWO_AXES_COMP_X,             NO_EQUIVALENT_FN,
  /* 14 */ TWO_AXES_READ_ACCEL_Z,       ONE_AXIS_READ_ACCEL,            
  /* 16 */ TWO_AXES_READ_DYN_Z,         ONE_AXIS_READ_DYN_ACCEL,
  /* 18 */ TWO_AXES_COMP_Z,             ONE_AXIS_COMP_ACCEL,
  /* 1A */ TWO_AXES_READ_ACCEL_XZ,      NO_EQUIVALENT_FN,
  /* 1C */ TWO_AXES_READ_DYN_XZ,        NO_EQUIVALENT_FN,
  /* 1E */ TWO_AXES_COMP_XZ,            NO_EQUIVALENT_FN,
  /* 20 */ TWO_AXES_READ_V0,            ONE_AXIS_READ_V0,
  /* 21 */ TWO_AXES_READ_V1,            ONE_AXIS_READ_V1,
  /* 22 */ TWO_AXES_LFOCAL,             ONE_AXIS_LFOCAL,
  /* 24 */ TWO_AXES_MFOCAL,             ONE_AXIS_MFOCAL,
  /* 26 */ TWO_AXES_RF_ENABLE,          ONE_AXIS_RF_ENABLE,
  /* 28 */ TWO_AXES_RF_RESET,           ONE_AXIS_RF_RESET,
  /* 2A */ TWO_AXES_RF_READ_DATA,       ONE_AXIS_RF_READ_DATA,
  /* 2C */ TWO_AXES_RF_READ_DATA_R,     ONE_AXIS_RF_READ_DATA_R,
  /* 2E */ TWO_AXES_RF_WRITE_DATA,      ONE_AXIS_RF_WRITE_DATA,
  /* 30 */ TWO_AXES_RF_WRITE_DATA_R,    ONE_AXIS_RF_WRITE_DATA_R,
  /* 32 */ TWO_AXES_RF_CONFIG_DATA,     ONE_AXIS_RF_CONFIG_DATA,
  /* 34 */ TWO_AXES_RF_SET_TX,          ONE_AXIS_RF_SET_TX,
  /* 36 */ TWO_AXES_RF_DYN_POWER,       ONE_AXIS_RF_DYN_POWER,
  /* 38 */ TWO_AXES_MSG_INIT,           ONE_AXIS_MSG_INIT,
  /* 3A */ TWO_AXES_MSG_READ,           ONE_AXIS_MSG_READ,
  /* 3C */ TWO_AXES_MSG_WRITE,          ONE_AXIS_MSG_WRITE,
  /* 3E */ TWO_AXES_CHECKSUM_XOR,       ONE_AXIS_CHECKSUM_XOR,
  /* 40 */ TWO_AXES_CRC8,               ONE_AXIS_CRC8,
  /* 42 */ TWO_AXES_CRC16,              ONE_AXIS_CRC16,
  /* 44 */ TWO_AXES_SQRT,               ONE_AXIS_SQRT,
  /* 46 */ TWO_AXES_READ_ID,            ONE_AXIS_READ_ID, 
  /* 48 */ TWO_AXES_LF_ENABLE,          ONE_AXIS_LF_ENABLE,
  /* 4A */ TWO_AXES_LF_READ_DATA,       ONE_AXIS_LF_READ_DATA, 
  /* 4C */ TWO_AXES_WIRE_AND_ADC_CHECK, ONE_AXIS_WIRE_AND_ADC_CHECK,
  /* 4E */ TWO_AXES_FLASH_WRITE,        ONE_AXIS_FLASH_WRITE,
  /* 50 */ TWO_AXES_FLASH_CHECK,        ONE_AXIS_FLASH_CHECK,
  /* 52 */ TWO_AXES_FLASH_ERASE,        ONE_AXIS_FLASH_ERASE,
  /* 54 */ TWO_AXES_FLASH_PROTECT,      ONE_AXIS_FLASH_PROTECT,
  /* 56 */ TWO_AXES_MULT_SIGN_INT16,    ONE_AXIS_MULT_SIGN_INT16,
  /* 5A */ TWO_AXES_WAVG,               ONE_AXIS_WAVG,
  /* 5C */ TWO_AXES_RDE,                ONE_AXIS_RDE,
  /* 5E */ NO_EQUIVALENT_FN,            ONE_AXIS_VREG_CHECK,
  /* 60 */ NO_EQUIVALENT_FN,            ONE_AXIS_PRECHARGE_VREG,
  /* 62 */ NO_EQUIVALENT_FN,            ONE_AXIS_ACCEL_CONT_START,
  /* 64 */ NO_EQUIVALENT_FN,            ONE_AXIS_ACCEL_CONT,
  /* 66 */ NO_EQUIVALENT_FN,            ONE_AXIS_ACCEL_CONT_STOP
};
const UINT8 cau8UUMAIndexPerDerivative[SIZE_OF_UUMA_ARRAY * 2u] = 
{
  /* 2-axes order   1-axis order  */
  TWO_AXES_V_INDEX, ONE_AXIS_V_INDEX,
  TWO_AXES_T_INDEX, ONE_AXIS_T_INDEX,
  TWO_AXES_P_INDEX, ONE_AXIS_P_INDEX,
  TWO_AXES_X_INDEX, ONE_AXIS_X_INDEX,
  TWO_AXES_Z_INDEX, ONE_AXIS_Z_INDEX
};
/*
 ******************************************************************************
 * gu8Derivative - used to remember which derivative we have.
 ******************************************************************************
 */
#pragma DATA_SEG BATTERY_BACKED_RAM
UINT8 gu8Derivative;
UINT8 TPMS_INTERRUPT_FLAG @ 0x8Fu;
/*
 ******************************************************************************
 * gu16AddressToFn - Stores the result from u16fnDALLinkFmw
 ******************************************************************************
 */
#pragma DATA_SEG DEFAULT
/*
 ******************************************************************************
 * u8fnDALDetectDerivative
 ******************************************************************************
 */
UINT8 u8fnDALDetectDerivative(void)
{
  UINT8 u8DerivativeTableIndex;
  
  u8DerivativeTableIndex = INVALID_DERIVATIVE;
  
  switch(PT_DERIVATIVE)
  {
    case(TWO_AXIS_DERIVATIVE_1):
    {
      /* Carry over to next case */
    };
    case(TWO_AXIS_DERIVATIVE_2):
    {
      u8DerivativeTableIndex = TWO_AXIS_DERIVATIVE_INDEX;
      break;
    }
    case(ONE_AXIS_DERIVATIVE_1):
    {
      /* Carry over to next case */
    };
    case(ONE_AXIS_DERIVATIVE_2):
    {
      /* Carry over to next case */
    };
    case(ONE_AXIS_DERIVATIVE_3):
    {
      u8DerivativeTableIndex = ONE_AXIS_DERIVATIVE_INDEX;
      break;
    }
    default:
    {
      break;
    }
  }
  
  gu8Derivative = u8DerivativeTableIndex;
  
  return(u8DerivativeTableIndex); 
}
/*
 ******************************************************************************
 * UINT16
 ******************************************************************************
 */
 UINT16 u16fnDALLinkFmw(UINT8 u8DerivativeTableIndex, UINT8 u8NormalizedFnIndex)
 {
   UINT16 u16Address;
   
   u8NormalizedFnIndex *= 2u;
   
   u16Address = cau16DALDerivativeFnTable[u8NormalizedFnIndex + 
                                          u8DerivativeTableIndex];
   
   return(u16Address);
 }

/*
 ******************************************************************************
 *
 *  End of file.
 *
 ******************************************************************************
 */