/**
 Copyright (c) 2012 - 2014 Freescale Semiconductor
 Freescale Confidential Proprietary
 \file      szk_lf_Data_Detect.c
 \brief     Configures the device for Data detect and goes to sleep.
 When woken-up, PTA2 goes high until PTA0 has a fallen edge.
 \author    Freescale Semiconductor
 \author    SSD Automotive     
 \author    R11515 
 \version    
 \date     	

 * History:
 
 */

#include <hidef.h>
#include "derivative.h"
#include "main.h"                /* Link to delay fn. */
#include "szk_lf_Data_Detect.h"  
#include "MKW01_Communication.h" // for LFIDL_current
#pragma DATA_SEG PARAM_SEC
UINT8 gau8DataBuffer[DATAGRAM_SIZE];
#pragma DATA_SEG DEFAULT


/*
 ******************************************************************************
 * vfnClearReceivedBuffer
 ******************************************************************************
 */
void vfnClearReceivedBuffer(void) {
	UINT8 u8Counter;
	for (u8Counter = CLEAR; u8Counter < sizeof(gau8DataBuffer); u8Counter++) {
		gau8DataBuffer[u8Counter] = CLEAR;
	}
	return;
}
/*
 ******************************************************************************
 * vfnDataModeInit
 ******************************************************************************
 */
void vfnDataModeInit(void) {
	/* Make sure we're not enabled */
	LFCTL1_LFEN = CLEAR;

	/* Low consumption during sniff mode + LF Ack */LFS = (LFS_LPSM_MASK
			| LFS_LFIACK_MASK);

	/* Switch to PAGE1 */LFCTL1_LPAGE = SET;

	/* ********************* Page 1 registers below; ***************************/

	/* LFCTRLE to LFCTRLB are taken care of by firmware */

	/* Register LFCTRLA; RESET Value */LFCTRLA = CLEAR;

	/* Return to the PAGE 0 */LFCTL1_LPAGE = CLEAR;

	/* ********************** Going back to page 0. ****************************/

	/* Page0 shall be enabled */LFCTL2 = CLEAR;

	/* Carrier detect time is specified below */LFCTL3 = (LFCTL3_T9_PATTERN
			| LFCTL3_CARRIER_DETECT_512_USEC );

	/* Enable Data Mode interrupts, enable the digital decoder and carrier */
	/* validation, and set sync time-out */LFCTL4 = (LFCTL4_LFDRIE_MASK
			| LFCTL4_DECEN_MASK | LFCTL4_VALEN_MASK | LFCTL4_SYNC_SET_TO_24_MSEC
			| LFCTL4_LFERIE_MASK);

	/* Set ID values */
	LFIDH = ((UINT8) 0x5Eu);
	LFIDL = ((UINT8)0x31u);

	/* Disable carrier mode */LFCTL1_CARMOD = CLEAR;

	/* Set ID type to 16-bit type */LFCTL1_IDSEL = IDSEL_TYPE_16_BIT;

	/* Set sensitivity */LFCTL1_SENS = SENSITIVITY;

	return;
}


/*
 ******************************************************************************
 *
 *  End of file.
 *
 ******************************************************************************
 */
