/*
 * UART.h
 *
 *  Created on: Dec 18, 2013
 *      Author: B46911
 */

#ifndef UART_H_
#define UART_H_
/*******************************************************************************
* Includes
********************************************************************************/
#include "derivative.h"

/*******************************************************************************
* Constants
********************************************************************************/


/*******************************************************************************
* Macros
********************************************************************************/


/*******************************************************************************
* Types
********************************************************************************/


/*******************************************************************************
* Variables
********************************************************************************/


/*******************************************************************************
* Global Variables
********************************************************************************/


/*******************************************************************************
* Global Functions
********************************************************************************/

/***********************************************************************************************
*
* @brief    Uart_Init - Initalizes the Uart 1 to run at 9600 bauds assuming bus clock of 20Mhz
* @param    none
* @return   none
*
************************************************************************************************/
void UART_Init();


/***********************************************************************************************
*
* @brief    Uart_SendChar - Send a single byte on Uart1
* @param    byte to send
* @return   none
*
************************************************************************************************/
void Uart_SendChar(UINT8 send);

/***********************************************************************************************
*
* @brief    Uart_GetChar - Retreive the received char from the Uart1 buffer (should be called from Interrupt)
* @param    none
* @return   received byte
*
************************************************************************************************/
UINT8 Uart_GetChar();

/***********************************************************************************************
*
* @brief    Uart_SetCallback - Set a callback function to execute when a byte is received on the Uart1
* @param    pointer to function with an UINT8 argument
* @return   none
*
************************************************************************************************/
void Uart_SetCallback(pt2FuncU8 ptr);


#endif /* UART_H_ */
