/*
 * PWT.c
 *
 *  Created on: May 7, 2014
 *      Author: B46911
 */

#include "PWT.h"
/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/
UINT32 positive_pulse=0,negative_pulse=0;
UINT8 counter_overflow=0;

/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/


/***********************************************************************************************
*
* @brief    PWT_Init- Initialize the PWT to measure the pulse width, starting from the first rising edge.
* @param    none
* @return   none
*
************************************************************************************************/  
void PWT_Init()
{
	

	SIM_SCGC |=  SIM_SCGC_PWT_MASK;
	PWT_R1|=PWT_R1_POVIE_MASK;	 		 /*enable overflow interrupt*/
	PWT_R1|=PWT_R1_PRDYIE_MASK;			 /*enable data ready interrupt*/
	PWT_R1|=PWT_R1_PWTIE_MASK;			 /*enable PWT module interrupt*/
	PWT_R1|=PWT_R1_PWTEN_MASK; 			 /*enable PWT module */
	PWT_R1|=PWT_R1_PRE(0b111);			 /*PWT clock source presclaer is 128 */
	PWT_R1|=PWT_R1_EDGE(0b01);			 /*start to measure pulse from first rising-edge and all edges */
	PWT_R1|=PWT_R1_PINSEL(0b00);		 /*PWT input clock pin is PTD5 */

}

/***********************************************************************************************
*
* @brief    Positive_pulse_measure-Measure the positive part of the pulse
* @param    none
* @return   positive_pulse
*
************************************************************************************************/  

UINT32 Positive_pulse_measure(void)
{
	
  	return positive_pulse;
  	

}


/***********************************************************************************************
*
* @brief   Negative_pulse_measure - Measure the negative part of the pulse
* @param    none
* @return   negative_pulse
*
************************************************************************************************/  
UINT32 Negative_pulse_measure(void)
{


  	return negative_pulse;
  

}


/***********************************************************************************************
*
* @brief    PWT_IRQHandler - Interrupt for PWT, take negative and positive pulse measurement
* @param    none
* @return   none
*
************************************************************************************************/
void PWT_IRQHandler()
{
	if((PWT_R1&PWT_R1_PWTOV_MASK))  	/* If overflow interrupt has occurred*/
	{
		  PWT_R1 ^= PWT_R1_PWTOV_MASK;	/* Clear overflow flag*/
		  positive_pulse=0;
		  negative_pulse=0;
		  counter_overflow=1;
	}
	
	if((PWT_R1&PWT_R1_PWTRDY_MASK))		/* If data ready interrupt has occurred*/
	{
	  (void)PWT_R1;									/* Read PWT Register 1*/
	  counter_overflow=0;
	  PWT_R1 ^= PWT_R1_PWTRDY_MASK;					/* Clear data ready flag*/
	  positive_pulse=(PWT_R1>>16 & 0x0000FFFF) ;	/* Read positive measurement*/	
	  negative_pulse=PWT_R2 & 0x0000FFFF;			/* Read negative measurement*/
	  (void)PWT_R1;									/* Read PWT Register 1*/
	  PWT_R1 ^= PWT_R1_PWTRDY_MASK;					/* Clear data ready flag*/
	}
}
