/******************************************************************************								
*    CMPU.c                                                                   *								
*                                                                             *								
*       Created on: 05/06/2012                                                *								
*       Author: B34981                                                        *								
*                                                                             *								
*       The Clock Management and Power Unit module controls the clock gating  *								
*    for the MCU. This driver configures the clocks of the application        *								
******************************************************************************/								


#include "CMPU.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    PLL_Init - Initialize the PLL clock from 4MHz to 32MHz bus clock 
* @param    none
* @return   none
*
************************************************************************************************/  
void PLL_Init()
  {
	CPMUCLKS_PLLSEL = 1;				//FBUS = FPLL/2.   FBUS = 32MHz, 
	CPMUREFDIV_REFFRQ = 1;				//Reference clock between 2MHZ and 6MHZ.	
	CPMUREFDIV_REFDIV = 0x0;		    //FREF=8/(0+1) = 4MHZ		
	CPMUSYNR_VCOFRQ = 0x1;             	//FVCO is between 48MHZ and 80MHZ	
	CPMUSYNR_SYNDIV = 0x7;				//FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x4x(7+1) = 64MHZ
	CPMUPOSTDIV_POSTDIV = 0x0;			//FPLL = FVCO/(POSTDIV+1).  FPLL = 64MHZ/(0+1)    FPLL = 64MHz	
	CPMUOSC_OSCE = 1;					//External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)	
	
	while(!CPMUIFLG_LOCK){}				// Wait for LOCK.      	
		
	CPMUIFLG = 0xFF;					// clear CMPMU int flags - not needed but good practice    
  }

/***********************************************************************************************
*
* @brief    RTI_Init - Initialize the Real Time Interrupt to execute each millisecond 
* @param    none
* @return   none
*
************************************************************************************************/  
void RTI_Init()
{  
  CPMURTI_RTDEC = 1;	//Decimal value
  CPMURTI_RTR = 0x04;	//RTI period and prescaler
  CPMUINT_RTIE = 1; 	//Enable RTI interrupt
}

