/******************************************************************************								
*    RTC.c                                                                    *								
*                                                                             *								
*       Created on: 05/06/2012                                                *								
*       Author: B34981                                                        *								
*                                                                             *								
*       The Real Time Counter module is used to keep accurate time keeping.   *								
*    This driver uses the main oscillator (4 MHz) to count second, minute     *								
*    and hours.                                                               *								
******************************************************************************/								

#include "RTC.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    RTC_Init - Initialize the Real Time Clock module
* @param    none
* @return   none
*
************************************************************************************************/  
void RTC_Init(void)
{
	RTCCTL1_COMPE = 1;		//The read/write bit enables the clock compensation mechanism for clock frequency errors.
	RTCMOD =  31250;		//Modulo register configuration
	RTCCCR_Q = 3;
	RTCCCR_CCS = 0;
	RTCCTL2_RTCPS = 3;
	RTCCTL2_CLKSRC = 0;		//RTCCLK is from OSCCLK
	
	
	RTCS1_SECF = 1;		    //Clear seconds interrupt flag
	RTCCTL4_SECIE = 1; 		//Second interrupt request is enabled.
	RTCCTL1_RTCEN = 1;		//RTC function is enabled.
}