/******************************************************************************								
*    SSG.c                                                                    *								
*                                                                             *								
*       Created on: 05/06/2012                                                *								
*       Author: B34981                                                        *								
*                                                                             *								
*       The Simple Sound Generator module is able of generating tones with    *								
*    automatic amplitude control profiles. This example code plays a single   *								
*    tone with automatic Gong Decay configuration.                            *								
******************************************************************************/								

#include "SSG.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    SSG_Init - Initialize the SSG Module with automatic GONG DECAY control
* @param    none
* @return   none
*
************************************************************************************************/  
void SSG_Init()
{
	UINT16 ssgClockPrescaler = 0xFF;
	UINT16 ssgAmpTh = 0x30;
	UINT16 ssgAmp = 0xFF;
	UINT16 ssgTone = 0x67;  	
	UINT16 ssgDur = 0xA;		
	
	SSG0CR_SSGE = 1;					//Enable SSG Module
	
	SSG0CR_OMS = 1;						//Enable independent Amplitude and Tone output
	
	SSG0ADC_ADE = 1;					//Enable attack/decay functionality
	SSG0ADC_ADM = 0x01;					//Select GONG automatic control
	SSG0ADC_ADS = 1;					//Select decay	
	
	SSG0CR_STP = 0;						//Allow sound to play
		
	SSG0AT = ssgAmpTh; 					//Amplitude threshold		
	SSG0PS = ssgClockPrescaler;			//Clock prescaler	
	SSG0TONE = ssgTone;					//Tone frequency
	SSG0AMP = ssgAmp;					//Tone amplitude

	SSG0DUR = ssgDur;					//Duration		
	
}

/***********************************************************************************************
*
* @brief    SSG_PlaySingleTone - Play a single tone
* @param    none
* @return   none
*
************************************************************************************************/  
void SSG_PlaySingleTone()
{
	SSG0CR_RDR = 1;
	SSG0CR_RDR = 0;
}
