#ifndef __RTC__
#define __RTC__

/* Includes */
#include "derivative.h" /* include peripheral declarations */
#include "FslTypes.h"
#include "Config.h"


/*** Conditional Compilation for Real Time interrupt */



#ifdef SAMPLE_TIME_05_SEG    
# define SAMPLE_TIME        RTCSC_RTCPS3_MASK|RTCSC_RTCPS2_MASK|RTCSC_RTCPS1_MASK
#endif 

#ifdef SAMPLE_TIME_1_SEG
    #define SAMPLE_TIME     RTCSC_RTCPS3_MASK|RTCSC_RTCPS2_MASK|RTCSC_RTCPS1_MASK|RTCSC_RTCPS0_MASK
#endif 

#ifdef SAMPLE_TIME_2_SEG
    #define SAMPLE_TIME     RTCSC_RTCLKS1_MASK|RTCSC_RTCLKS0_MASK|RTCSC_RTCPS2_MASK|RTCSC_RTCPS1_MASK|RTCSC_RTCPS0_MASK
#endif 

#ifdef SAMPLE_TIME_3_SEG
    #define SAMPLE_TIME     RTCSC_RTCLKS1_MASK|RTCSC_RTCLKS0_MASK|
                            RTCSC_RTCPS3_MASK|RTCSC_RTCPS2_MASK|RTCSC_RTCPS1_MASK
#endif 

#ifdef SAMPLE_TIME_6_SEG
    #define SAMPLE_TIME     RTCSC_RTCLKS1_MASK|RTCSC_RTCLKS0_MASK|
                            RTCSC_RTCPS3_MASK|RTCSC_RTCPS2_MASK|RTCSC_RTCPS1_MASK|RTCSC_RTCPS0_MASK
#endif 



/* Prototypes */
void RTC_Init(void);
interrupt VectorNumber_Vrtc void RTI_ISR(void);



#endif /* __RTC__ */
