/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor China Ltd. 2008
*  ALL RIGHTS RESERVED
*
*  File Name: Main.C
*                                                                          
*  Description: This file is main file for SD card reader
*               with USB Bootloader funciton
*                                                                                     
*  Assembler:  Codewarrior for HC(S)08 V6.0
*                                            
*  Version: 1.0                                                         
*                                                                                                                                                         
*  Author: Patrick Yang                              
*                                                                                       
*  Location: Shanghai, P.R.China                                              
*                                                                                                                  
*                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.0   2008.01.09  Patrick Yang  Initial version
* 
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/



#include <hidef.h> 
#include "derivative.h"
#include "FslTypes.h"
#include "USB_Handle.h"
#include "SPI.h"
#include "SD.h"
#include "SCSI_Process.h"

/************************************************************************************
*************************************************************************************
* Global memory declarations
*************************************************************************************
************************************************************************************/

extern byte vCBWBuf_flag; 


/************************************************************************************
*************************************************************************************
*                                    Funcitons                                      *
*************************************************************************************
************************************************************************************/
void main(void) 
{
   
  SOPT2 = 0x00;                 // enable high rate SPI  
  
  PTBDD_PTBDD7 = 0;             // Card detection
  PTBDD_PTBDD6 = 0;             // write portect
	
	
	SPI_Init();
	
	while(SD_DE == kSD_Desert);   // SD Card inserted
	
	(void)SD_Init();
	
	USB_Init();
	
	EnableInterrupts;
	
	
	for(;;) 
  {
    
    if(vCBWBuf_flag==1)
    {
        SCSI_Process();
        vCBWBuf_flag=0;
    }
    
  }
	 
}




/****************************************************************
*****************************************************************
** Below are Bootloader function code                          **
*****************************************************************
****************************************************************/


const byte NVOPT_INIT  @0x0000FFBF = 0x02;    // vector redirect, flash unsecure
const byte NVPROT_INIT @0x0000FFBD = 0xFA;    // 0xFC00-0xFFFF are protected 

extern void _Startup(void);
extern interrupt void USB_ISR(void); 



interrupt void Dummy_ISR(void) {
   asm nop;
}


void (* volatile const _UserEntry[])()@0xFBBC={
  0x9DCC,             // asm NOP(9D), asm JMP(CC)
  _Startup
};
  
// redirect vector 0xFFC0-0xFFFD to 0xFBC0-0xFBFD
void (* volatile const _Usr_Vector[])()@0xFBC4= {
    Dummy_ISR,        // Int.no.29 RTC                (at FFC4)
    Dummy_ISR,        // Int.no.28 IIC                (at FFC6)
    Dummy_ISR,        // Int.no.27 ACMP               (at FFC8)
    Dummy_ISR,        // Int.no.26 ADC                (at FFCA)
    Dummy_ISR,        // Int.no.25 KBI                (at FFCC)
    Dummy_ISR,        // Int.no.24 SCI2 Transmit      (at FFCE)
    Dummy_ISR,        // Int.no.23 SCI2 Receive       (at FFD0)
    Dummy_ISR,        // Int.no.22 SCI2 Error         (at FFD2)
    Dummy_ISR,        // Int.no.21 SCI1 Transmit      (at FFD4)
    Dummy_ISR,        // Int.no.20 SCI1 Receive       (at FFD6)
    Dummy_ISR,        // Int.no.19 SCI1 error         (at FFD8)
    Dummy_ISR,        // Int.no.18 TPM2 Overflow      (at FFDA)
    Dummy_ISR,        // Int.no.17 TPM2 CH1           (at FFDC)
    Dummy_ISR,        // Int.no.16 TPM2 CH0           (at FFDE)
    Dummy_ISR,        // Int.no.15 TPM1 Overflow      (at FFE0)
    Dummy_ISR,        // Int.no.14 TPM1 CH5           (at FFE2)
    Dummy_ISR,        // Int.no.13 TPM1 CH4           (at FFE4)
    Dummy_ISR,        // Int.no.12 TPM1 CH3           (at FFE6)
    Dummy_ISR,        // Int.no.11 TPM1 CH2           (at FFE8)
    Dummy_ISR,        // Int.no.10 TPM1 CH1           (at FFEA)
    Dummy_ISR,        // Int.no.9  TPM1 CH0           (at FFEC)
    Dummy_ISR,        // Int.no.8  Reserved           (at FFEE)
    USB_ISR,          // Int.no.7  USB Statue         (at FFF0)
    Dummy_ISR,        // Int.no.6  SPI2               (at FFF2)
    Dummy_ISR,        // Int.no.5  SPI1               (at FFF4)
    Dummy_ISR,        // Int.no.4  Loss of lock       (at FFF6)
    Dummy_ISR,        // Int.no.3  LVI                (at FFF8)
    Dummy_ISR,        // Int.no.2  IRQ                (at FFFA)
    Dummy_ISR,        // Int.no.1  SWI                (at FFFC) 
};



#pragma CODE_SEG Bootloader_ROM

void Bootloader_Main(void);

void _Entry(void) 
{
        
  SOPT1 = 0x13;                   // disable COP                 
  
  PTGDD_PTGDD0 = 0;               // PTG0 is input
  PTGPE_PTGPE0 = 1;               // internal pullup for PTG0
  
    
  
  MCGC2 = 0x36;
  while(!(MCGSC & 0x02));		      //wait for the OSC stable
  MCGC1 = 0x98;
  while((MCGSC & 0x1C ) != 0x08); // external clock is selected
	MCGC3 = 0x48;
	while ((MCGSC & 0x48) != 0x48);	//wait for the PLL is locked
	MCGC1 = 0x18;
  while((MCGSC & 0x6C) != 0x6C);
	

  // Mode selection  
  if(PTGD_PTGD0) {
    asm JMP _UserEntry;           // Enter User Mode
  } 
  
  // Enter Bootloader Mode
  else {
                             
    USBCTL0=0x44;
    //USBCTL0=0x00;                 // external Reg & pullup and PHY enable             
    
    Bootloader_Main();            // Enter bootloader code
   }

} // _Entry end













