/******************************************************************************
*
*   (c) Copyright 2014 Freescale Semiconductor, Inc.
*   All Rights Reserved.
*
******************************************************************************/
/*!
*
* @file       GFLIB_Cos.h
*
* @version    1.0.6.0
*
* @date       Mar-10-2014
*
* @brief      Header file for GFLIB_Cos function
*
******************************************************************************/
#ifndef GFLIB_COS_H
#define GFLIB_COS_H

#ifdef __cplusplus
extern "C" {
#endif

/**
* @page misra_violations MISRA-C:2004 violations
*
* @section GFLIB_Cos_h_REF_1
* Violates MISRA 2004 Required Rule 19.4, Disallowed definition for macro.
* To allow the user utilize the benefits of using all three supported implementation of each
* function in user application, the macro dispatcher inevitably requires use of disallowed macro
* definition.
*
* @section GFLIB_Cos_h_REF_2
* Violates MISRA 2004 Advisory Rule 19.7, Function-like macro defined.
* To allow the user utilize the benefits of using all three supported implementation of each
* function in user application, the macro dispatcher inevitably requires the function-like macro
* definition.
*
* @section GFLIB_Cos_h_REF_3
* Violates MISRA 2004 Required Rule 19.10, Unparenthesized macro parameter in definition of macro.
* To allow the user utilize the benefits of using all three supported implementation of each
* function in user application, the macro dispatcher inevitably requires use of unparenthesized
* macro parameters.
*
* @section GFLIB_Cos_h_REF_4
* Violates MISRA 2004 Advisory Rule 19.13, #/##' operator used in macro.
* To allow the user utilize the benefits of using all three supported implementation of each
* function in user application, the macro dispatcher inevitably requires use of '#/##' operators.
*/
#include "SWLIBS_Typedefs.h"
#include "SWLIBS_Defines.h"
#include "SWLIBS_MacroDisp.h"
#include "mlib.h"

/****************************************************************************
* Defines and macros            (scope: module-local)
****************************************************************************/
  /*
  * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for macro.
  * @violates @ref GFLIB_Cos_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro defined.
  * @violates @ref GFLIB_Cos_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro parameter
  * in definition of macro.
  */
  #define GFLIB_Cos(...)     macro_dispatcher(GFLIB_Cos, __VA_ARGS__)(__VA_ARGS__)     /*!< This function implements polynomial approximation of cosine function. */

  #if (SWLIBS_DEFAULT_IMPLEMENTATION == SWLIBS_DEFAULT_IMPLEMENTATION_F32)
    /*
    * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
    * macro.
    */
    #define GFLIB_COS_T                        GFLIB_COS_T_F32                           /*!< Definition of GFLIB_COS_T as alias for GFLIB_COS_T_F32 datatype in case the 32-bit fractional implementation is selected. */
    /*
    * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
    * macro.
    */
    #define GFLIB_COS_DEFAULT                  GFLIB_COS_DEFAULT_F32                     /*!< Definition of GFLIB_COS_DEFAULT as alias for GFLIB_COS_DEFAULT_F32 default value in case the 32-bit fractional implementation is selected. */
    /*
    * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
    * macro.
    * @violates @ref GFLIB_Cos_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro defined.
    * @violates @ref GFLIB_Cos_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
    * parameter in definition of macro.
    */
    #define GFLIB_Cos_Dsptchr_2(In,pParam)     GFLIB_Cos_Dsptchr_3(In,pParam,F32)        /*!< Function dispatcher for GFLIB_Cos_Dsptchr_2, do not modify!!! */
    /*
    * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
    * macro.
    * @violates @ref GFLIB_Cos_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro defined.
    * @violates @ref GFLIB_Cos_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
    * parameter in definition of macro.
    */
    /** @remarks Implements DGFLIB00022 */
    #define GFLIB_Cos_Dsptchr_1(In)            GFLIB_Cos_Dsptchr_2(In,GFLIB_COS_DEFAULT) /*!< Function dispatcher for GFLIB_Cos_Dsptchr_1, do not modify!!! */
  #endif
  #if (SWLIBS_DEFAULT_IMPLEMENTATION == SWLIBS_DEFAULT_IMPLEMENTATION_F16)
    /*
    * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
    * macro.
    */
    #define GFLIB_COS_T                        GFLIB_COS_T_F16                           /*!< Definition of GFLIB_COS_T as alias for GFLIB_COS_T_F16 datatype in case the 16-bit fractional implementation is selected. */
    /*
    * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
    * macro.
    */
    #define GFLIB_COS_DEFAULT                  GFLIB_COS_DEFAULT_F16                     /*!< Definition of GFLIB_COS_DEFAULT as alias for GFLIB_COS_DEFAULT_F16 default value in case the 16-bit fractional implementation is selected. */
    /*
    * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
    * macro.
    * @violates @ref GFLIB_Cos_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro defined.
    * @violates @ref GFLIB_Cos_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
    * parameter in definition of macro.
    */
    #define GFLIB_Cos_Dsptchr_2(In,pParam)     GFLIB_Cos_Dsptchr_3(In,pParam,F16)        /*!< Function dispatcher for GFLIB_Cos_Dsptchr_2, do not modify!!! */
    /*
    * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
    * macro.
    * @violates @ref GFLIB_Cos_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro defined.
    * @violates @ref GFLIB_Cos_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
    * parameter in definition of macro.
    */
    /** @remarks Implements DGFLIB00022 */
    #define GFLIB_Cos_Dsptchr_1(In)            GFLIB_Cos_Dsptchr_2(In,GFLIB_COS_DEFAULT) /*!< Function dispatcher for GFLIB_Cos_Dsptchr_1, do not modify!!! */
  #endif

  /*
  * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for macro.
  * @violates @ref GFLIB_Cos_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro defined.
  * @violates @ref GFLIB_Cos_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro parameter
  * in definition of macro.
  */
  #define GFLIB_Cos_Dsptchr_3(In,pParam,Impl)    GFLIB_Cos_Dsptchr_(In,pParam,Impl)     /*!< Function dispatcher for GFLIB_Cos_Dsptchr_3, do not modify!!! */

  /*
  * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for macro.
  * @violates @ref GFLIB_Cos_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro defined.
  * @violates @ref GFLIB_Cos_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro parameter
  * in definition of macro.
  * @violates @ref GFLIB_Cos_h_REF_4 MISRA 2004 Advisory Rule 19.13, #/##' operator used in macro.
  */
  /** @remarks Implements DGFLIB00024 */
  #define GFLIB_Cos_Dsptchr_(In,pParam,Impl)     GFLIB_Cos_##Impl(In,pParam)            /*!< Function dispatcher for GFLIB_Cos_Dsptchr_, do not modify!!! */

/****************************************************************************
* Typedefs and structures       (scope: module-local)
****************************************************************************/




/****************************************************************************
* Implementation variant: 32-bit fractional
****************************************************************************/
#if (SWLIBS_SUPPORT_F32 == SWLIBS_STD_ON)
  /*
  * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for macro.
  */
  #define GFLIB_COS_DEFAULT_F32 &f32gflibCosCoef     /*!< Default approximation coefficients for GFLIB_Cos_F32 function. */

  /************************************************************************/
  /*!
  @struct GFLIB_COS_T_F32 "\GFLIB_Cos.h"

  @brief  Array of five 32-bit elements for storing coefficients of the Taylor polynomial.
  *//**********************************************************************/
  typedef struct{
    tFrac32  f32A[5];
  }GFLIB_COS_T_F32;

  /************************************************************************/
  /*!
  @brief  Default approximation coefficients for cosine approximation.
  *//**********************************************************************/
  extern const GFLIB_COS_T_F32 f32gflibCosCoef;

/****************************************************************************
* Exported function prototypes
****************************************************************************/
  extern tFrac32 GFLIB_Cos_F32(tFrac32 f32In,const GFLIB_COS_T_F32 *const pParam);
#endif /* SWLIBS_SUPPORT_F32 == SWLIBS_STD_ON */




/****************************************************************************
* Implementation variant: 16-bit fractional
****************************************************************************/
#if (SWLIBS_SUPPORT_F16 == SWLIBS_STD_ON)
  /*
  * @violates @ref GFLIB_Cos_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for macro.
  */
  #define GFLIB_COS_DEFAULT_F16 &f16gflibCosCoef     /*!< Default approximation coefficients for GFLIB_Cos_F32 function. */

  /************************************************************************/
  /*!
  @struct GFLIB_COS_T_F16 "\GFLIB_Cos.h"

  @brief  Array of four 16-bit elements for storing coefficients of the Taylor polynomial.
  *//**********************************************************************/
  typedef struct{
    tFrac16  f16A[4];
  }GFLIB_COS_T_F16;

  /************************************************************************/
  /*!
  @brief  Default approximation coefficients for cosine approximation.
  *//**********************************************************************/
  extern const GFLIB_COS_T_F16 f16gflibCosCoef;

/****************************************************************************
* Exported function prototypes
****************************************************************************/
  extern tFrac16 GFLIB_Cos_F16(tFrac16 f16In,const GFLIB_COS_T_F16 *const pParam);
#endif /* SWLIBS_SUPPORT_F16 == SWLIBS_STD_ON */




#ifdef __cplusplus
}
#endif

#endif /* GFLIB_COS_H */
