/*
 * Copyright 2013, 2020, 2023 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software specific Symmetric Cryptography Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHCRYPTOSYM_STUB_H
#define PHCRYPTOSYM_STUB_H

#include <ph_Status.h>
#include <ph_RefDefs.h>
#include <phCryptoSym.h>


phStatus_t phCryptoSym_Stub_InvalidateKey(phCryptoSym_Stub_DataParams_t * pDataParams);

phStatus_t phCryptoSym_Stub_Encrypt(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wOption, const uint8_t * pPlainBuffer,
    uint16_t  wBufferLength, uint8_t * pEncryptedBuffer);

phStatus_t phCryptoSym_Stub_Decrypt(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wOption, const uint8_t * pEncryptedBuffer,
    uint16_t  wBufferLength, uint8_t * pPlainBuffer);

phStatus_t phCryptoSym_Stub_CalculateMac(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wOption, const uint8_t * pData,
    uint16_t  wDataLength, uint8_t * pMac, uint8_t * pMacLength);

phStatus_t phCryptoSym_Stub_LoadIv(phCryptoSym_Stub_DataParams_t * pDataParams, const uint8_t * pIV, uint8_t bIVLength);

phStatus_t phCryptoSym_Stub_LoadNonce(phCryptoSym_Stub_DataParams_t * pDataParams, uint8_t bCipher, const uint8_t * pNonce,
    uint8_t bNonceLen);

phStatus_t phCryptoSym_Stub_LoadAdditionalData(phCryptoSym_Stub_DataParams_t * pDataParams, const uint8_t * pAddData,
    uint16_t wAddData_Len);

phStatus_t phCryptoSym_Stub_LoadKey(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVersion, uint16_t wKeyType);

phStatus_t phCryptoSym_Stub_LoadKeyDirect(phCryptoSym_Stub_DataParams_t * pDataParams, const uint8_t * pKey, uint16_t wKeyType);

phStatus_t phCryptoSym_Stub_DiversifyKey(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVersion,
    uint8_t * pDivInput, uint8_t  bLenDivInput, uint8_t * pDiversifiedKey, uint8_t * pDivKeyLen);

phStatus_t phCryptoSym_Stub_DiversifyDirectKey(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pKey,
    uint16_t wKeyType, uint8_t * pDivInput, uint8_t bLenDivInput, uint8_t * pDiversifiedKey, uint8_t * pDivKeyLen);

phStatus_t phCryptoSym_Stub_SetConfig(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phCryptoSym_Stub_GetConfig(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phCryptoSym_Stub_SetAuthenticationTag(phCryptoSym_Stub_DataParams_t * pDataParams, const uint8_t * pTag, uint8_t bTag_Len);

phStatus_t phCryptoSym_Stub_GetAuthenticationTag(phCryptoSym_Stub_DataParams_t * pDataParams, const uint8_t * pTag, uint8_t * pTag_Len);

#endif /* PHCRYPTOSYM_STUB_H */
