/*
 * Copyright 2013, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * RC632 functions of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHKEYSTORE_RC632_INT_H
#define PHKEYSTORE_RC632_INT_H

#include <ph_Status.h>

#define PH_KEYSTORE_RC632_EEP_KEY_BASE_ADDR     0x80U   /**< Base address of keys storage in eeprom of RC632. */
#define PH_KEYSTORE_RC632_EEP_KEY_LENGTH        24U     /**< Size needed in eeprom to store a (mifare) key. */
#define PH_KEYSTORE_RC632_EEP_WR_TO_MS          12U     /**< Time out to perform EEPROM write in milliseconds. */

/**
* \name Rc632 register definitions
*/
/** @{ */
#define PH_KEYSTORE_RC632_REG_COMMAND           0x01U   /**< Command register. */
#define PH_KEYSTORE_RC632_REG_FIFO_DATA         0x02U   /**< FIFO register. */
#define PH_KEYSTORE_RC632_REG_SECONDARY_STATUS  0x05U   /**< Secondary status register. */
#define PH_KEYSTORE_RC632_REG_INT_EN            0x06U   /**< Interrupt enable register. */
#define PH_KEYSTORE_RC632_REG_INT_REQ           0x07U   /**< Interrupt request register. */
#define PH_KEYSTORE_RC632_REG_CONTROL           0x09U   /**< Control register. */

/* Secondary status register (05) */
#define PH_KEYSTORE_RC632_BIT_E2READY           0x40U   /**< Set by IC when E2 programming is finished. */

/* Control register (09) */
#define PH_KEYSTORE_RC632_BIT_FLUSHFIFO         0x01U   /**< Clears internal FIFO buffer when set. */

/* Command set */
#define PH_KEYSTORE_RC632_CMD_IDLE              0x00    /**< Set IC to IDLE state. */
#define PH_KEYSTORE_RC632_CMD_WRITE_E2          0x01    /**< Set IC to IDLE state. */
/** @} */

/**
* \brief Write EEPROM command implementation.
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
*/
phStatus_t phKeyStore_Rc632_WriteE2_Int(
                                        phKeyStore_Rc632_DataParams_t * pDataParams,    /**< [In] Pointer to this layer's parameter structure. */
                                        uint8_t    * pData,                                /**< [In] Data to write to EEPROM. */
                                        uint16_t DataLength                             /**< [In] Length of Data to be written. */
                                        );

#endif /* PHKEYSTORE_RC632_INT_H */
