/*
 * Copyright 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/**
 * \file
 * SAM X MIFARE NTAG 42xDNA Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  SDA: Generated 23. April 2010
 *
 */

#ifndef PHALMFNTAG42XDNA_SAM_X_H
#define PHALMFNTAG42XDNA_SAM_X_H

#include <phCryptoSym.h>
#include <phalMfNtag42XDna.h>

#define PHAL_MFNTAG42XDNA_SAM_X_AUTH_KEY_DIV_ENABLED            0x0001U		/**< Bit 0 of P1. Indicating diversification of new key requred. */
#define PHAL_MFNTAG42XDNA_SAM_X_AUTH_KEY_DIV_MODE               (0x0018 >> 3)	/**< Bit 3-4 of P1. Indicating diversification mode. */

/* MIFARE NTAG 42xDNA secure messaging related commands. ----------------------------------------------------------------------------- */
phStatus_t phalMfNtag42XDna_Sam_X_AuthenticateEv2(void *pDataParams, uint8_t bAuthType, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bKeyNoCard,
	uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pPcdCapsIn, uint8_t bPcdCapsInLen, uint8_t * pPcdCapsOut, uint8_t * pPdCapsOut);




/* MIFARE NTAG 42xDNA Memory and Configuration mamangement commands. ----------------------------------------------------------------- */
phStatus_t phalMfNtag42XDna_Sam_X_SetConfiguration(void * pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalMfNtag42XDna_Sam_X_GetVersion(void * pDataParams, uint8_t * pVerInfo, uint8_t * pVerLen);

phStatus_t phalMfNtag42XDna_Sam_X_GetCardUID(void * pDataParams, uint8_t * pUid, uint8_t * pUidLen);




/* MIFARE NTAG 42xDNA Key mamangement commands. -------------------------------------------------------------------------------------- */
phStatus_t phalMfNtag42XDna_Sam_X_ChangeKey(void * pDataParams, uint16_t wOption, uint16_t wCurrKeyNo, uint16_t wCurrKeyVer, uint16_t wNewKeyNo, uint16_t wNewKeyVer,
	uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfNtag42XDna_Sam_X_GetKeyVersion(void * pDataParams, uint8_t bKeyNo, uint8_t * pKeyVersion, uint8_t * pKeyVerLen);




/* MIFARE NTAG 42xDNA File mamangement commands. ------------------------------------------------------------------------------------- */
phStatus_t phalMfNtag42XDna_Sam_X_GetFileSettings(void * pDataParams, uint8_t bFileNo, uint8_t * pFSBuffer, uint8_t * pBufferLen);

phStatus_t phalMfNtag42XDna_Sam_X_GetFileCounters(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pResponse, uint8_t * pRespLen);

phStatus_t phalMfNtag42XDna_Sam_X_ChangeFileSettings(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights);

phStatus_t phalMfNtag42XDna_Sam_X_ChangeFileSettingsSDM(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights,
	uint8_t bSdmOptions, uint8_t * pSdmAccessRights, uint8_t * pVCUIDOffset, uint8_t * pSDMReadCtrOffset, uint8_t * pPICCDataOffset,
	uint8_t * pTTPermStatusOffset, uint8_t * pSDMMACInputOffset, uint8_t * pSDMENCOffset, uint8_t * pSDMENCLen, uint8_t * pSDMMACOffset,
	uint8_t * pSDMReadCtrLimit);




/* MIFARE NTAG 42xDNA Data mamangement commands. ------------------------------------------------------------------------------------- */
phStatus_t phalMfNtag42XDna_Sam_X_ReadData(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pLength, uint8_t ** ppResponse,
	uint16_t * pRespLen);

phStatus_t phalMfNtag42XDna_Sam_X_WriteData(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pData, uint8_t * pDataLen);





/* MIFARE NTAG 42xDNA ISO7816-4 commands. -------------------------------------------------------------------------------------------- */
phStatus_t phalMfNtag42XDna_Sam_X_IsoSelectFile(void * pDataParams, uint8_t bOption, uint8_t bSelector, uint8_t * pFid, uint8_t * pDFname, uint8_t bDFnameLen,
	uint8_t	bExtendedLenApdu, uint8_t ** ppFCI, uint16_t * pFCILen);

phStatus_t phalMfNtag42XDna_Sam_X_IsoReadBinary(void * pDataParams, uint16_t wOption, uint8_t bOffset, uint8_t bSfid, uint32_t dwBytesToRead, uint8_t bExtendedLenApdu,
	uint8_t ** ppResponse, uint16_t * pBytesRead);

phStatus_t phalMfNtag42XDna_Sam_X_IsoUpdateBinary(void * pDataParams, uint8_t bOffset, uint8_t bSfid, uint8_t bExtendedLenApdu, uint8_t * pData, uint32_t dwDataLen);




/* MIFARE NTAG 42xDNA Originality Check functions. ----------------------------------------------------------------------------------- */
phStatus_t phalMfNtag42XDna_Sam_X_ReadSign(void * pDataParams, uint8_t bAddr, uint8_t ** pSignature);




/* MIFARE NTAG 42xDNA Tag Tamper Protection functions. ------------------------------------------------------------------------------- */
phStatus_t phalMfNtag42XDna_Sam_X_GetTagTamperStatus(void * pDataParams, uint8_t * pResponse, uint8_t * pRespLen);




/* MIFARE NTAG 42xDNA Miscellaneous functions. --------------------------------------------------------------------------------------- */
phStatus_t phalMfNtag42XDna_Sam_X_GetConfig(void * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalMfNtag42XDna_Sam_X_SetConfig(void * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phalMfNtag42XDna_Sam_X_ResetAuthentication(void * pDataParams);

phStatus_t phalMfNtag42XDna_Sam_X_CalculateMACSDM(void * pDataParams, uint8_t bSdmOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer,
	uint16_t wDstKeyNo, uint16_t wDstKeyVer, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr, uint8_t * pInData, uint16_t wInDataLen,
	uint8_t * pMac);

phStatus_t phalMfNtag42XDna_Sam_X_DecryptSDMENCFileData(void * pDataParams, uint8_t bSdmOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer,
	uint16_t wDstKeyNo, uint16_t wDstKeyVer, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr, uint8_t * pEncdata,
	uint16_t wEncDataLen, uint8_t * pPlainData);

phStatus_t phalMfNtag42XDna_Sam_X_DecryptSDMPICCData(void * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t * pEncdata,
	uint16_t wEncDataLen, uint8_t * pPlainData);

#endif /* PHALMFNTAG42XDNA_SAM_X_H */
