/*
 * Copyright 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef PHALMFDF_SAM_X_INT_H
#define PHALMFDF_SAM_X_INT_H

#include <ph_Status.h>
#include <phalMfdf.h>
#include <phhalHw_SamAV2_Cmd.h>

#ifdef NXPBUILD__PHAL_MFUL_SAMAV3_X
#include <phhalHw_SamAV3_Cmd.h>
#endif /* NXPBUILD__PHAL_MFUL_SAMAV3_X */

#define PHAL_MFDF_MAX_WRITE_LEN		60			/* The default frame size is 64 bytes. So if the Write related commands need to transmitted to the PICC via SAM,
												 * the command including the data to be written and excluding PICC header comes to 60 bytes.
												 */

/* Authenticate command ============================================================================================================================================== */
#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_SAM_CMD_DESFIRE_AUTHENTICATE(DataParams, Option, ISOMode, DFKeyNo, KeyNo, KeyVer, DivInput, DivInPutLen, PICCRetCode)						\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SamAV2_Cmd_DESFireAuthenticatePICC(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, Option, ISOMode,				\
				DFKeyNo, KeyNo, KeyVer, DivInput, DivInPutLen) :																							\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_DESFire_AuthenticatePICC(((phalMfdf_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams, Option, ISOMode,			\
				DFKeyNo, KeyNo, KeyVer, 0, NULL, DivInput, DivInPutLen, NULL, NULL, PICCRetCode) :															\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_SAM_CMD_DESFIRE_AUTHENTICATE(DataParams, Option, ISOMode, DFKeyNo, KeyNo, KeyVer, DivInput, DivInPutLen, PICCRetCode)						\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SamAV2_Cmd_DESFireAuthenticatePICC(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, Option, ISOMode,				\
				DFKeyNo, KeyNo, KeyVer, DivInput, DivInPutLen) :																							\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

/* ChangeKey command ================================================================================================================================================= */
#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_SAM_CMD_DESFIRE_CHANGEKEY(DataParams, KeyCompMeth, Cfg, CurrKeyNo, CurrKeyVer, NewKeyNo, NewKeyVer, DivInput, DivInPutLen, PICCRetCode)	\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SamAV2_Cmd_DESFireChangeKeyPICC(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, KeyCompMeth, Cfg,				\
				CurrKeyNo, CurrKeyVer, NewKeyNo, NewKeyVer, DivInput, DivInPutLen) :																		\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_DESFire_ChangeKeyPICC(((phalMfdf_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams, KeyCompMeth, Cfg,				\
				0, 0, CurrKeyNo, CurrKeyVer, NewKeyNo, NewKeyVer, DivInput, DivInPutLen, PICCRetCode) :														\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_SAM_CMD_DESFIRE_CHANGEKEY(DataParams, KeyCompMeth, Cfg, CurrKeyNo, CurrKeyVer, NewKeyNo, NewKeyVer, DivInput, DivInPutLen, PICCRetCode)	\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SamAV2_Cmd_DESFireChangeKeyPICC(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, KeyCompMeth, Cfg,				\
				CurrKeyNo, CurrKeyVer, NewKeyNo, NewKeyVer, DivInput, DivInPutLen) :																		\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

/* ReadX command ===================================================================================================================================================== */
#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_SAM_CMD_DESFIRE_READX(DataParams, Option, Crypto, AppData, AppDataLen, Response, RespLen, PICCRetCode, PiccRetLen)							\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SamAV2_Cmd_DESFireReadX(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, Option, Crypto, AppData, 				\
				AppDataLen, Response, RespLen) :																											\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_DESFire_ReadX(((phalMfdf_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams, Option, Crypto, AppData, 				\
				AppDataLen, Response, RespLen, PICCRetCode, PiccRetLen) :																					\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_SAM_CMD_DESFIRE_READX(DataParams, Option, Crypto, AppData, AppDataLen, Response, RespLen, PICCRetCode, PiccRetLen)							\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SamAV2_Cmd_DESFireReadX(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, Option, Crypto, AppData, 				\
				AppDataLen, Response, RespLen) :																											\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

/* WriteX command ==================================================================================================================================================== */
#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_SAM_CMD_DESFIRE_WRITEX(DataParams, Option, Crypto, Data, DataLen, PICCRetCode, PiccRetLen)													\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SamAV2_Cmd_DESFireWriteX(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, Option, Crypto, Data, 					\
				DataLen) :																																	\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_DESFire_WriteX(((phalMfdf_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams, Option, Crypto, Data, 				\
				DataLen, PICCRetCode, PiccRetLen) :																											\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_SAM_CMD_DESFIRE_WRITEX(DataParams, Option, Crypto, Data, DataLen, PICCRetCode, PiccRetLen)													\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SamAV2_Cmd_DESFireWriteX(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, Option, Crypto, Data, 					\
				DataLen) :																																	\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

/* KillAuthentication command ======================================================================================================================================== */
#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_KILL_AUTHENTICATION(DataParams)																											\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SamAV2_Cmd_SAM_KillAuthentication(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, 0x01 ) :						\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_SAM_KillAuthentication(((phalMfdf_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams, 0x01 ) :						\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_KILL_AUTHENTICATION(DataParams)																											\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SamAV2_Cmd_SAM_KillAuthentication(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, 0x01 ) :						\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

/* GetConfig command ================================================================================================================================================= */
#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_GET_CONFIG(DataParams, Config, Value)																										\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_GetConfig(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, Config, Value ) :										\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV3_X_ID) ?																							\
				phhalHw_GetConfig(((phalMfdf_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams, Config, Value ) :										\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_GET_CONFIG(DataParams, Config, Value)																										\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_GetConfig(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, Config, Value ) :										\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

/* SetConfig command ================================================================================================================================================= */
#ifdef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_SET_CONFIG(DataParams, Config, Value)																										\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SetConfig(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, Config, Value ) :										\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV3_X_ID) ?																							\
				phhalHw_SetConfig(((phalMfdf_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams, Config, Value ) :										\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFDF_SAMAV3_X
#define PHHAL_HW_SET_CONFIG(DataParams, Config, Value)																										\
			(PH_GET_COMPID(DataParams) == PHAL_MFDF_SAMAV2_X_ID) ? 																							\
				phhalHw_SetConfig(((phalMfdf_SamAV2_X_DataParams_t *) DataParams)->pHalSamDataParams, Config, Value ) :										\
																																							\
				PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFDF)
#endif /* NXPBUILD__PHAL_MFDF_SAMAV3_X */

phStatus_t phalMfdf_Sam_X_Int_SetAuthMode(void * pDataParams, uint8_t bAuthMode);
phStatus_t phalMfdf_Sam_X_Int_GetAuthMode(void * pDataParams, uint8_t * pAuthMode);

phStatus_t phalMfdf_Sam_X_Int_SetKeyNo(void * pDataParams, uint8_t bKeyNo);
phStatus_t phalMfdf_Sam_X_Int_GetKeyNo(void * pDataParams, uint8_t * pKeyNo);

phStatus_t phalMfdf_Sam_X_Int_SetWrappedMode(void * pDataParams, uint8_t bWrappedMode);
phStatus_t phalMfdf_Sam_X_Int_GetWrappedMode(void * pDataParams, uint8_t * pWrappedMode);

phStatus_t phalMfdf_Sam_X_Int_SetAdditionalInfo(void * pDataParams, uint16_t wAdditionalInfo);
phStatus_t phalMfdf_Sam_X_Int_GetAdditionalInfo(void * pDataParams, uint16_t * pAdditionalInfo);

phStatus_t phalMfdf_Sam_X_Int_SetAid(void * pDataParams, uint8_t * pAid);
phStatus_t phalMfdf_Sam_X_Int_GetAid(void * pDataParams, uint8_t * pAid);

phStatus_t phalMfdf_Sam_X_Int_ValidateResponse(void * pDataParams, uint16_t wStatus, uint8_t * pPiccRetCode);

phStatus_t phalMfdf_Sam_X_Int_Iso7816Wrap(void * pDataParams, uint8_t bLengthPresent, uint8_t bLengthLen, uint8_t bLePresent, uint8_t * pPlainData, uint8_t * pDataLen);

phStatus_t phalMfdf_Sam_X_Int_WriteX(void * pDataParams, uint16_t wOption, uint8_t bCommMode, uint8_t * pData, uint8_t bDataLen, uint8_t bDataOffset, uint8_t bIsDataComd);

phStatus_t phalMfdf_Sam_X_Int_ReadX(void * pDataParams, uint16_t wOption, uint8_t bCommMode, uint8_t * pAppData, uint8_t bAppDataLen, uint8_t bLenPresent, uint8_t bLen,
	uint8_t ** ppResponse, uint16_t * pRespLen);
#endif /* PHALMFDF_SAM_X_INT_H */
