/*
 * Copyright 2020, 2023 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/**
 * \file
 * Software MIFARE DESFire Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  SDA: Generated 23. April 2010
 *
 */

#ifndef PHALMFDFEVX_SAM_X_H
#define PHALMFDFEVX_SAM_X_H

#include <phCryptoSym.h>
#include <phalMfdfEVx.h>

#define PHAL_MFDFEVX_SAM_X_AUTH_KEY_DIV_ENABLED            0x0001U /**< Bit 0 of P1. Indicating diversification of new key required. */
#define PHAL_MFDFEVX_SAM_X_AUTH_KEY_DIV_MODE               (0x0018 >> 3) /**< Bit 3-4 of P1. Indicating diversification mode. */

/* Valid SAM's NVM and RAM KeyStore Keys numbers */
#define IS_VALID_SAM_KEYS(Key)              ((Key) > 0x7FU) && (((Key) < 0xE0U) || ((Key) > 0xE3U))

/* Valid SAM's RAM KeyStore Keys numbers */
#define IS_VALID_SAM_RAM_KEYS(Key)          ((Key) < 0xE0U) || ((Key) > 0xE3U)

/* APP level keys are invalid between 0x0D to 0x21. */
 #define IS_INVALID_APP_KEY(KeyNo)  ((((KeyNo) & 0x7FU) > 0x0DU) && (((KeyNo) & 0x7FU) < 0x21U))

/* VC keys are invalid after 0x23. */
 #define IS_INVALID_VC_KEY(KeyNo)   (((KeyNo) & 0x7FU) > 0x23U)


/* MIFARE DESFire EVx secure messaging related commands. ------------------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_Authenticate(void *pDataParams, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfEVx_Sam_X_AuthenticateISO(void *pDataParams, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfEVx_Sam_X_AuthenticateAES(void *pDataParams, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfEVx_Sam_X_AuthenticateEv2(void *pDataParams, uint8_t bFirstAuth, uint16_t wOption, uint16_t wKeyNo,
    uint16_t wKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pPcdCapsIn,
    uint8_t bPcdCapsInLen, uint8_t * pPcdCapsOut, uint8_t * pPdCapsOut);




/* MIFARE DESFire EVx Memory and Configuration management commands. -------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_FreeMem(void * pDataParams, uint8_t * pMemInfo);

phStatus_t phalMfdfEVx_Sam_X_FormatPICC(void * pDataParams);

phStatus_t phalMfdfEVx_Sam_X_SetConfiguration(void * pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalMfdfEVx_Sam_X_GetVersion(void * pDataParams, uint8_t * pVerInfo, uint8_t * pVerLen);

phStatus_t phalMfdfEVx_Sam_X_GetCardUID(void * pDataParams, uint8_t bExchangeOption, uint8_t bOption, uint8_t * pUid,
    uint8_t * pUidLen);




/* MIFARE DESFire EVx Key management commands. ----------------------------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_ChangeKey(void * pDataParams, uint16_t wOption, uint16_t wOldKeyNo, uint16_t wOldKeyVer,
    uint16_t wNewKeyNo, uint16_t wNewKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfEVx_Sam_X_ChangeKeyEv2(void * pDataParams, uint16_t wOption, uint16_t wOldKeyNo, uint16_t wOldKeyVer,
    uint16_t wNewKeyNo, uint16_t wNewKeyVer, uint8_t bKeySetNo, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfEVx_Sam_X_InitializeKeySet(void * pDataParams, uint8_t bKeySetNo, uint8_t bKeyType);

phStatus_t phalMfdfEVx_Sam_X_FinalizeKeySet(void * pDataParams, uint8_t bKeySetNo, uint8_t bKeyVersion);

phStatus_t phalMfdfEVx_Sam_X_RollKeySet(void * pDataParams, uint8_t bKeySetNo);

phStatus_t phalMfdfEVx_Sam_X_GetKeySettings(void * pDataParams, uint8_t * pKeySettings, uint8_t * pKeySettingLen);

phStatus_t phalMfdfEVx_Sam_X_ChangeKeySettings(void * pDataParams, uint8_t bKeySettings);

phStatus_t phalMfdfEVx_Sam_X_GetKeyVersion(void * pDataParams, uint8_t bKeyNo, uint8_t bKeySetNo, uint8_t * pKeyVersion,
    uint8_t * pKeyVerLen);




/* MIFARE DESFire EVx Application management commands. --------------------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_CreateApplication(void * pDataParams, uint8_t bOption, uint8_t * pAid, uint8_t bKeySettings1,
    uint8_t bKeySettings2, uint8_t bKeySettings3, uint8_t * pKeySetValues, uint8_t * pISOFileId,  uint8_t * pISODFName,
    uint8_t bISODFNameLen);

phStatus_t phalMfdfEVx_Sam_X_DeleteApplication(void * pDataParams, uint8_t * pAid, uint8_t * pDAMMAC, uint8_t bDAMMAC_Len);

phStatus_t phalMfdfEVx_Sam_X_CreateDelegatedApplication(void * pDataParams, uint8_t bOption, uint8_t * pAid, uint8_t * pDamParams,
    uint8_t bKeySettings1, uint8_t bKeySettings2, uint8_t bKeySettings3, uint8_t * pKeySetValues, uint8_t * pISOFileId,
    uint8_t * pISODFName, uint8_t bISODFNameLen, uint8_t * pEncK, uint8_t * pDAMMAC);

phStatus_t phalMfdfEVx_Sam_X_SelectApplication(void * pDataParams, uint8_t bOption, uint8_t * pAid, uint8_t * pAppId2);

phStatus_t phalMfdfEVx_Sam_X_GetApplicationIDs(void * pDataParams, uint8_t bOption, uint8_t ** ppAidBuff, uint8_t * pNumAid);

phStatus_t phalMfdfEVx_Sam_X_GetDFNames(void * pDataParams, uint8_t bOption, uint8_t * pDFBuffer, uint8_t * bNumOfEntries);

phStatus_t phalMfdfEVx_Sam_X_GetDelegatedInfo(void * pDataParams, uint8_t * pDAMSlot, uint8_t * pDamSlotVer, uint8_t * pQuotaLimit,
    uint8_t * pFreeBlocks, uint8_t * pAid);




/* MIFARE DESFire EVx File management commands. ---------------------------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_CreateStdDataFile(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pISOFileId,
    uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pFileSize);

phStatus_t phalMfdfEVx_Sam_X_CreateBackupDataFile(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pISOFileId,
    uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pFileSize);

phStatus_t phalMfdfEVx_Sam_X_CreateValueFile(void * pDataParams, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights,
    uint8_t * pLowerLmit, uint8_t * pUpperLmit, uint8_t * pValue, uint8_t bLimitedCredit);

phStatus_t phalMfdfEVx_Sam_X_CreateLinearRecordFile(void * pDataParams, uint8_t bOption, uint8_t  bFileNo, uint8_t * pISOFileId,
    uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pRecordSize, uint8_t * pMaxNoOfRec);

phStatus_t phalMfdfEVx_Sam_X_CreateCyclicRecordFile(void * pDataParams, uint8_t bOption, uint8_t  bFileNo, uint8_t * pISOFileId,
    uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pRecordSize, uint8_t * pMaxNoOfRec);

phStatus_t phalMfdfEVx_Sam_X_CreateTransactionMacFile(void * pDataParams, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights,
    uint16_t wKeyNo, uint8_t bKeyVer,
    uint8_t bKeyType, uint8_t * pKey, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfEVx_Sam_X_DeleteFile(void * pDataParams, uint8_t bFileNo);

phStatus_t phalMfdfEVx_Sam_X_GetFileIDs(void * pDataParams, uint8_t * pFid, uint8_t * bNumFid);

phStatus_t phalMfdfEVx_Sam_X_GetISOFileIDs(void * pDataParams, uint8_t * pFidBuffer, uint8_t * bNumFid);

phStatus_t phalMfdfEVx_Sam_X_GetFileSettings(void * pDataParams, uint8_t bFileNo, uint8_t * pFSBuffer, uint8_t * pBufferLen);

phStatus_t phalMfdfEVx_Sam_X_GetFileCounters(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pResponse,
    uint8_t * pRespLen);

phStatus_t phalMfdfEVx_Sam_X_ChangeFileSettings(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption,
    uint8_t * pAccessRights, uint8_t bAddInfoLen, uint8_t * pAddInfo);




/* MIFARE DESFire EVx Data management commands. ---------------------------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_ReadData(void * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo, uint8_t * pOffset,
    uint8_t * pLength, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalMfdfEVx_Sam_X_WriteData(void * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo, uint8_t * pOffset,
    uint8_t * pData, uint8_t * pDataLen);

phStatus_t phalMfdfEVx_Sam_X_GetValue(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdfEVx_Sam_X_Credit(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdfEVx_Sam_X_Debit(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdfEVx_Sam_X_LimitedCredit(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdfEVx_Sam_X_ReadRecords(void * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo, uint8_t * pRecNo,
    uint8_t * pRecCount, uint8_t * pRecSize, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalMfdfEVx_Sam_X_WriteRecord(void * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo, uint8_t * pOffset,
    uint8_t * pData, uint8_t * pDataLen);

phStatus_t phalMfdfEVx_Sam_X_UpdateRecord(void * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo, uint8_t * pRecNo,
    uint8_t * pOffset, uint8_t * pData, uint8_t * pDataLen);

phStatus_t phalMfdfEVx_Sam_X_ClearRecordFile(void * pDataParams, uint8_t bFileNo);




/* MIFARE DESFire EVx Transaction management commands. --------------------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_CommitTransaction(void * pDataParams, uint8_t bOption, uint8_t * pTMC, uint8_t * pTMV);

phStatus_t phalMfdfEVx_Sam_X_AbortTransaction(void * pDataParams);

phStatus_t phalMfdfEVx_Sam_X_CommitReaderID(void * pDataParams, uint8_t * pTMRI, uint8_t * pEncTMRI);




/* MIFARE DESFire EVx ISO7816-4 commands. ----------------------------------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_IsoSelectFile(void * pDataParams, uint8_t bOption, uint8_t bSelector, uint8_t * pFid,
    uint8_t * pDFname, uint8_t bDFnameLen, uint8_t bExtendedLenApdu, uint8_t ** ppFCI, uint16_t * pFCILen);

phStatus_t phalMfdfEVx_Sam_X_IsoReadBinary(void * pDataParams, uint16_t wOption, uint8_t bOffset, uint8_t bSfid,
    uint32_t dwBytesToRead, uint8_t bExtendedLenApdu, uint8_t ** ppResponse, uint16_t * pBytesRead);

phStatus_t phalMfdfEVx_Sam_X_IsoUpdateBinary(void * pDataParams, uint8_t bOffset, uint8_t bSfid, uint8_t bExtendedLenApdu,
    uint8_t * pData, uint32_t dwDataLen );

phStatus_t phalMfdfEVx_Sam_X_IsoReadRecords(void * pDataParams, uint16_t wOption, uint8_t bRecNo, uint8_t bReadAllFromP1,
    uint8_t bSfid, uint32_t dwBytesToRead, uint8_t bExtendedLenApdu, uint8_t ** ppResponse, uint16_t * pBytesRead);

phStatus_t phalMfdfEVx_Sam_X_IsoAppendRecord(void * pDataParams, uint8_t bSfid, uint8_t bExtendedLenApdu, uint8_t * pData,
    uint32_t dwDataLen);

phStatus_t phalMfdfEVx_Sam_X_IsoGetChallenge(void * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint32_t dwLe,
    uint8_t * pRPICC1);

phStatus_t phalMfdfEVx_Sam_X_IsoExternalAuthenticate(void * pDataParams, uint8_t * pDataIn, uint8_t bInputLen,
    uint8_t * pDataOut, uint8_t * pOutLen);

phStatus_t phalMfdfEVx_Sam_X_IsoInternalAuthenticate(void * pDataParams, uint8_t * pDataIn, uint8_t bInputLen,
    uint8_t * pDataOut, uint8_t * pOutLen);

phStatus_t phalMfdfEVx_Sam_X_IsoAuthenticate(void * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bKeyNoCard,
    uint8_t bIsPICCkey);




/* MIFARE DESFire EVx Originality Check functions. ------------------------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_ReadSign(void * pDataParams, uint8_t bAddr, uint8_t ** pSignature);




/* MIFARE DESFire EVx MIFARE Classic functions. ---------------------------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_CreateMFCMapping(void * pDataParams, uint8_t bComOption, uint8_t bFileNo, uint8_t bFileOption,
    uint8_t * pMFCBlockList, uint8_t bMFCBlocksLen, uint8_t bRestoreSource, uint8_t * pMFCLicense, uint8_t bMFCLicenseLen,
    uint8_t * pMFCLicenseMAC);

phStatus_t phalMfdfEVx_Sam_X_RestoreTransfer(void * pDataParams, uint8_t bCommOption, uint8_t bTargetFileNo,
    uint8_t bSourceFileNo);

phStatus_t phalMfdfEVx_Sam_X_RestrictMFCUpdate(void * pDataParams, uint8_t bOption, uint8_t * pMFCConfig,
    uint8_t bMFCConfigLen, uint8_t * pMFCLicense, uint8_t bMFCLicenseLen, uint8_t * pMFCLicenseMAC);




/* MIFARE DESFire EVx POST Delivery Configuration function. ---------------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_AuthenticatePDC(void * pDataParams, uint8_t bRfu, uint8_t bKeyNoCard, uint16_t wKeyNum,
    uint16_t wKeyVer, uint8_t bUpgradeInfo);




/* MIFARE DESFire EVx Miscellaneous functions. ----------------------------------------------------------------------------------------- */
phStatus_t phalMfdfEVx_Sam_X_GetConfig(void * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalMfdfEVx_Sam_X_SetConfig(void * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phalMfdfEVx_Sam_X_ResetAuthStatus(void * pDataParams);

phStatus_t phalMfdfEVx_Sam_X_GenerateDAMEncKey(void * pDataParams, uint16_t wKeyNoDAMEnc, uint16_t wKeyVerDAMEnc,
    uint16_t wKeyNoAppDAMDefault, uint16_t wKeyVerAppDAMDefault, uint8_t bAppDAMDefaultKeyVer, uint8_t * pDAMEncKey);

phStatus_t phalMfdfEVx_Sam_X_GenerateDAMMAC(void * pDataParams, uint8_t bOption, uint16_t wKeyNoDAMMAC, uint16_t wKeyVerDAMMAC,
    uint8_t * pAid, uint8_t * pDamParams, uint8_t bKeySettings1, uint8_t bKeySettings2, uint8_t bKeySettings3,
    uint8_t * pKeySetValues, uint8_t * pISOFileId, uint8_t * pISODFName, uint8_t bISODFNameLen,
    uint8_t * pEncK, uint8_t * pDAMMAC);

phStatus_t phalMfdfEVx_Sam_X_CalculateTMV(void * pDataParams, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo,
    uint16_t wDstKeyVer, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen, uint8_t * pTMI, uint32_t dwTMILen, uint8_t * pTMV);

phStatus_t phalMfdfEVx_Sam_X_DecryptReaderID(void * pDataParams, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo,
    uint16_t wDstKeyVer, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen, uint8_t * pEncTMRI, uint8_t * pTMRIPrev);

phStatus_t phalMfdfEVx_Sam_X_ComputeMFCLicenseMAC(void * pDataParams, uint16_t wOption, uint16_t wMFCLicenseMACKeyNo,
    uint16_t wMFCLicenseMACKeyVer, uint8_t * pInput, uint16_t wInputLen, uint8_t * pDivInput, uint8_t bDivInputLen,
    uint8_t * pMFCLicenseMAC);

phStatus_t phalMfdfEVx_Sam_X_CalculateMACSDM(void * pDataParams, uint8_t bSdmOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer,
    uint16_t wDstKeyNo, uint16_t wDstKeyVer, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr, uint8_t * pInData,
    uint16_t wInDataLen, uint8_t * pMac);

phStatus_t phalMfdfEVx_Sam_X_DecryptSDMENCFileData(void * pDataParams, uint8_t bSdmOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer,
    uint16_t wDstKeyNo, uint16_t wDstKeyVer, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr, uint8_t * pEncdata,
    uint16_t wEncDataLen, uint8_t * pPlainData);

phStatus_t phalMfdfEVx_Sam_X_DecryptSDMPICCData(void * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t * pEncdata,
    uint16_t wEncDataLen, uint8_t * pPlainData);
#endif /* PHALMFDFEVX_SAM_X_H */
