/*
 * Copyright 2020, 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef PHALMFDFEVX_SAM_X_INT_H
#define PHALMFDFEVX_SAM_X_INT_H

#include <phalMfdfEVx.h>

#define PHAL_MFDFEVX_MAX_WRITE_LEN                          60U     /* The default frame size is 64 bytes. So if the Write related commands need to transmitted to the PICC via SAM,
                                                                     * the command including the data to be written and excluding PICC header comes to 60 bytes.
                                                                     */

/* Sam maximum single frame size. */
#define PHAL_MFDFEVX_SAM_DATA_FRAME_LENGTH                  224     /* Maximum data that can be exchanged in case of secure messaging computation by SAM. */

#define PHAL_MFDFEVX_SAM_X_SESSION_TMAC_ENC                 0x01    /**< Option to perform generate the TMAC session encryption keys. */
#define PHAL_MFDFEVX_SAM_X_SESSION_TMAC_MAC                 0x02    /**< Option to perform generate the TMAC session MAC keys. */
#define PHAL_MFDFEVX_SAM_X_SESSION_ENC                      0x01    /**< Option to perform generate the SDM session encryption keys. */
#define PHAL_MFDFEVX_SAM_X_SESSION_MAC                      0x02    /**< Option to perform generate the SDM session MAC keys. */

#define PHAL_MFDFEVX_SAM_X_KDF_AV1_SINGLE_ENCRYPTION        0x08U
#define PHAL_MFDFEVX_SAM_X_KDF_AV2                          0x10U
#define PHAL_MFDFEVX_SAM_X_SUPPRESS_SECURE_MESSAGING        0x20U

#define PHAL_MFDFEVX_SAM_X_CRYPTO_CONFIG_COMM_MODE_PLAIN    0x00U
#define PHAL_MFDFEVX_SAM_X_CRYPTO_CONFIG_COMM_MODE_MAC      0x10U
#define PHAL_MFDFEVX_SAM_X_CRYPTO_CONFIG_COMM_MODE_FULL     0x30U

#define PHAL_MFDFEVX_SAM_X_ISO_MODE_NATIVE                  0x00U
#define PHAL_MFDFEVX_SAM_X_ISO_MODE_ISO7816                 0x40U

#define PHAL_MFDFEVX_SAM_X_CRYPTO_CONFIG_DESFIRE_CHAINING   0x00U
#define PHAL_MFDFEVX_SAM_X_CRYPTO_CONFIG_ISO_CHAINING       0x40U
#define PHAL_MFDFEVX_SAM_X_CRYPTO_CONFIG_EXTENDED_OFFSET    0x80U

#define PHAL_MFDFEVX_SAM_X_ISO_CHAINING                     0x08U

#define PHAL_MFDFEVX_SAM_X_PDC_AUTH_DERIVE_UPGRADE_KEY      0x02U

#define PHAL_MFDFEVX_SAM_X_LRP_UPDATE_KEY_RFU               0x00U
#define PHAL_MFDFEVX_SAM_X_TRUNCATION_MODE_MFP              0x80U

#define PHAL_MFDFEVX_SAM_X_KILL_AUTHENTICATION_PARTIAL      0x01U

#define PHAL_MFDFEVX_SAM_X_CONFIG_HOSTMODE                  (PH_CONFIG_CUSTOM_BEGIN + 0)

#define PHAL_MFDFEVX_SAM_X_ERR_DESFIRE_GEN                  (PH_ERR_CUSTOM_BEGIN + 23)
#define PHAL_MFDFEVX_SAM_X_ERR_MIFARE_GEN                   (PH_ERR_CUSTOM_BEGIN + 28)

/* Resolves the component to be used. */

#ifndef NXPBUILD__PHAL_MFDFEVX_INTERNAL
#define PHAL_MFDFEVX_RESOLVE_DATAPARAMS(DataParams) ((phalMfdfEVx_SamAV3_X_DataParams_t *) DataParams)
#endif /* NXPBUILD__PHAL_MFDFEVX_INTERNAL */

/* Resolves the Hal component to be used for communicating with Sam hardware in X mode. */
#ifndef NXPBUILD__PHAL_MFDFEVX_INTERNAL
#define PHAL_MFDFEVX_RESOLVE_HAL_DATAPARAMS(DataParams)                                                                                         \
            (PH_GET_COMPID(DataParams) == PHAL_MFDFEVX_SAMAV3_X_ID) ? ((phalMfdfEVx_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams :   \
            NULL
#endif /* NXPBUILD__PHAL_MFDFEVX_INTERNAL */

/* Resolves PICC Error Code DataParams member to be used. */
#ifndef NXPBUILD__PHAL_MFDFEVX_INTERNAL
#define PHAL_MFDFEVX_RESOLVE_PICC_ERR_CODE(DataParams)                                                                                          \
            (PH_GET_COMPID(DataParams) == PHAL_MFDFEVX_SAMAV3_X_ID) ? ((phalMfdfEVx_SamAV3_X_DataParams_t *) DataParams)->aPiccRetCode :        \
            NULL
#endif /* NXPBUILD__PHAL_MFDFEVX_INTERNAL */

/* Resolve Temporary Buffer. */
#ifndef NXPBUILD__PHAL_MFDFEVX_INTERNAL
#define PHAL_MFDFEVX_RESOLVE_TEMPORARY_BUFFER(DataParams)                                                                                       \
            (PH_GET_COMPID(DataParams) == PHAL_MFDFEVX_SAMAV3_X_ID) ? ((phalMfdfEVx_SamAV3_X_DataParams_t *) DataParams)->pTmpBuffer :          \
            NULL
#endif /* NXPBUILD__PHAL_MFDFEVX_INTERNAL */

/* Resolve Temporary Buffer Size. */
#ifndef NXPBUILD__PHAL_MFDFEVX_INTERNAL
#define PHAL_MFDFEVX_RESOLVE_TEMPORARY_BUFFER_SIZE(DataParams)                                                                                  \
            (PH_GET_COMPID(DataParams) == PHAL_MFDFEVX_SAMAV3_X_ID) ? ((phalMfdfEVx_SamAV3_X_DataParams_t *) DataParams)->wTmpBufSize :         \
            NULL
#endif /* NXPBUILD__PHAL_MFDFEVX_INTERNAL */

/* Resolve TMI DataParams. */
#ifndef NXPBUILD__PHAL_MFDFEVX_INTERNAL
#define PHAL_MFDFEVX_RESOLVE_TMI_DATAPARAMS(DataParams)                                                                                         \
            (PH_GET_COMPID(DataParams) == PHAL_MFDFEVX_SAMAV3_NONX_ID) ? ((phalMfdfEVx_SamAV3_X_DataParams_t *) DataParams)->pTMIDataParams :   \
            NULL
#endif /* NXPBUILD__PHAL_MFDFEVX_INTERNAL */

void phalMfdfEVx_Sam_X_Int_SetCmdCode(void * pDataParams, uint8_t bCmdCode);

void phalMfdfEVx_Sam_X_Int_SetAuthMode(void * pDataParams, uint8_t bAuthMode);

uint8_t phalMfdfEVx_Sam_X_Int_GetAuthMode(void * pDataParams);

void phalMfdfEVx_Sam_X_Int_SetKeyNo(void * pDataParams, uint8_t bKeyNo);

uint8_t phalMfdfEVx_Sam_X_Int_GetKeyNo(void * pDataParams);

void phalMfdfEVx_Sam_X_Int_SetFabID(void * pDataParams, uint8_t bFabID);

uint8_t phalMfdfEVx_Sam_X_Int_GetFabID(void * pDataParams);

void phalMfdfEVx_Sam_X_Int_SetAdditionalInfo(void * pDataParams, uint16_t wValue);

void phalMfdfEVx_Sam_X_Int_SetUID(void * pDataParams, uint8_t *pUid, uint8_t bUidLen);

uint16_t phalMfdfEVx_Sam_X_Int_GetAdditionalInfo(void * pDataParams);

void phalMfdfEVx_Sam_X_Int_SetAID(void * pDataParams, uint8_t * pAID);

void phalMfdfEVx_Sam_X_Int_GetAID(void * pDataParams, uint8_t ** ppAID);

void phalMfdfEVx_Sam_X_Int_SetWrappedMode(void * pDataParams, uint8_t bWrappedMode);

uint8_t phalMfdfEVx_Sam_X_Int_GetWrappedMode(void * pDataParams);






phStatus_t phalMfdfEVx_Sam_X_Int_ValidateResponse(void * pDataParams, uint16_t wStatus, uint8_t * pPiccRetCode);

phStatus_t phalMfdfEVx_Sam_X_Int_Iso7816Wrap(void * pDataParams, uint8_t bFirstFrame, uint8_t bLengthPresent,
    uint8_t bLengthLen, uint8_t bLePresent, uint32_t dwTotDataLen, uint8_t * pPlainData, uint16_t * pDataLen);

phStatus_t phalMfdfEVx_Sam_X_Int_GetKeyInfo(void * pDataParams, uint8_t bKeyNo, uint16_t * pKeyType, uint16_t * pSET,
    uint16_t * pExtSET);

phStatus_t phalMfdfEVx_Sam_X_Int_ComputeTMACSessionVectors(void * pDataParams, uint8_t bOption, uint16_t wSrcKeyNo,
    uint16_t wSrcKeyVer, uint16_t wDstKeyNo, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen);

phStatus_t phalMfdfEVx_Sam_X_Int_ComputeSDMSessionVectors(void * pDataParams, uint8_t bOption, uint8_t bSdmOption,
    uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo, uint8_t * pUid, uint8_t bUidLen,
    uint8_t * pSDMReadCtr);

phStatus_t phalMfdfEVx_Sam_X_Int_LoadSDMInitVector(void * pDataParams, uint8_t * pSDMReadCtr);





void phalMfdfEVx_Sam_X_Int_GetSAMUID(void * pDataParams, uint8_t ** ppAID);

phStatus_t phalMfdfEVx_Sam_X_Int_SAM_KillAuthentication(void * pDataParams, uint8_t bOption);

phStatus_t phalMfdfEVx_Sam_X_Int_SAM_GetRandom(void * pDataParams, uint8_t bExpLen, uint8_t * pRnd);

phStatus_t phalMfdfEVx_Sam_X_Int_SAM_ActivateOfflineKey(void * pDataParams, uint8_t bOption, uint8_t bKeyNo,
    uint8_t bKeyVer, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfEVx_Sam_X_Int_SAM_LoadInitVector(void *pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalMfdfEVx_Sam_X_Int_SAM_DumpSecretKey(void * pDataParams, uint8_t bDumpMode, uint8_t bKeyNo, uint8_t bKeyVer, uint8_t * pDivInput,
    uint8_t bDivInputLen, uint8_t * pSecretKey, uint16_t * pSecretKeyLen);

phStatus_t phalMfdfEVx_Sam_X_Int_SAM_GetKeyEntry(void * pDataParams, uint8_t bKeyNo, uint8_t bMode, uint8_t * pKeyEntry, uint8_t * pKeyEntryLen);

phStatus_t phalMfdfEVx_Sam_X_Int_SAM_DeriveKey(void * pDataParams, uint8_t bSrcKeyNo, uint8_t bSrcKeyVer,
    uint8_t bDstKeyNo, uint8_t * pDeriveIn, uint8_t bDeriveInLen);

phStatus_t phalMfdfEVx_Sam_X_Int_SAM_EncipherOfflineData(void * pDataParams, uint16_t wOption, uint8_t * pPlainData,
    uint8_t bPlainDataLen, uint8_t ** ppEncData, uint16_t * pEncDataLen);

phStatus_t phalMfdfEVx_Sam_X_Int_SAM_GenerateMAC(void * pDataParams, uint16_t wOption, uint8_t bNum,
    uint8_t * pData, uint8_t bDataLen, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalMfdfEVx_Sam_X_Int_SAM_DecipherOfflineData(void *  pDataParams, uint16_t wOption, uint8_t * pEncData,
    uint8_t bEncDataLen, uint8_t ** ppPlainData, uint16_t * pPlainDataLen);

phStatus_t phalMfdfEVx_Sam_X_Int_DESFire_AuthenticatePICC(void * pDataParams, uint8_t bOption, uint8_t bISOMode, uint8_t bDFKeyNo,
    uint8_t bKeyNo, uint8_t bKeyVer, uint8_t bPCDcap2InLen, uint8_t * pPCDcap2In, uint8_t * pDivInput, uint8_t  bDivInputLen,
    uint8_t * pPDcap2, uint8_t * pPCDcap2, uint8_t * pPiccReturnCode);

phStatus_t phalMfdfEVx_Sam_X_Int_DESFire_ChangeKeyPICC(void * pDataParams, uint8_t bKeyCompMeth, uint8_t bConfig,
    uint8_t bKeySetNo, uint8_t bDFKeyNo, uint8_t bCurrKeyNo, uint8_t bCurrKeyVer, uint8_t bNewKeyNo, uint8_t bNewKeyVer,
    uint8_t * pDivInput, uint8_t  bDivInputLen);

phStatus_t phalMfdfEVx_Sam_X_Int_DESFire_WriteX(void * pDataParams, uint16_t wOption, uint8_t bCrypto, uint8_t * pData,
    uint8_t bDataLen);

phStatus_t phalMfdfEVx_Sam_X_Int_DESFire_ReadX(void * pDataParams, uint16_t wOption, uint8_t bCrypto, uint8_t * pAppData,
    uint8_t bAppDataLen, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalMfdfEVx_Sam_X_Int_DESFire_CreateTMFilePICC(void * pDataParams, uint8_t bOption, uint8_t bISOMode,
    uint8_t bKeyNo, uint8_t bKeyVer, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights,
    uint8_t bTMKeyOptions, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfEVx_Sam_X_Int_TMRI_CommitReaderID(void * pDataParams, uint8_t bISOMode, uint8_t bState,
    uint16_t wBlockNr, uint8_t ** ppEncTMRI, uint16_t * pEncTMRILen, uint8_t * pStatusCode);

phStatus_t phalMfdfEVx_Sam_X_Int_ISO14443_4_Exchange(void * pDataParams, uint16_t wOption, uint8_t * pAppDataIn,
    uint8_t bLenAppData, uint8_t ** ppAppDataOut, uint16_t * pAppDataOutLen);

#endif /* PHALMFDFEVX_SAM_X_INT_H */
