/*
 * Copyright 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef PHALMFDFLIGHT_SAM_X_INT_H
#define PHALMFDFLIGHT_SAM_X_INT_H

#include <phalMfdfLight.h>

#define PHAL_MFDFLIGHT_SAM_DATA_FRAME_LENGTH						224		/* Maximum data that can be exchanged in case of secure messaging computation by SAM. */
#define PHAL_MFDFLIGHT_RESET_AUTH_OFF		0x00	/* Do not reset the internal parameters and Kill the PICC authentication */
#define PHAL_MFDFLIGHT_RESET_AUTH_ON		0x01	/* Reset the internal parameters and Kill the PICC authentication */
#define PHAL_MFDFLIGHT_MAX_WRITE_LEN		124	/* The default frame size is 64 bytes. So if the Write related commands need to transmitted to the PICC via SAM,
												 * the command including the data to be written and excluding PICC header comes to 124 bytes.
												 */


#define PHAL_MFDFLIGHT_SAM_NONX_SESSION_TMAC_ENC					0x01	/**< Optionto perform generate the TMAC session encryption keys. */
#define PHAL_MFDFLIGHT_SAM_NONX_SESSION_TMAC_MAC					0x02	/**< Optionto perform generate the TMAC session MAC keys. */

/* Resolves the component to be used. */
#define PHAL_MFDFLIGHT_RESOLVE_DATAPARAMS(DataParams)	((phalMfdfLight_SamAV3_X_DataParams_t *) DataParams)

/* Resolves the Hal component to be used for communicating with Sam hardware in X mode. */
#define PHAL_MFDFLIGHT_RESOLVE_HAL_DATAPARAMS(DataParams)																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFDFLIGHT_SAMAV3_X_ID) ? ((phalMfdfLight_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams :	\
			NULL

phStatus_t phalMfdfLight_Sam_X_Int_ValidateResponse(void * pDataParams, uint8_t bResetAuth, uint16_t wStatus, uint8_t * pPiccRetCode);

phStatus_t phalMfdfLight_Sam_X_Int_Iso7816Wrap(uint8_t bFirstFrame, uint8_t bLengthPresent, uint8_t bLengthLen, uint8_t bLePresent, uint32_t dwTotDataLen,
	uint8_t * pPlainData, uint16_t * pDataLen);

phStatus_t phalMfdfLight_Sam_X_Int_ResetAuthentication(void * pDataParams);

phStatus_t phalMfdfLight_Sam_X_Int_ComputeTMACSessionVectors(void * pDataParams, uint8_t bOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo,
	uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen);

#endif /* PHALMFDFLIGHT_SAM_X_INT_H */
