/*
 * Copyright 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software implementation of NTAG X DNA application layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7462 $
 * $Date: 2025-08-29 14:09:06 +0530 (Fri, 29 Aug 2025) $
 *
 * History:
 *  Rajendran Kumar: Generated 22 Aug 2024
 *
 */

#ifndef PHALNTAGXDNA_SW_H
#define PHALNTAGXDNA_SW_H

#include <ph_Status.h>

#ifdef NXPBUILD__PHAL_NTAGXDNA_SW

/* NTAG X DNA Authentication commands -------------------------------------------------------------------------------------------------- */
#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalNtagXDna_Sw_ISOGeneralAuthenticate(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bDeviceCert_Cached, uint8_t bIsHostResponder,
    uint8_t bCertRepoID, uint8_t bCert_Depth, uint8_t bKeySize, uint16_t wPriv_KeyNo, uint16_t wPriv_KeyPos, uint16_t wPub_KeyNo, uint16_t wPub_KeyPos,
    uint8_t * pExpRspLen, uint8_t bExpRspLen, phalNtagXDna_Cert stHostCert, phalNtagXDna_Cert * pDeviceCert);
#endif /* NXPBUILD__PH_CRYPTOSYM */

phStatus_t phalNtagXDna_Sw_ISOInternalAuthenticate(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bPrivKeyNo, uint8_t bCurveID,
    uint8_t * pPubBKey, uint16_t wPubBKeyLen, uint8_t * pOptsA, uint8_t bOptsALen, uint8_t * pExpRspLen, uint8_t bExpRspLen);

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalNtagXDna_Sw_AuthenticateEv2(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bFirstAuth, uint16_t wOption, uint16_t wKeyNo,
    uint16_t wKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivLen, uint8_t * pPcdCapsIn, uint8_t bLenPcdCapsIn,
    uint8_t * pPcdCapsOut, uint8_t * pPdCapsOut);
#endif /* NXPBUILD__PH_CRYPTOSYM */

phStatus_t phalNtagXDna_Sw_ProcessSMApply(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bCommMode, uint8_t bOffset, uint8_t bCmdCtrIncr,
    uint8_t * pData, uint8_t bDataLen, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_ProcessSMRemove(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bCommMode, uint8_t * pData, uint8_t bDataLen,
    uint8_t ** ppResponse, uint16_t * pRspLen);





/* NTAG X DNA Memory and Configuration management commands ----------------------------------------------------------------------------- */
phStatus_t phalNtagXDna_Sw_FreeMem(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t ** ppMemInfo, uint16_t * pMemInfoLen);

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalNtagXDna_Sw_SetConfiguration(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pData,
    uint8_t bDataLen);

phStatus_t phalNtagXDna_Sw_GetConfiguration(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bExchangeOption,
    uint8_t ** ppData, uint16_t * pDataLen);
#endif /* NXPBUILD__PH_CRYPTOSYM */

phStatus_t phalNtagXDna_Sw_ActivateConfiguration(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bConfCount, uint8_t * pConfigList,
    uint8_t bConfigList_Len);

phStatus_t phalNtagXDna_Sw_GetVersion(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t ** ppVerInfo,
    uint16_t * pVerInfoLen);

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalNtagXDna_Sw_GetCardUID(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t ** ppUid, uint16_t * pUidLen);
#endif /* NXPBUILD__PH_CRYPTOSYM */





/* NTAG X DNA Symmetric Key management commands ---------------------------------------------------------------------------------------- */
#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalNtagXDna_Sw_ChangeKey(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wOption, uint16_t wCurrKeyNo,
    uint16_t wCurrKeyVer, uint16_t wNewKeyNo, uint16_t wNewKeyVer, uint8_t bKeyNoCard, uint8_t * pKeyPolicy,
    uint8_t * pDivInput, uint8_t bDivLen);
#endif /* NXPBUILD__PH_CRYPTOSYM */

phStatus_t phalNtagXDna_Sw_GetKeySettings(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t ** ppResponse,
    uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_GetKeyVersion(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bKeyNo, uint8_t ** ppResponse,
    uint16_t * pRspLen);





/* NTAG X DNA ASymmetric Key management commands --------------------------------------------------------------------------------------- */
phStatus_t phalNtagXDna_Sw_ManageKeyPair(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bComOption, uint8_t bKeyNo,
    uint8_t bOption, uint8_t bCurveID, uint8_t * pKeyPolicy, uint8_t bWriteAccess, uint32_t dwKUCLimit,
    uint16_t wPrivKey_No, uint16_t wPrivKey_Pos, uint8_t ** ppResponse, uint16_t *pRspLen);

phStatus_t phalNtagXDna_Sw_ManageCARootKey(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bComOption, uint8_t bKeyNo,
    uint8_t bCurveID, uint8_t * pAccessRights, uint8_t bWriteAccess, uint16_t wPubKey_No, uint16_t wPubKey_Pos,
    uint8_t * pIssuer, uint8_t bIssuerLen);





/* NTAG X DNA ASymmetric Key management commands --------------------------------------------------------------------------------------- */
phStatus_t phalNtagXDna_Sw_ManageKeyPair(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bComOption, uint8_t bKeyNo,
    uint8_t bOption, uint8_t bCurveID, uint8_t * pKeyPolicy, uint8_t bWriteAccess, uint32_t dwKUCLimit,
    uint16_t wPrivKey_No, uint16_t wPrivKey_Pos, uint8_t ** ppResponse, uint16_t *pRspLen);

phStatus_t phalNtagXDna_Sw_ManageCARootKey(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bComOption, uint8_t bKeyNo,
    uint8_t bCurveID, uint8_t * pAccessRights, uint8_t bWriteAccess, uint16_t wPubKey_No, uint16_t wPubKey_Pos,
    uint8_t * pIssuer, uint8_t bIssuerLen);





/* NTAG X DNA Certificate management commands ------------------------------------------------------------------------------------------ */
phStatus_t phalNtagXDna_Sw_ManageCertRepo(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bComOption, uint8_t bAction, uint8_t bRepoID,
    uint8_t * pData, uint16_t wDataLen);

phStatus_t phalNtagXDna_Sw_ReadCertRepo(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bRepoID, uint8_t bDataItem,
    uint8_t ** ppResponse, uint16_t * pRspLen);




/* NTAG X DNA File management commands ------------------------------------------------------------------------------------------------- */
phStatus_t phalNtagXDna_Sw_CreateStdDataFile(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo,
    uint8_t * pISOFileId, uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pFileSize);

phStatus_t phalNtagXDna_Sw_CreateCounterFile(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bFileNo, uint8_t bFileOption,
    uint8_t * pAccessRights, uint32_t dwValue);

phStatus_t phalNtagXDna_Sw_GetFileIDs(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t ** ppFileId, uint16_t * pFileIdLen);

phStatus_t phalNtagXDna_Sw_GetISOFileIDs(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t ** ppISOFileId, uint16_t * pISOFileIdLen);

phStatus_t phalNtagXDna_Sw_GetFileSettings(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bFileNo, uint8_t ** ppFSBuffer,
    uint16_t * pFSBufLen);

phStatus_t phalNtagXDna_Sw_GetFileCounters(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo,
    uint8_t ** ppFileCounters, uint16_t * pFileCounterLen);

phStatus_t phalNtagXDna_Sw_ChangeFileSettings(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo,
    uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pAddInfo, uint8_t bAddInfoLen);





/* NTAG X DNA Data management commands ------------------------------------------------------------------------------------------------- */
phStatus_t phalNtagXDna_Sw_ReadData(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset,
    uint8_t * pLength, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_WriteData(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset,
    uint8_t * pData, uint8_t * pLength);

phStatus_t phalNtagXDna_Sw_IncrementCounterFile(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo,
    uint32_t dwIncrValue);





/* NTAG X DNA CryptoAPI commands ------------------------------------------------------------------------------------------------------- */
phStatus_t phalNtagXDna_Sw_CryptoRequestSHA(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bOperation,
    uint8_t bAlgorithm, uint8_t bInputDataSource, uint8_t bResultDst, uint8_t * pData, uint8_t bDataLen, uint8_t ** ppResponse,
    uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_CryptoRequestRNG(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bNumBytes,
    uint8_t bResultDst, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_CryptoRequestECCSign(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bOperation,
    uint8_t bPrivateKeyID, uint8_t bInputDataSource, uint8_t * pData, uint8_t bDataLen, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_CryptoRequestECCVerify(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bOperation,
    uint8_t bCurveID, uint8_t * pHostPubKey, uint8_t bHostPubKeyLen, uint8_t * pSignature, uint8_t bSigLen, uint8_t bInputDataSource,
    uint8_t * pData, uint8_t bDataLen);

phStatus_t phalNtagXDna_Sw_CryptoRequestECCDH(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bOperation,
    uint8_t bKeyPairID, uint8_t bSSDestination, uint8_t * pHostPubKey, uint8_t bHostPubKeyLen, uint8_t ** ppResponse,
    uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_CryptoRequestAES(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bOperation,
    uint8_t bPrimitive, uint8_t bKeyID, uint8_t bKeyLen, uint8_t bICVSource, uint8_t * pICV, uint8_t bICVLen,
    uint8_t bInputDataSource, uint8_t bResultDst, uint8_t * pInputData, uint8_t bInputDataLen,
    uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_CryptoRequestAESCMAC(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bOperation,
    uint8_t bPrimitive, uint8_t bKeyID, uint8_t bKeyLen, uint8_t * pCMACSignature, uint8_t bCMACSignLen, uint8_t bInputDataSource,
    uint8_t * pInputData, uint8_t bInputDataLen, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_CryptoRequestAESAEAD(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bOperation,
    uint8_t bPrimitive, uint8_t bKeyID, uint8_t bKeyLen, uint8_t bNonceSource, uint8_t * pNonce, uint8_t bNonceLen, uint16_t wTotal_AAdLen,
    uint16_t wTotal_InputDataLen, uint8_t bAADSource, uint8_t * pAAD, uint8_t bAADLen, uint8_t bInputDataSource, uint8_t * pInputData,
    uint8_t bInputDataLen, uint8_t * pTagData, uint8_t bTagDataLen, uint8_t bResultDst, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_CryptoRequestWriteInternalBuffer(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bDestination,
    uint8_t * pData, uint8_t bDataLen);

phStatus_t phalNtagXDna_Sw_CryptoRequestHMAC(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bOperation, uint8_t bPrimitive,
    uint8_t bDigestAlgo, uint8_t bKeyID, uint8_t bKeyLen, uint8_t * pHMac, uint8_t bHMacLen, uint8_t bInputDataSource, uint8_t * pInputData,
    uint8_t bInputDataLen, uint8_t bResultDst, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_CryptoRequestHKDF(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bOperation, uint8_t bDigestAlgo,
    uint8_t bKeyID, uint8_t bKeyLen, uint8_t bSaltSource, uint8_t * pSaltData, uint8_t bSaltDataLen, uint8_t bInfoSource, uint8_t * pInfoData,
    uint8_t bInfoDataLen, uint8_t bResultDst, uint8_t bResultLen, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_CryptoRequestECHO(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pData,
    uint8_t bDataLen, uint8_t ** ppResponse, uint16_t * pRspLen);





/* NTAG X DNA GPIO Management commands ------------------------------------------------------------------------------------------------- */
phStatus_t phalNtagXDna_Sw_ManageGPIO(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bGPIONo, uint8_t bOperation,
    uint8_t * pNFCPauseRspData, uint16_t wNFCPauseRspDataLen, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_ReadGPIO(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t ** ppResponse,
    uint16_t * pRspLen);





/* NTAG X DNA ISO7816-4 commands ------------------------------------------------------------------------------------------------------- */
phStatus_t phalNtagXDna_Sw_IsoSelectFile(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bSelector, uint8_t * pFid,
    uint8_t * pDFname, uint8_t bDFnameLen, uint8_t bExtendedLenApdu, uint8_t ** ppFCI, uint16_t * pFCILen);

phStatus_t phalNtagXDna_Sw_IsoReadBinary(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bOffset, uint8_t bSfid,
    uint32_t dwBytesToRead, uint8_t bExtendedLenApdu, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_IsoUpdateBinary(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOffset, uint8_t bSfid, uint8_t bExtendedLenApdu,
    uint8_t * pData, uint16_t wDataLen);





/* NTAG X DNA Utility functions -------------------------------------------------------------------------------------------------------- */
phStatus_t phalNtagXDna_Sw_GetConfig(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalNtagXDna_Sw_SetConfig(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phalNtagXDna_Sw_ResetAuthentication(phalNtagXDna_Sw_DataParams_t * pDataParams);

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalNtagXDna_Sw_CalculateMACSDM(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bSdmOption, uint16_t wKeyNo_SDMMac,
    uint16_t wKeyVer_SDMMac, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr, uint8_t * pInData, uint16_t wInDataLen,
    uint8_t ** ppSDMMAC, uint16_t * pSDMMACLen);

phStatus_t phalNtagXDna_Sw_VerifySDMSignature(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wPubKeyNo_SDMSig,
    uint16_t wPubKeyPos_SDMSig, uint8_t * pInData, uint16_t wInDataLen, uint8_t * pSignature, uint16_t wSigLen);

phStatus_t phalNtagXDna_Sw_DecryptSDMENCFileData(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bSdmOption,
    uint16_t wKeyNo_SDMEnc, uint16_t wKeyVer_SDMEnc, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr,
    uint8_t * pEncData, uint16_t wEncDataLen, uint8_t ** ppPlainData, uint16_t * pPlainDataLen);

phStatus_t phalNtagXDna_Sw_DecryptSDMPICCData(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t * pEncData, uint16_t wEncDataLen, uint8_t ** ppPlainData, uint16_t * pPlainDataLen);
#endif /* NXPBUILD__PH_CRYPTOSYM */

#endif /* NXPBUILD__PHAL_NTAGXDNA_SW */

#endif /* PHALNTAGXDNA_SW_H */
