/*
 * Copyright 2016 - 2018, 2020, 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Sam X Virtual Card Architecture(R) Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALVCA_SAMAV2_X_H
#define PHALVCA_SAMAV2_X_H

#include <ph_Status.h>
#include <phalVca.h>


#ifndef NXPBUILD__PHAL_VCA_INTERNAL
#define PHAL_VCA_RESOLVE_HAL_DATAPARAMS_X(DataParams)                                                                                   \
            (PH_GET_COMPID(DataParams) == PHAL_VCA_SAMAV3_NONX_ID) ? ((phalVca_SamAV3_X_DataParams_t *) DataParams)->pSamHal :          \
            NULL
#endif /* NXPBUILD__PHAL_VCA_INTERNAL */





phStatus_t phalVca_Sam_X_StartCardSelection(phalVca_SamAV2_X_DataParams_t * pDataParams);

phStatus_t phalVca_Sam_X_FinalizeCardSelection(phalVca_SamAV2_X_DataParams_t * pDataParams, uint16_t* pNumValidIids);

phStatus_t phalVca_Sam_X_SelectVc(phalVca_SamAV2_X_DataParams_t * pDataParams, uint16_t wValidIidIndex, uint16_t wKeyNo,
    uint16_t wKeyVer);

phStatus_t phalVca_Sam_X_DeselectVc(phalVca_SamAV2_X_DataParams_t * pDataParams);

phStatus_t phalVca_Sam_X_VcSupport(phalVca_SamAV2_X_DataParams_t * pDataParams, uint8_t * pIid, uint16_t wKeyEncNumber,
    uint16_t wKeyEncVersion, uint16_t wKeyMacNumber, uint16_t wKeyMacVersion);

phStatus_t phalVca_Sam_X_VcSupportLast(phalVca_SamAV2_X_DataParams_t * pDataParams, uint8_t * pIid, uint8_t bLenCap,
    uint8_t* pPcdCapabilities, uint16_t wKeyEncNumber, uint16_t wKeyEncVersion, uint16_t wKeyMacNumber,
    uint16_t wKeyMacVersion);

phStatus_t phalVca_Sam_X_GetIidInfo(phalVca_SamAV2_X_DataParams_t * pDataParams, uint16_t wValidIidIndex, uint16_t * pIidIndex,
    uint8_t * pVcUidSize, uint8_t * pVcUid, uint8_t * pInfo, uint8_t * pPdCapabilities);

#ifdef NXPBUILD__PHAL_VCA_SAMAV3_X
phStatus_t phalVca_Sam_X_IsoSelect(void * pDataParams, uint8_t bOption, uint8_t bDFnameLen,
    uint8_t * pDFname, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t bEncKeyNo, uint8_t bEncKeyVer,
    uint8_t bMacKeyNo, uint8_t bMacKeyVer, uint8_t * pResponse, uint16_t * pRespLen);
#endif /* NXPBUILD__PHAL_VCA_SAMAV3_X */




phStatus_t phalVca_Sam_X_ProximityCheck(phalVca_SamAV2_X_DataParams_t * pDataParams, uint8_t bGenerateRndC, uint8_t * pRndC,
    uint8_t bPps1, uint8_t bNumSteps, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t * pUsedRndC);

#ifdef NXPBUILD__PHAL_VCA_SAMAV3_X
phStatus_t phalVca_Sam_X_ProximityCheckNew(void *pDataParams, uint8_t bOption, uint16_t wKeyNo,
    uint16_t wKeyVer, uint8_t bNumOfRand, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pOption,
    uint8_t * pPubRespTime, uint8_t * pResponse, uint16_t * pRespLen);

phStatus_t phalVca_Sam_X_SetConfig(void * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phalVca_Sam_X_GetConfig(phalVca_SamAV3_X_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalVca_Sam_X_ResolveValidIndex(phalVca_SamAV2_X_DataParams_t * pDataParams, uint16_t wIidIndex, uint16_t * pValidIndex);

phStatus_t phalVca_Sam_X_VCA_Select(void* pDataParams, uint8_t bOption, uint8_t bEncKeyNo, uint8_t bEncKeyVer, uint8_t bMacKeyNo,
    uint8_t bMacKeyVer, uint8_t* pIID, uint8_t bIIDLen, uint8_t* pDivInput, uint8_t bDivInputLen, uint8_t** ppResponse, uint16_t* pRespLen, uint16_t* pPiccRetCode);

phStatus_t phalVca_Sam_X_VCA_ProximityCheck(void* pDataParams, uint8_t bOption, uint8_t bKeyNo,
    uint8_t bKeyVer, uint8_t bNumOfRand, uint8_t* pDivInput, uint8_t bDivInputLen, uint8_t** ppResponse, uint16_t* pRespLen);

#endif /* NXPBUILD__PHAL_VCA_SAMAV3_X */

void phalVca_Sam_X_SetAdditionalInfo(void* pDataParams, uint16_t wValue);

uint16_t phalVca_Sam_X_GetAdditionalInfo(void* pDataParams);

void phalVca_Sam_X_SetWrappedMode(void* pDataParams, uint16_t wValue);

uint8_t phalVca_Sam_X_GetWrappedMode(void* pDataParams);

#endif /* PHALVCA_SAMAV2_X_H */
