/*
 * Copyright 2013 - 2014, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PipeLinux specific BAL-Component of Reader Library Framework.
 * $RCSfile $
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHBAL_REG_PIPELIN

#include "phbalReg_PipeLin_Int.h"

void phbalReg_PipeLin_Removechar(
                                 uint8_t * pString,
                                 uint8_t Ch
                                 )
{
    uint16_t PH_MEMLOC_REM wIndex;

    for ( wIndex = 0 ; wIndex < (uint16_t)strlen((char*)pString) ; wIndex++ )
    {
        if ( pString[wIndex] == Ch )
        {
            pString[wIndex] = ' ';
        }
    }
}

phStatus_t phbalReg_PipeLin_HexToString(
                                        uint8_t * pHex,
                                        uint16_t wHexLength,
                                        uint16_t wStringSize,
                                        uint8_t * pString
                                        )
{
    uint16_t    PH_MEMLOC_REM wIndex;
    uint16_t    PH_MEMLOC_REM wStrLen = 0;

    /* Do for every byte */
    for (wIndex = 0; wIndex < wHexLength; ++wIndex)
    {
        /* Check for buffer overflow */
        if ((wStrLen + 4) > wStringSize)
        {
            return PH_ADD_COMPCODE(PH_ERR_BUFFER_OVERFLOW, PH_COMP_BAL);
        }

        /* Convert byte to string */
        sprintf((char*)&pString[wStrLen], "%02X", pHex[wIndex]);  /* PRQA S 3200 */

        /* Increment string length */
        wStrLen = wStrLen + 2;
    }

    /* Terminate string */
    pString[wStrLen++] = '\n';

    /* Terminate string */
    pString[wStrLen++] = '\0';

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phbalReg_PipeLin_StringToHex(
                                        uint8_t * pString,
                                        uint16_t * pNewLength
                                        )
{
    uint16_t    PH_MEMLOC_REM wStrLen;
    uint32_t    PH_MEMLOC_REM dValue;
    uint8_t     PH_MEMLOC_REM bTempChars[3];
    uint16_t    PH_MEMLOC_REM wIndex = 0;

    /* Terminate Temporary string */
    bTempChars[2] = '\0';

    /* Retrieve string length */
    wStrLen = (uint16_t)strlen((char*)pString);

    /* Reset output length */
    *pNewLength = 0;

    /* Do for every hex-pair */
    while (wIndex < wStrLen-1)
    {
        memcpy(bTempChars, &pString[wIndex++], 2);   /* PRQA S 3200 */
        sscanf((char*)bTempChars, "%02X", &dValue);  /* PRQA S 3200 */ /* PRQA S 0206 */
        pString[(*pNewLength)++] = (uint8_t)dValue;

        /* Skip spaces */
        while ((++wIndex < wStrLen) && (pString[wIndex] == ' '));
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

#endif /* NXPBUILD__PHBAL_REG_PIPELIN */
