/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/*
 * Licensee wrapper specific HAL-Component of Reader Library Framework.
 * $RCSfile $
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_LICENSEEWRAPPER_H
#define PHHALHW_LICENSEEWRAPPER_H

#include <ph_Status.h>
#include <phhalHw.h>

phStatus_t phhalHw_LicenseeWrapper_SetConfig(
	phhalHw_LicenseeWrapper_DataParams_t * pDataParams, /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wConfig,									/**< [In] Configuration Identifier. */
    uint16_t wValue										/**< [In] Configuration Value. */
    );

phStatus_t phhalHw_LicenseeWrapper_GetConfig(
	phhalHw_LicenseeWrapper_DataParams_t * pDataParams, /**< [In] Pointer to this layer's parameter structure. */
    uint16_t   wConfig,									/**< [In] Configuration Identifier. */
    uint16_t * pValue									/**< [Out] Configuration Value. */
    );

phStatus_t phhalHw_LicenseeWrapper_FieldReset(
	phhalHw_LicenseeWrapper_DataParams_t * pDataParams  /**< [In] Pointer to this layer's parameter structure. */
    );

phStatus_t phhalHw_LicenseeWrapper_Wait(
	phhalHw_LicenseeWrapper_DataParams_t * pDataParams, /**< [In] Pointer to this layer's parameter structure. */
    uint8_t   bUnit,									/**< [In] Unit of given timeout value (either #PHHAL_HW_TIME_MICROSECONDS or #PHHAL_HW_TIME_MILLISECONDS). */
    uint16_t  wTimeout									/**< [In] Timeout value. */
    );

phStatus_t phhalHw_LicenseeWrapper_Exchange(
	phhalHw_LicenseeWrapper_DataParams_t * pDataParams, /**< [In] Pointer to this layer's parameter structure. */
    uint16_t    wOption,								/**< [In] Option parameter. */
    uint8_t   * pTxBuffer,								/**< [In] Data to transmit. */
    uint16_t    wTxLength,								/**< [In] Length of data to transmit. */
    uint8_t  ** ppRxBuffer,								/**< [Out] Pointer to received data. */
    uint16_t  * pRxLength								/**< [Out] number of received data bytes. */
	);

phStatus_t phhalHw_LicenseeWrapper_ApplyProtocolSettings(
	phhalHw_LicenseeWrapper_DataParams_t * pDataParams, /**< [In] Pointer to this layer's parameter structure. */
    uint8_t bCardType									/**< [In] Type of card for which the hal should be configured for. */
	);

#endif /* PHHALHW_LICENSEEWRAPPER_H */

