/*
 * Copyright 2013, 2015, 2017, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for Rc663 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_RC663_CONFIG_H
#define PHHALHW_RC663_CONFIG_H

#include <ph_Status.h>
#include <phhalHw.h>

/** \defgroup phhalHw_Rc663_Config Configuration
* \brief Custom Configuration of hardware related settings.
* @{
*/

/** \name Memory related constants
*/
/** @{ */
#define PHHAL_HW_RC663_PRECACHED_BYTES  0xFFU   /**< Maximum number of bytes to precache into FIFO before triggering a command. */
/** @} */

/** \name Modulation indices
*/
/** @{ */
#define PHHAL_HW_RC663_MODINDEX_I14443B     0xCCU   /**< Default modulation index for ISO14443B. */
#define PHHAL_HW_RC663_MODINDEX_FELICA      0x17U   /**< Default modulation index for Felica. */
#define PHHAL_HW_RC663_MODINDEX_I15693      0x10U   /**< Default modulation index for ISO15693.  */
#define PHHAL_HW_RC663_MODINDEX_EPCUID      0x10U   /**< Default modulation index for EPC/UID. */
#define PHHAL_HW_RC663_MODINDEX_I18000P3M3  0x10U   /**< Default modulation index for ISO18000-3 Mode3. */
/** @} */

/** \name RxThreshold values
*/
/** @{ */
#define PHHAL_HW_RC663_RXTHRESHOLD_I14443A_106          0x3FU   /**< RxThreshold for ISO14443A @ 106kbit/s. */
#define PHHAL_HW_RC663_RXTHRESHOLD_I14443A_212          0x3FU   /**< RxThreshold for ISO14443A @ 212kbit/s. */
#define PHHAL_HW_RC663_RXTHRESHOLD_I14443A_424          0x3FU   /**< RxThreshold for ISO14443A @ 424kbit/s. */
#define PHHAL_HW_RC663_RXTHRESHOLD_I14443A_848          0x3FU   /**< RxThreshold for ISO14443A @ 848kbit/s. */
#define PHHAL_HW_RC663_RXTHRESHOLD_I14443B_106          0x3FU   /**< RxThreshold for ISO14443B @ 106kbit/s. */
#define PHHAL_HW_RC663_RXTHRESHOLD_I14443B_212          0x3FU   /**< RxThreshold for ISO14443B @ 212kbit/s. */
#define PHHAL_HW_RC663_RXTHRESHOLD_I14443B_424          0x3FU   /**< RxThreshold for ISO14443B @ 424kbit/s. */
#define PHHAL_HW_RC663_RXTHRESHOLD_I14443B_848          0x3FU   /**< RxThreshold for ISO14443B @ 848kbit/s. */
#define PHHAL_HW_RC663_RXTHRESHOLD_FELICA_212           0x3FU   /**< RxThreshold for Felica @ 212kbit/s. */
#define PHHAL_HW_RC663_RXTHRESHOLD_FELICA_424           0x3FU   /**< RxThreshold for Felica @ 424kbit/s. */
#define PHHAL_HW_RC663_RXTHRESHOLD_I15693_FAST          0x44U   /**< RxThreshold for ISO15693 @ High. */
#define PHHAL_HW_RC663_RXTHRESHOLD_I15693_FAST_HIGH     0x44U   /**< RxThreshold for ISO15693 @ Fast_High. */
#define PHHAL_HW_RC663_RXTHRESHOLD_EPCUID               0x4EU   /**< RxThreshold for EPC/UID. */
#define PHHAL_HW_RC663_RXTHRESHOLD_I18000P3M3           0x36U   /**< RxThreshold for ISO18000-3 Mode3. */
/** @} */

/** \name LPCD min. timer reload values
*/
/** @{ */
#define PHHAL_HW_RC663_LPCD_T3_RELOAD_MIN   0x0010U /**< Default minimum for T3 reload value (used only for #PHHAL_HW_RC663_CMD_LPCD_MODE_DEFAULT mode). */
#define PHHAL_HW_RC663_LPCD_T4_RELOAD_MIN   0x0005U /**< Default minimum for T4 reload value (used only for #PHHAL_HW_RC663_CMD_LPCD_MODE_DEFAULT mode). */
/** @} */

/** \name Feature selection
*/
/** @{ */
#define PHHAL_HW_RC663_FEATURE_FIFO_UNDERFLOW_CHECK /**< Checks for FIFO underflow during data transmission if defined. */
/** @} */

/**
* end of phhalHw_Rc663_Config group
* @}
*/

#endif /* PHHALHW_RC663_CONFIG_H */
