/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * FPGA-Box Reader specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_RDFPGAV6_H
#define PHHALHW_RDFPGAV6_H

#include <ph_Status.h>
#include <phhalHw.h>

phStatus_t phhalHw_RdFpgaV6_Exchange(
                                     phhalHw_RdFpgaV6_DataParams_t * pDataParams,
                                     uint16_t wOption,
                                     uint8_t * pTxBuffer,
                                     uint16_t wTxLength,
                                     uint8_t ** ppRxBuffer,
                                     uint16_t * pRxLength
                                     );

phStatus_t phhalHw_RdFpgaV6_WriteRegister(
    phhalHw_RdFpgaV6_DataParams_t * pDataParams,
    uint8_t bAddress,
    uint8_t bValue
    );

phStatus_t phhalHw_RdFpgaV6_ReadRegister(
    phhalHw_RdFpgaV6_DataParams_t * pDataParams,
    uint8_t bAddress,
    uint8_t * pValue
    );


phStatus_t phhalHw_RdFpgaV6_ApplyProtocolSettings(
    phhalHw_RdFpgaV6_DataParams_t * pDataParams,
    uint8_t bCardType
    );

phStatus_t phhalHw_RdFpgaV6_MfcAuthenticateKeyNo(
    phhalHw_RdFpgaV6_DataParams_t * pDataParams,
    uint8_t bBlockNo,
    uint8_t bKeyType,
    uint16_t wKeyNo,
    uint16_t wKeyVersion,
    uint8_t * pUid
    );

phStatus_t phhalHw_RdFpgaV6_MfcAuthenticate(
    phhalHw_RdFpgaV6_DataParams_t * pDataParams,
    uint8_t bBlockNo,
    uint8_t bKeyType,
    uint8_t * pKey,
    uint8_t * pUid
    );

phStatus_t phhalHw_RdFpgaV6_SetConfig(
                                      phhalHw_RdFpgaV6_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint16_t wValue
                                      );

phStatus_t phhalHw_RdFpgaV6_GetConfig(
                                      phhalHw_RdFpgaV6_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint16_t * pValue
                                      );

phStatus_t phhalHw_RdFpgaV6_FieldOn(
                                    phhalHw_RdFpgaV6_DataParams_t * pDataParams
                                    );

phStatus_t phhalHw_RdFpgaV6_FieldOff(
                                     phhalHw_RdFpgaV6_DataParams_t * pDataParams
                                     );

phStatus_t phhalHw_RdFpgaV6_FieldReset(
                                       phhalHw_RdFpgaV6_DataParams_t * pDataParams
                                       );

phStatus_t phhalHw_RdFpgaV6_Wait(
                                 phhalHw_RdFpgaV6_DataParams_t * pDataParams,
                                 uint8_t bUnit,
                                 uint16_t wTimeout
                                 );

#endif /* PHHALHW_RDFPGAV6_H */
