/*
 * Copyright 2017, 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PCSC ISO14443-4 layer of Reader Library.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALI14443P4_PCSC_INT_H
#define PHPALI14443P4_PCSC_INT_H

#include <ph_Status.h>

#define PHPAL_I14443P4_PCSC_IS_INVALID_BLOCK_STATUS(bStatus)                \
    ((                                                                      \
    (((bStatus) & PH_ERR_MASK) == PH_ERR_IO_TIMEOUT) ||                     \
    (((bStatus) & PH_ERR_MASK) == PH_ERR_INTEGRITY_ERROR) ||                \
    (((bStatus) & PH_ERR_MASK) == PH_ERR_FRAMING_ERROR) ||                  \
    (((bStatus) & PH_ERR_MASK) == PH_ERR_COLLISION_ERROR))                  \
    ? 1 : 0                                                                 \
    )

#define PHPAL_I14443P4_PCSC_IS_R_BLOCK(bPcb)                                  \
    (                                                                       \
    (((bPcb) & PHPAL_I14443P4_PCSC_BLOCK_MASK) == PHPAL_I14443P4_PCSC_R_BLOCK)  \
    ? 1 : 0                                                                 \
    )

#define PHPAL_I14443P4_PCSC_IS_ACK(bPcb)                                  \
    (                                                                   \
    (((bPcb) & PHPAL_I14443P4_PCSC_PCB_NAK) == PHPAL_I14443P4_PCSC_PCB_ACK) \
    ? 1 : 0                                                             \
    )

#define PHPAL_I14443P4_PCSC_IS_I_BLOCK(bPcb)                                  \
    (                                                                       \
    (((bPcb) & PHPAL_I14443P4_PCSC_BLOCK_MASK) == PHPAL_I14443P4_PCSC_I_BLOCK)  \
    ? 1 : 0                                                                 \
    )

#define PHPAL_I14443P4_PCSC_IS_BLOCKNR_EQUAL(bPcb)                                    \
    (                                                                               \
    ((((bPcb) & PHPAL_I14443P4_PCSC_PCB_BLOCKNR) ^ pDataParams->bPcbBlockNum) == 0)   \
    ? 1 : 0                                                                         \
    )

#define PHPAL_I14443P4_PCSC_IS_CHAINING(bPcb)                                         \
    (                                                                               \
    (((bPcb) & PHPAL_I14443P4_PCSC_PCB_CHAINING) == PHPAL_I14443P4_PCSC_PCB_CHAINING)   \
    ? 1 : 0                                                                         \
    )

#define PHPAL_I14443P4_PCSC_IS_S_BLOCK(bPcb)                                  \
    (                                                                       \
    (((bPcb) & PHPAL_I14443P4_PCSC_BLOCK_MASK) == PHPAL_I14443P4_PCSC_S_BLOCK)  \
    ? 1 : 0                                                                 \
    )

#define PHPAL_I14443P4_PCSC_IS_WTX(bPcb)                                  \
    (                                                                   \
    (((bPcb) & PHPAL_I14443P4_PCSC_PCB_S_TYPE_MASK) == PHPAL_I14443P4_PCSC_PCB_WTX) \
    ? 1 : 0                                                             \
    )

#define PHPAL_I14443P4_PCSC_STATE_I_BLOCK_TX      0x01U       /* I-Block transmission mode  */
#define PHPAL_I14443P4_PCSC_STATE_I_BLOCK_RX      0x02U       /* I-Block reception mode  */
#define PHPAL_I14443P4_PCSC_STATE_FINISHED        0x0FU       /* Exchange finished mode  */
#define PHPAL_I14443P4_PCSC_STATE_RETRANSMIT_BIT  0x40U       /* An I-Block mode is retramsmitting */
#define PHPAL_I14443P4_PCSC_STATE_CHAINING_BIT    0x80U       /* An I-Block mode is chaining */
#define PHPAL_I14443P4_PCSC_STATE_MASK            0x0FU       /* Only 6 bits of the state are pure state codes */

#define PHPAL_I14443P4_PCSC_BLOCK_MASK            0xC0U       /* ISO 14443-4 Block Mask */
#define PHPAL_I14443P4_PCSC_CID_MASK              0x0FU       /* Valid CID bits within CID field */
#define PHPAL_I14443P4_PCSC_PCB_S_TYPE_MASK       0x32U       /* Bit mask within PCB for S block to get type */

#define PHPAL_I14443P4_PCSC_FWI_DEFAULT           0x04U       /* FWI default value */
#define PHPAL_I14443P4_PCSC_FSCI_DEFAULT          0x08U       /* FSCI default value */
#define PHPAL_I14443P4_PCSC_FSDI_DEFAULT          0x08U       /* FSDI default value */
#define PHPAL_I14443P4_PCSC_MAX_RETRIES_DEFAULT   2U          /* Default Maximum Retry count */

#define PHPAL_I14443P4_PCSC_I_BLOCK               0x00U       /* ISO 14443-4 I-Block */
#define PHPAL_I14443P4_PCSC_I_BLOCK_RFU_MASK      0x22U       /* ISO 14443-4 I-Block RFU mask */
#define PHPAL_I14443P4_PCSC_I_BLOCK_RFU_BITS      0x02U       /* ISO 14443-4 I-Block RFU bits */

#define PHPAL_I14443P4_PCSC_S_BLOCK               0xC0U       /* ISO 14443-4 S-Block */
#define PHPAL_I14443P4_PCSC_S_BLOCK_RFU_MASK      0x03U       /* ISO 14443-4 S-Block RFU mask */
#define PHPAL_I14443P4_PCSC_S_BLOCK_RFU_BITS      0x02U       /* ISO 14443-4 S-Block RFU bits */

#define PHPAL_I14443P4_PCSC_R_BLOCK               0x80U       /* ISO 14443-4 R-Block */
#define PHPAL_I14443P4_PCSC_R_BLOCK_RFU_MASK      0x26U       /* ISO 14443-4 R-Block RFU mask */
#define PHPAL_I14443P4_PCSC_R_BLOCK_RFU_BITS      0x22U       /* ISO 14443-4 R-Block RFU bits */

#define PHPAL_I14443P4_PCSC_PCB_POS               0x00U       /* Byte position of PCB byte */
#define PHPAL_I14443P4_PCSC_PCB_BLOCKNR           0x01U       /* Blocknumber Bit within PCB */

#define PHPAL_I14443P4_PCSC_PCB_CID_FOLLOWING     0x08U       /* Bit within PCB which signals presence of CID byte */
#define PHPAL_I14443P4_PCSC_PCB_NAD_FOLLOWING     0x04U       /* Bit within PCB which signals presence of NAD byte */

#define PHPAL_I14443P4_PCSC_PCB_WTX               0x32U       /* Bits within PCB which signal a WTX command */
#define PHPAL_I14443P4_PCSC_PCB_DESELECT          0x02U       /* Bits within PCB which signal a DESELECT command */
#define PHPAL_I14443P4_PCSC_PCB_NAK               0x10U       /* Bit within PCB which signals NAK */
#define PHPAL_I14443P4_PCSC_PCB_ACK               0x00U       /* Bit within PCB which signals ACK */
#define PHPAL_I14443P4_PCSC_PCB_CHAINING          0x10U       /* Bit within PCB which signals chaining */

#define PHPAL_I14443P4_PCSC_FWT_DESELECT_US       4833U       /* S(DESELECT) FTW in microseconds */
#define PHPAL_I14443P4_PCSC_EXT_TIME_US           60U         /* Time extension in microseconds for all commands.  */
#define PHPAL_I14443P4_PCSC_FWT_MIN_US            302U        /* FTW min in microseconds */
#define PHPAL_I14443P4_PCSC_FWT_MAX_US            4949000U    /* FTW max in microseconds */
#define PHPAL_I14443P4_PCSC_EXT_TIME_US           60U         /* Time extension in microseconds for all commands. */

phStatus_t phpalI14443p4_Pcsc_Int_BuildSBlock(
    uint8_t bCidEnabled,
    uint8_t bCid,
    uint8_t bIsWtx,
    uint8_t bWtxm,
    uint8_t * pTxBuffer,
    uint16_t * pTxLength
    );

phStatus_t phpalI14443p4_Pcsc_Int_BuildRBlock(
    uint8_t bCidEnabled,
    uint8_t bCid,
    uint8_t bPcbBlockNum,
    uint8_t bIsAck,
    uint8_t * pTxBuffer,
    uint16_t * pTxLength
    );

phStatus_t phpalI14443p4_Pcsc_Int_IsValidRBlock(
    uint8_t bCheckCid,
    uint8_t bCid,
    uint8_t * pRxBuffer,
    uint16_t wRxLength
    );

phStatus_t phpalI14443p4_Pcsc_Int_BuildIBlock(
    uint8_t bCidEnabled,
    uint8_t bCid,
    uint8_t bNadEnabled,
    uint8_t bNad,
    uint8_t bPcbBlockNum,
    uint8_t bChaining,
    uint8_t * pTxBuffer,
    uint16_t * pTxLength
    );

phStatus_t phpalI14443p4_Pcsc_Int_IsValidSBlock(
    uint8_t bCheckCid,
    uint8_t bCid,
    uint8_t * pRxBuffer,
    uint16_t wRxLength
    );

phStatus_t phpalI14443p4_Pcsc_Int_IsValidIBlock(
    uint8_t bCheckCid,
    uint8_t bCid,
    uint8_t bCheckNad,
    uint8_t bNad,
    uint8_t * pRxBuffer,
    uint16_t wRxLength
    );

phStatus_t phpalI14443p4_Pcsc_Int_IsoHandling(
    phpalI14443p4_Pcsc_DataParams_t * pDataParams,
    uint16_t wOption,
    uint8_t bRetryCount,
    uint8_t * pTxBuffer,
    uint16_t wTxLength,
    uint8_t ** ppRxBuffer,
    uint16_t * pRxLength
    );

phStatus_t phpalI14443p4_Pcsc_Int_TransparentExchange(
    phpalI14443p4_Pcsc_DataParams_t * pDataParams,
    uint16_t wOption,
    uint8_t * pTxBuffer,
    uint16_t wTxLength,
    uint8_t ** ppRxBuffer,
    uint16_t * pRxLength
    );

#endif /* PHPALI14443P4_PCSC_INT_H */
