/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software ISO14443-4A Component of Basic Function Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phpalI14443p4a.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHPAL_I14443P4A_RD710

#include <phhalHw_Rd710_Cmd.h>
#include "phpalI14443p4a_Rd710.h"

phStatus_t phpalI14443p4a_Rd710_Init(
                                      phpalI14443p4a_Rd710_DataParams_t * pDataParams,
                                      uint16_t wSizeOfDataParams,
                                      phhalHw_Rd710_DataParams_t * pHalDataParams
                                      )
{
    if (sizeof(phpalI14443p4a_Rd710_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_ISO14443P4A);
    }
	PH_ASSERT_NULL (pDataParams);
	PH_ASSERT_NULL (pHalDataParams);

    /* init private data */
    pDataParams->wId            = PH_COMP_PAL_ISO14443P4A | PHPAL_I14443P4A_RD710_ID;
    pDataParams->pHalDataParams = pHalDataParams;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_PAL_ISO14443P4A);
}

phStatus_t phpalI14443p4a_Rd710_Rats(
                                      phpalI14443p4a_Rd710_DataParams_t * pDataParams,
                                      uint8_t bFsdi,
                                      uint8_t bCid,
                                      uint8_t * pAts
                                      )
{
    return phhalHw_Rd710_Cmd_I14443P4A_Rats(
        pDataParams->pHalDataParams,
        bFsdi,
        bCid,
        pAts
        );
}

phStatus_t phpalI14443p4a_Rd710_Pps(
                                     phpalI14443p4a_Rd710_DataParams_t * pDataParams,
                                     uint8_t bDri,
                                     uint8_t bDsi
                                     )
{
    return phhalHw_Rd710_Cmd_I14443P4A_Pps(
        pDataParams->pHalDataParams,
        bDri,
        bDsi
        );
}

phStatus_t phpalI14443p4a_Rd710_ActivateCard(
                                                phpalI14443p4a_Rd710_DataParams_t * pDataParams,
                                                uint8_t bFsdi,
                                                uint8_t bCid,
                                                uint8_t bDri,
                                                uint8_t bDsi,
                                                uint8_t * pAts
                                                )
{
    return phhalHw_Rd710_Cmd_I14443P4A_ActivateCard(
        pDataParams->pHalDataParams,
        bFsdi,
        bCid,
        bDri,
        bDsi,
        pAts
        );
}

phStatus_t phpalI14443p4a_Rd710_GetProtocolParams(
												phpalI14443p4a_Rd710_DataParams_t * pDataParams,
                                                uint8_t * pCidEnabled,
                                                uint8_t * pCid,
                                                uint8_t * pNadSupported,
                                                uint8_t * pFwi,
                                                uint8_t * pFsdi,
                                                uint8_t * pFsci
                                                )
{
    return phhalHw_Rd710_Cmd_I14443P4A_GetProtocolParams(
	    pDataParams->pHalDataParams,
        pCidEnabled,
        pCid,
        pNadSupported,
        pFwi,
        pFsdi,
        pFsci
        );
}

#endif /* NXPBUILD__PHPAL_I14443P4A_RD710 */
