/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Rd710 MIFARE(R) Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phpalMifare.h>
#include <ph_RefDefs.h>
#include <phTools.h>

#ifdef NXPBUILD__PHPAL_MIFARE_RD710

#include "../phpalMifare_Int.h"
#include "phpalMifare_Rd710.h"
#include <phhalHw_Rd710_Cmd.h>

phStatus_t phpalMifare_Rd710_Init(
                                  phpalMifare_Rd710_DataParams_t * pDataParams,
                                  uint16_t wSizeOfDataParams,
                                  phhalHw_Rd710_DataParams_t * pHalDataParams
                                  )
{
    if (sizeof(phpalMifare_Rd710_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
    }
    PH_ASSERT_NULL (pDataParams);
    PH_ASSERT_NULL (pHalDataParams);

    /* init private data */
    pDataParams->wId                    = PH_COMP_PAL_MIFARE | PHPAL_MIFARE_RD710_ID;
    pDataParams->pHalDataParams         = pHalDataParams;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_PAL_MIFARE);
}

phStatus_t phpalMifare_Rd710_ExchangeL3(
                                        phpalMifare_Rd710_DataParams_t * pDataParams,
                                        uint16_t wOption,
                                        uint8_t * pTxBuffer,
                                        uint16_t wTxLength,
                                        uint8_t ** ppRxBuffer,
                                        uint16_t * pRxLength
                                        )
{
    return phhalHw_Rd710_Cmd_MIFARE_ExchangeL3(
        pDataParams->pHalDataParams,
        wOption,
        pTxBuffer,
        wTxLength,
        ppRxBuffer,
        pRxLength
        );
}

phStatus_t phpalMifare_Rd710_ExchangeL4(
                                        phpalMifare_Rd710_DataParams_t * pDataParams,
                                        uint16_t wOption,
                                        uint8_t * pTxBuffer,
                                        uint16_t wTxLength,
                                        uint8_t ** ppRxBuffer,
                                        uint16_t * pRxLength
                                        )
{
    return phhalHw_Rd710_Cmd_MIFARE_ExchangeL4(
        pDataParams->pHalDataParams,
        wOption,
        pTxBuffer,
        wTxLength,
        ppRxBuffer,
        pRxLength
        );
}

phStatus_t phpalMifare_Rd710_ExchangePc(
                                        phpalMifare_Rd710_DataParams_t * pDataParams,
                                        uint16_t wOption,
                                        uint8_t * pTxBuffer,
                                        uint16_t wTxLength,
                                        uint8_t ** ppRxBuffer,
                                        uint16_t * pRxLength
                                        )
{
    return phhalHw_Rd710_Cmd_MIFARE_ExchangePc(
        pDataParams->pHalDataParams,
        wOption,
        pTxBuffer,
        wTxLength,
        ppRxBuffer,
        pRxLength
        );
}

phStatus_t phpalMifare_Rd710_ExchangeRaw(
    phpalMifare_Rd710_DataParams_t * pDataParams,
    uint16_t wOption,
    uint8_t * pTxBuffer,
    uint16_t wTxLength,
    uint8_t bTxLastBits,
    uint8_t ** ppRxBuffer,
    uint16_t * pRxLength,
    uint8_t * pRxLastBits
    )
{
    return phhalHw_Rd710_Cmd_MIFARE_ExchangeRaw(
        pDataParams->pHalDataParams,
        wOption,
        pTxBuffer,
        wTxLength,
        bTxLastBits,
        ppRxBuffer,
        pRxLength,
        pRxLastBits
        );
}

phStatus_t phpalMifare_Rd710_MfcAuthenticateKeyNo(
    phpalMifare_Rd710_DataParams_t * pDataParams,
    uint8_t bBlockNo,
    uint8_t bKeyType,
    uint16_t wKeyNo,
    uint16_t wKeyVersion,
    uint8_t * pUid
    )
{
    return phhalHw_Rd710_Cmd_MIFARE_MfcAuthenticateKeyNo(
        pDataParams->pHalDataParams,
        bBlockNo,
        bKeyType,
        wKeyNo,
        wKeyVersion,
        pUid);
}

phStatus_t phpalMifare_Rd710_MfcAuthenticate(
    phpalMifare_Rd710_DataParams_t * pDataParams,
    uint8_t bBlockNo,
    uint8_t bKeyType,
    uint8_t * pKey,
    uint8_t * pUid
    )
{
    return phhalHw_Rd710_Cmd_MIFARE_MfcAuthenticate(
        pDataParams->pHalDataParams,
        bBlockNo,
        bKeyType,
        pKey,
        pUid);
}

#endif /* NXPBUILD__PHPAL_MIFARE_RD710 */
