/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example Source for Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

/**
 * Header
 */
#include "Example-Rc663_ISO14443B.h"
int __cdecl main(int argc, char *argv[])
{
    /* ******************************************************************************* */
    /* DECLARATION */
    /* ******************************************************************************* */
    /* data parameter storage */
    phbalReg_SerialWin_DataParams_t balSerial;
    phhalHw_Rc663_DataParams_t      halReader;
    phpalI14443p3b_Sw_DataParams_t  palI14443p3B;

    /* common variables */
    uint8_t bIndex;
    char * pArgument;
    phStatus_t status;

    /* variables used by the BAL component */
    uint8_t * pComPort = (uint8_t*)"COM1";

    /* variables used by the HAL component */
    uint8_t bHalBufferReader[256];

    /* variables used by the PAL component */
    uint8_t pPupi[4], bPupiLength;
    uint8_t bNumSlots;
    uint8_t bAfi, pAtqb[13], bAtqbLen, bExtAtqb;
    uint8_t bCid, bFsdi, bDri, bDsi;
    uint8_t bMbli, bMoreCardsAvaliable;

    /* variables used by the AL component */

    /* ******************************************************************************* */
    /* INITIALISATION */
    /* ******************************************************************************* */
    /* iterate through all arguments */
    for (bIndex = 0; bIndex < (uint8_t)argc; ++bIndex);
    {
        /* Retrive next argument */
        pArgument = argv[bIndex];

        /* */
        /* Insert argument handling here */
        /* */
    }

    /* initialise the 'bus abstraction layer' BAL: */
    /* use the serial interface */
    status = phbalReg_SerialWin_Init(&balSerial, sizeof(phbalReg_SerialWin_DataParams_t), 0, NULL);
    CHECK_SUCCESS(status);

    status = phbalReg_SetPort(&balSerial, pComPort);
    CHECK_SUCCESS(status);

    /* initialise the 'hardware abstraction layer' HAL: */
    /* use the RC663 Reader IC, glue it together with the BAL component */
    status = phhalHw_Rc663_Init(
        &halReader,
        sizeof(phhalHw_Rc663_DataParams_t),
        &balSerial,
        NULL,
        bHalBufferReader,
        sizeof(bHalBufferReader),
        bHalBufferReader,
        sizeof(bHalBufferReader));
    CHECK_SUCCESS(status);

    /* initialise the 'protocol abstraction layer' PAL: */
    /* use the the ISO14443 TypeB protocol. */
    status = phpalI14443p3b_Sw_Init(&palI14443p3B, sizeof(palI14443p3B), &halReader);
    CHECK_SUCCESS(status);

    status = phbalReg_OpenPort(&balSerial);
    CHECK_SUCCESS(status);

    /* set the PCs baud rate to 115200 */
    status = phbalReg_SetConfig(&balSerial, PHBAL_REG_SERIALWIN_CONFIG_BITRATE, PHBAL_REG_SERIALWIN_VALUE_BITRATE_115200);
    CHECK_SUCCESS(status);

    /* On some machines the RS232 physical interface jitters when the port is opened. For that case, */
    /* send a dummy command in order to the resynchronise the interface. */
    phhalHw_WriteRegister(&halReader, 0x37, 0xFF);

    /* Configure HAL for ISO14443 TypeB cards */
    status = phhalHw_ApplyProtocolSettings(&halReader, PHHAL_HW_CARDTYPE_ISO14443B);
    CHECK_SUCCESS(status);

    /* ******************************************************************************* */
    /* CARD COMMUNICATION */
    /* ******************************************************************************* */
    /* Switch on the field */
    status = phhalHw_FieldReset(&halReader);
    CHECK_SUCCESS(status);

    /* Activate card */
    bPupiLength = 0;
    bNumSlots = 0;
    bAfi = 0x00;
    bExtAtqb = 0;
    bFsdi = 8;
    bCid = 0;
    bDri = PHPAL_I14443P3B_DATARATE_106;
    bDsi = PHPAL_I14443P3B_DATARATE_106;

    status = phpalI14443p3b_ActivateCard( &palI14443p3B, pPupi, bPupiLength, bNumSlots,
                                           bAfi, bExtAtqb, bFsdi, bCid,
                                           bDri, bDsi, pAtqb, &bAtqbLen,
                                           &bMbli, &bMoreCardsAvaliable);
    printf("phpalI14443p3b_ActivateCard:  %04X\n", status);

    if(PH_ERR_SUCCESS == status)
    {
        status = phpalI14443p3b_GetSerialNo(&palI14443p3B, pPupi);
        printf("phpalFelica_GetSerialNo:   %04X\nUID: ", status);
        if(PH_ERR_SUCCESS == status)
            printBufferHex(pPupi, 4);
    }

    status = phbalReg_ClosePort(&balSerial);
    fprintf(stdout, "\n press any key to exit\n");
    _getch();
    return 0;
}

/**
 * Helper functions
 */
void printBufferHex(uint8_t * pBuffer, uint8_t bLength)
{
    uint8_t bIndex;

    for (bIndex = 0; bIndex < bLength; ++bIndex)
    {
        printf("%02X ", pBuffer[bIndex]);
    }
    printf("\n");
}