/*
 * Copyright 2015 - 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example Source for Icode DNA.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef EXAMPLE_ICODEDNA
#define EXAMPLE_ICODEDNA

	/* Reader Library Headers. */
	#include <phbalReg.h>
	#include <phhalHw.h>

	#include <phCidManager.h>

	#include <phKeyStore.h>
	#include <phCryptoRng.h>
	#include <phCryptoSym.h>

	#include <phpalSli15693.h>
	#include <phalICode.h>

	/* Standard Header. */
	#ifdef _WIN32
		#pragma warning(push)           /* PRQA S 3116 */
		#pragma warning(disable:4001)   /* PRQA S 3116 */
	#endif
		#include <crtdbg.h>
		#include <memory.h>
		#include <stdio.h>
		#include <string.h>
		#include <stdlib.h>
		#include <conio.h>
	#ifdef _WIN32
		#pragma warning(pop)            /* PRQA S 3116 */
	#endif

	#define CHECK_SUCCESS(status, print)									\
		__pragma (warning(push))           /* PRQA S 3116 */				\
		__pragma (warning(disable:4127))   /* PRQA S 3116 */				\
			if ( (status) != PH_ERR_SUCCESS )								\
			{																\
				if ( (print) )												\
				{															\
					printf ( "Error, Code: 0x%04X\n\n", (status) );			\
				}															\
				else														\
				{															\
					printf ( "An error occurred: (0x%04X)\n", (status) );	\
				}															\
																			\
				printf ( "Pressing any key will exit the demo. \n" );		\
				_getch ();													\
				exit ( 0 );													\
			}																\
			else															\
			{																\
				if ( (print) )												\
				{															\
					printf ( "Success\n" );									\
				}															\
			}																\
			__pragma (warning(pop))           /* PRQA S 3116 */

	#define UNUSED_VARIABLE(x)  {for( ( x ) = ( x ) ; ( x ) != ( x ) ; );}
	#define UNUSED_ARRAY(x)  {for( ( (x)[0] ) = ( (x)[0] ) ; ( (x)[0] ) != ( (x)[0] ) ; );}

	#define PRINT_MACRO(macro) #macro

	#define PCSC_READER_NO_SAM_NAME "NXP Pegoda N CL 0 0"	/* Pegoda 2 reader name wiht no SAM support. */
	#define GLOBAL_BUFFER_SIZE		0x012CU					/* Global size of transmit and recieve buffer. */

	/* Configuration block address in card -------------------------------------------------------------------------*/
	#define GLOBAL_CRYPTO_HEADER		12					/* Global crypto header (GCH) address location in the card. */
	#define CRYPTO_CONFIGURATION_HEADER	13					/* Crypto configuration header (CCH) address location in the card. */
	#define AUTHENTICATION_LIMIT		14					/* Authentication limit address location in the card. */
	#define KEY_HEADER_0				16					/* Key 0 header (KH0) address location in the card. */
	#define KEY_PREVILAGE_0				17					/* Key 0 previlage (KP0) address location in the card. */
	#define KEY_0						32					/* Key 0 (Key0) address location in the card. */

	/* AES key address in the card ---------------------------------------------------------------------------------*/
	#define CARD_KEY_0					0x00				/* AES key 0 address */

	/* Software keystore key address loation -----------------------------------------------------------------------*/
	#define AES_KEY_0_ADDRESS			0x00				/* AES key 0 address in keystore */
	#define AES_KEY_0_VERSION			0x00				/* AES key 0 version in keystore */

	/* Card and software keystore key values -----------------------------------------------------------------------*/
	uint8_t gaKey_0[]					= { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

	/* Configuration block values ----------------------------------------------------------------------------------*/
	uint8_t gaGlobalCryptoHeader[]		= { 0x00, 0xE7, 0x00, 0x00 };
	uint8_t gaCyptoConfigHeader[]		= { 0x00, 0xE7, 0x00, 0x00 };
	uint8_t gaAuthLimit[]				= { 0x00, 0x00, 0x80, 0x00 };
	uint8_t gaKeyHeader_0[]				= { 0x00, 0xE7, 0x00, 0x00 };
	uint8_t gaKeyPrevilage_0[]			= { 0x3F, 0x00, 0x00, 0x00 };

	uint8_t bIsEnggSample = 0;

	void * pHal_Generic = NULL;
	void * pPal_Generic = NULL;

	phKeyStore_Sw_DataParams_t stKeyStore;
	phpalSli15693_Sw_DataParams_t stPal15693_Sw;
	phalICode_Sw_DataParams_t stICode;

	phStatus_t UpdateKeystore ();
	phStatus_t ResetConfigMemory();
	phStatus_t UpdateConfigMemory();
	uint8_t HexString2Hex ( uint8_t bData );
	void PrintData ( uint8_t * pBuffer, uint32_t dwLength, char* pFormat, char* pSpecialChar );
	phStatus_t ReadConfig ( uint8_t* pName, uint8_t bBlock, uint8_t* pBuffer, uint16_t wBuffLen );
	phStatus_t WriteConfig ( uint8_t* pName, uint8_t bBlock, uint8_t* pBuffer, uint8_t bBuffLen );
	void ICode_Log ( void* pDataParams, uint8_t bOption, phLog_LogEntry_t* pEntries, uint16_t wEntryCount );

#endif /* EXAMPLE_ICODEDNA */
