/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Rd710 Cid Manager Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phCidManager.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PH_CIDMANAGER_RD710

#include "phCidManager_Rd710.h"
#include <phhalHw_Rd710_Cmd.h>

phStatus_t phCidManager_Rd710_Init(
                                    phCidManager_Rd710_DataParams_t * pDataParams,
                                    uint16_t wSizeOfDataParams,
                                    phhalHw_Rd710_DataParams_t * pHalDataParams
                                    )
{
    if (sizeof(phCidManager_Rd710_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_CIDMANAGER);
    }
	PH_ASSERT_NULL (pDataParams);
	PH_ASSERT_NULL (pHalDataParams);

    /* Set identifier */
    pDataParams->wId            = PH_COMP_CIDMANAGER | PH_CIDMANAGER_RD710_ID;
    pDataParams->pHalDataParams = pHalDataParams;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CIDMANAGER);
}

phStatus_t phCidManager_Rd710_GetFreeCid(
                                    phCidManager_Rd710_DataParams_t * pDataParams,
                                    uint8_t * pCid
                                    )
{
    return phhalHw_Rd710_Cmd_CID_GetFreeCid(
                pDataParams->pHalDataParams,
                pCid
                );
}

phStatus_t phCidManager_Rd710_FreeCid(
                                    phCidManager_Rd710_DataParams_t * pDataParams,
                                    uint8_t bCid
                                    )
{
    return phhalHw_Rd710_Cmd_CID_FreeCid(
                pDataParams->pHalDataParams,
                bCid
                );
}
#endif    /* NXPBUILD__PH_CIDMANAGER_RD710 */
