/*
 * Copyright 2022 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * DUT specific Random Number Component of the Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  Generated 24. Aug 2022
 *
 */

#include <ph_Status.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PH_CRYPTORNG_DUT

#include <phCryptoRng.h>
#include <phhalHw_DUT_Cmd.h>
#include "phCryptoRng_DUT.h"

phStatus_t phCryptoRng_DUT_Init(phCryptoRng_DUT_DataParams_t * pDataParams, uint16_t wSizeOfDataParams, void * pHalDataParams)
{
    if(sizeof(phCryptoRng_DUT_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_CRYPTORNG);
    }
    PH_ASSERT_NULL(pDataParams);

    /* Init. private data */
    pDataParams->wId = PH_COMP_CRYPTORNG | PH_CRYPTORNG_DUT_ID;
    pDataParams->pHalDataParams = pHalDataParams;

    return phhalHw_DUT_Cmd_CryptoRng_Init(pHalDataParams);
}

phStatus_t phCryptoRng_DUT_DeInit(phCryptoRng_DUT_DataParams_t * pDataParams)
{
    phStatus_t  PH_MEMLOC_REM wStatus = PH_ERR_SUCCESS;

    wStatus = phhalHw_DUT_Cmd_CryptoRng_DeInit(pDataParams->pHalDataParams);

    pDataParams->wId = 0xFFFFU;
    pDataParams->pHalDataParams = NULL;

    return PH_ERR_SUCCESS;
}

phStatus_t phCryptoRng_DUT_GetLastStatus(phCryptoRng_DUT_DataParams_t * pDataParams, uint16_t wStatusMsgLen, int8_t * pStatusMsg,
    int32_t * pStatusCode)
{
    return phhalHw_DUT_Cmd_CryptoRng_GetLastStatus(
        pDataParams->pHalDataParams,
        wStatusMsgLen,
        pStatusMsg,
        pStatusCode);
}

phStatus_t phCryptoRng_DUT_Seed(phCryptoRng_DUT_DataParams_t * pDataParams, uint8_t * pSeed, uint8_t bSeedLen)
{
    return phhalHw_DUT_Cmd_CryptoRng_Seed(pDataParams->pHalDataParams,
        pSeed,
        bSeedLen);
}

phStatus_t phCryptoRng_DUT_Rnd(phCryptoRng_DUT_DataParams_t * pDataParams, uint16_t  wNoOfRndBytes, uint8_t * pRnd)
{
    return phhalHw_DUT_Cmd_CryptoRng_Rnd(pDataParams->pHalDataParams,
        wNoOfRndBytes,
        pRnd);
}

#endif /* NXPBUILD__PH_CRYPTORNG_DUT */
