/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * DUT KeyStore Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  Generated 20 Sep, 2022
 *
 */

#include <ph_Status.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PH_KEYSTORE_DUT

#include "phKeyStore_DUT.h"
#include <phhalHw_DUT_Cmd.h>

phStatus_t phKeyStore_DUT_Init(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wSizeOfDataParams, void * pHalDataParams,
    uint16_t wNoOfKeyEntries)
{
    phStatus_t PH_MEMLOC_REM wStatus = 0;

    if(sizeof(phKeyStore_DUT_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_KEYSTORE);
    }

    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_KEYSTORE);
    PH_ASSERT_NULL_DATA_PARAM(pHalDataParams, PH_COMP_KEYSTORE);

    /* Init private data */
    pDataParams->wId = PH_COMP_KEYSTORE | PH_KEYSTORE_DUT_ID;
    pDataParams->pHalDataParams = pHalDataParams;

    PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_DUT_Cmd_KeyStore_Init(
        pDataParams->pHalDataParams,
        wNoOfKeyEntries));

    return wStatus;
}

phStatus_t phKeyStore_DUT_DeInit(phKeyStore_DUT_DataParams_t * pDataParams)
{
    return phhalHw_DUT_Cmd_KeyStore_DeInit(
        pDataParams->pHalDataParams
    );
}





/* Common Interfaces ------------------------------------------------------------------------------------------------------------------- */
phStatus_t phKeyStore_DUT_FormatKeyEntry(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wNewKeyType)
{
    return phhalHw_DUT_Cmd_KeyStore_FormatKeyEntry(
        pDataParams->pHalDataParams,
        wKeyNo,
        wNewKeyType);
}

phStatus_t phKeyStore_DUT_SetKUC(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wRefNoKUC)
{
    return phhalHw_DUT_Cmd_KeyStore_SetKUC(
        pDataParams->pHalDataParams,
        wKeyNo,
        wRefNoKUC);
}

phStatus_t phKeyStore_DUT_GetKUC(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wRefNoKUC, uint32_t * pLimit,
    uint32_t * pCurVal)
{
    return phhalHw_DUT_Cmd_KeyStore_GetKUC(
        pDataParams->pHalDataParams,
        wRefNoKUC,
        pLimit,
        pCurVal);
}

phStatus_t phKeyStore_DUT_ChangeKUC(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wRefNoKUC, uint32_t dwLimit)
{
    return phhalHw_DUT_Cmd_KeyStore_ChangeKUC(
        pDataParams->pHalDataParams,
        wRefNoKUC,
        dwLimit);
}

phStatus_t phKeyStore_DUT_SetConfig(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue)
{
    return phhalHw_DUT_Cmd_KeyStore_SetConfig(
        pDataParams->pHalDataParams,
        wConfig,
        wValue);
}

phStatus_t phKeyStore_DUT_SetConfigStr(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint8_t *pBuffer,
    uint16_t wBuffLen)
{
    return phhalHw_DUT_Cmd_KeyStore_SetConfigStr(
        pDataParams->pHalDataParams,
        wConfig,
        pBuffer,
        wBuffLen);
}

phStatus_t phKeyStore_DUT_GetConfig(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue)
{
    return phhalHw_DUT_Cmd_KeyStore_GetConfig(
        pDataParams->pHalDataParams,
        wConfig,
        pValue);
}

phStatus_t phKeyStore_DUT_GetConfigStr(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint8_t ** ppBuffer,
    uint16_t * pBuffLen)
{
    return phhalHw_DUT_Cmd_KeyStore_GetConfigStr(
        pDataParams->pHalDataParams,
        wConfig,
        ppBuffer,
        pBuffLen);
}





/* Interfaces for Symmetric Keys ------------------------------------------------------------------------------------------------------- */
phStatus_t phKeyStore_DUT_SetKey(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer,
    uint16_t wKeyType, uint8_t * pNewKey, uint16_t wNewKeyVer)
{
    return phhalHw_DUT_Cmd_KeyStore_SetKey(
        pDataParams->pHalDataParams,
        wKeyNo,
        wKeyVer,
        wKeyType,
        pNewKey,
        wNewKeyVer);
}

phStatus_t phKeyStore_DUT_SetKeyAtPos(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wPos, uint16_t wKeyType,
    uint8_t * pNewKey, uint16_t wNewKeyVer)
{
    return phhalHw_DUT_Cmd_KeyStore_SetKeyAtPos(
        pDataParams->pHalDataParams,
        wKeyNo,
        wPos,
        wKeyType,
        pNewKey,
        wNewKeyVer);
}

phStatus_t phKeyStore_DUT_SetFullKeyEntry(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wNoOfKeys, uint16_t wKeyNo,
    uint16_t wNewRefNoKUC, uint16_t wNewKeyType, uint8_t * pNewKeys, uint16_t * pNewKeyVerList)
{
    return phhalHw_DUT_Cmd_KeyStore_SetFullKeyEntry(
        pDataParams->pHalDataParams,
        wNoOfKeys,
        wKeyNo,
        wNewRefNoKUC,
        wNewKeyType,
        pNewKeys,
        pNewKeyVerList);
}

phStatus_t phKeyStore_DUT_GetKeyEntry(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVerBufSize,
    uint16_t * pKeyVer, uint16_t * pKeyVerLen, uint16_t * pKeyType)
{
    return phhalHw_DUT_Cmd_KeyStore_GetKeyEntry(
        pDataParams->pHalDataParams,
        wKeyNo,
        wKeyVerBufSize,
        pKeyVer,
        pKeyVerLen,
        pKeyType);
}

phStatus_t phKeyStore_DUT_GetKey(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bKeyBufSize,
    uint8_t * pKey, uint16_t * pKeyType)
{
    return phhalHw_DUT_Cmd_KeyStore_GetKey(
        pDataParams->pHalDataParams,
        wKeyNo,
        wKeyVer,
        bKeyBufSize,
        pKey,
        pKeyType);
}





#ifdef  NXPBUILD__PH_KEYSTORE_ASYM
/* Interfaces for ASymmetric Keys ------------------------------------------------------------------------------------------------------ */
phStatus_t phKeyStore_DUT_SetKeyASym(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wPos, uint16_t wKeyType,
    uint16_t wKeyInfo, uint8_t * pKey, uint16_t wKeyLen)
{
    return phhalHw_DUT_Cmd_KeyStore_SetKeyASym(
        pDataParams->pHalDataParams,
        wKeyNo,
        wPos,
        wKeyType,
        wKeyInfo,
        pKey,
        wKeyLen);
}

phStatus_t phKeyStore_DUT_GetKeyASym(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wPos, uint16_t wKeyPairType,
    uint16_t * pKeyType, uint8_t * pCurveID, uint8_t * pKey, uint16_t * pKeyLen)
{
    return phhalHw_DUT_Cmd_KeyStore_GetKeyASym(
        pDataParams->pHalDataParams,
        wKeyNo,
        wPos,
        wKeyPairType,
        pKeyType,
        pCurveID,
        pKey,
        pKeyLen);
}
#endif /* NXPBUILD__PH_KEYSTORE_ASYM */





#ifdef NXPBUILD__PH_KEYSTORE_DUT_NDA
phStatus_t phKeyStore_DUT_Provision_Init(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wOption, uint8_t *pTransportKey_AES128,
    uint8_t *pTransportKey_AES256, uint8_t *pAppRootKey_AES128, uint8_t *pAppRootKey_AES256, uint8_t *pExpDecData, uint8_t * pDervMsg,
    uint8_t * pWrapIV)
{
    return phhalHw_DUT_Cmd_KeyStore_Provision_Init(
        pDataParams->pHalDataParams,
        wOption,
        pTransportKey_AES128,
        pTransportKey_AES256,
        pAppRootKey_AES128,
        pAppRootKey_AES256,
        pExpDecData,
        pDervMsg,
        pWrapIV);
}

void phKeyStore_DUT_Provision_DeInit(phKeyStore_DUT_DataParams_t * pDataParams)
{
    phhalHw_DUT_Cmd_KeyStore_Provision_DeInit(pDataParams->pHalDataParams);
}

phStatus_t phKeyStore_DUT_SetConfig_Ext(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint8_t * pValue, uint16_t wValueLen)
{
    return phhalHw_DUT_Cmd_KeyStore_SetConfig_Ext(
        pDataParams->pHalDataParams,
        wConfig,
        pValue,
        wValueLen);
}

phStatus_t phKeyStore_DUT_GetConfig_Ext(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint8_t * pValue, uint16_t * pValueLen)
{
    return phhalHw_DUT_Cmd_KeyStore_GetConfig_Ext(
        pDataParams->pHalDataParams,
        wConfig,
        pValue,
        pValueLen);
}

phStatus_t phKeyStore_DUT_Provision_AppFixedKeys(phKeyStore_DUT_DataParams_t * pDataParams, uint8_t bKeyIndex, uint16_t wKeyType,
    uint8_t * pNewKey)
{
    return phhalHw_DUT_Cmd_KeyStore_Provision_AppFixedKeys(
        pDataParams->pHalDataParams,
        bKeyIndex,
        wKeyType,
        pNewKey);
}

#endif /* NXPBUILD__PH_KEYSTORE_DUT_NDA */

#endif /* NXPBUILD__PH_KEYSTORE_DUT */
