/*
 * Copyright 2017 - 2020, 2022 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Sam NonX ICode Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  CHu: Generated 02. January 2017
 *
 */

#ifndef PHALICODE_SAM_NONX_H
#define PHALICODE_SAM_NONX_H

#include <ph_Status.h>

#ifdef NXPBUILD__PHAL_ICODE_SAM_NONX
/* iCode Mandatory commands ---------------------------------------------------------------------------------------- */
phStatus_t phalICode_Sam_NonX_Inventory(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t * pDsfid, uint8_t * pUid);

phStatus_t phalICode_Sam_NonX_StayQuiet(phalICode_SamAV3_NonX_DataParams_t * pDataParams);





/* iCode Optional commands ----------------------------------------------------------------------------------------- */
phStatus_t phalICode_Sam_NonX_ReadSingleBlock(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint8_t bBlockNo, uint8_t ** ppData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_WriteSingleBlock(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint8_t bBlockNo, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalICode_Sam_NonX_LockBlock(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockNo);

phStatus_t phalICode_Sam_NonX_ReadMultipleBlocks(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint8_t bBlockNo, uint8_t bNumBlocks,
    uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_Select(phalICode_SamAV3_NonX_DataParams_t * pDataParams);

phStatus_t phalICode_Sam_NonX_ResetToReady(phalICode_SamAV3_NonX_DataParams_t * pDataParams);

phStatus_t phalICode_Sam_NonX_WriteAFI(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint8_t bAfi);

phStatus_t phalICode_Sam_NonX_LockAFI(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sam_NonX_WriteDSFID(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint8_t bDsfid);

phStatus_t phalICode_Sam_NonX_LockDSFID(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sam_NonX_GetSystemInformation(phalICode_SamAV3_NonX_DataParams_t * pDataParams,
    uint8_t ** ppSystemInfo, uint16_t * pSystemInfoLen);

phStatus_t phalICode_Sam_NonX_GetMultipleBlockSecurityStatus(phalICode_SamAV3_NonX_DataParams_t * pDataParams,
    uint8_t bBlockNo, uint8_t bNoOfBlocks, uint8_t * pStatus, uint16_t * pStatusLen);

phStatus_t phalICode_Sam_NonX_FastReadMultipleBlocks(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint8_t bBlockNo, uint8_t bNumBlocks, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_ExtendedReadSingleBlock(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint16_t wBlockNo, uint8_t ** ppData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_ExtendedWriteSingleBlock(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint16_t wBlockNo, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalICode_Sam_NonX_ExtendedLockBlock(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint16_t wBlockNo);

phStatus_t phalICode_Sam_NonX_ExtendedReadMultipleBlocks(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint16_t wBlockNo, uint16_t wNumBlocks, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_AuthenticateTAM(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint16_t wOption,
    uint8_t bKeyNo, uint8_t bKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivLen);

phStatus_t phalICode_Sam_NonX_AuthenticateTAM1(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint8_t bKeyNo, uint8_t bKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivLen);

phStatus_t phalICode_Sam_NonX_AuthenticateTAM2(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bKeyNo,
    uint8_t bKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivLen, uint8_t bBlockSize, uint8_t bBlockCount,
    uint8_t bProfile, uint8_t bProtMode, uint16_t wOffset, uint8_t * pCustomData, uint16_t * pCustomDataLen);

phStatus_t phalICode_Sam_NonX_AuthenticateMAM(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bKeyNo,
    uint8_t bKeyVer, uint8_t bKeyNoCard, uint8_t bPurposeMAM2, uint8_t * pDivInput, uint8_t bDivLen);

#ifdef NXPBUILD__PHAL_ICODE_INTERNAL
phStatus_t phalICode_Sam_NonX_WriteCertificate(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bCertNo,
    uint16_t wWordPtr, uint8_t * pCertificate, uint8_t bCertLen);

phStatus_t phalICode_Sam_NonX_ReadCertificate(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bCertNo, uint16_t wWordPtr,
    uint16_t wWordCount, uint8_t ** ppCertificate, uint16_t *pCertLen);
#endif /* NXPBUILD__PHAL_ICODE_INTERNAL */

phStatus_t phalICode_Sam_NonX_Challenge(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint16_t wOption, uint8_t bChallengeType,
    uint8_t bKeyID_CertNum, uint8_t * pChallenge, uint16_t wChallengeLen);

phStatus_t phalICode_Sam_NonX_ReadBuffer(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bVerify, uint8_t bKeyNo,
    uint8_t bKeyVer, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalICode_Sam_NonX_ExtendedGetSystemInformation(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bInfoParams,
    uint8_t ** ppSystemInfo, uint16_t * pSystemInfoLen);

phStatus_t phalICode_Sam_NonX_ExtendedGetMultipleBlockSecurityStatus(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint16_t wBlockNo,
    uint16_t wNoOfBlocks, uint8_t * pStatus, uint16_t * pStatusLen);

phStatus_t phalICode_Sam_NonX_ExtendedFastReadMultipleBlocks(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint16_t wBlockNo, uint16_t wNumBlocks, uint8_t * pData, uint16_t * pDataLen);





/* iCode Custom commands ------------------------------------------------------------------------------------------- */
phStatus_t phalICode_Sam_NonX_InventoryRead(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bBlockNo, uint8_t bNoOfBlocks, uint8_t * pUid, uint8_t * pUidLen,
    uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_InventoryReadExtended(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bExtendedOptions, uint8_t * pCID, uint8_t bBlockNo, uint8_t bNoOfBlocks,
    uint8_t * pCDIDOut, uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_FastInventoryRead(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bBlockNo, uint8_t bNoOfBlocks, uint8_t * pUid, uint8_t * pUidLen,
    uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_FastInventoryReadExtended(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bExtendedOptions, uint8_t * pCID, uint8_t bBlockNo, uint8_t bNoOfBlocks,
    uint8_t * pCDIDOut, uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_SetEAS(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sam_NonX_ResetEAS(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sam_NonX_LockEAS(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sam_NonX_EASAlarm(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pEasIdValue,
    uint8_t bEasIdMaskLen, uint8_t ** ppEas, uint16_t * pEasLen);

phStatus_t phalICode_Sam_NonX_PasswordProtectEAS(phalICode_SamAV3_NonX_DataParams_t * pDataParams);

phStatus_t phalICode_Sam_NonX_PasswordProtectAFI(phalICode_SamAV3_NonX_DataParams_t * pDataParams);

phStatus_t phalICode_Sam_NonX_WriteEAS_ID(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pEasIdValue);

phStatus_t phalICode_Sam_NonX_ReadEPC(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t ** ppEpc, uint16_t * pEpcLen);

phStatus_t phalICode_Sam_NonX_GetNXPSystemInformation(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t ** ppSystemInfo,
    uint16_t * pSystemInfoLen);

phStatus_t phalICode_Sam_NonX_InventoryPageRead(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bPageNo, uint8_t bNoOfPages, uint8_t ** ppUid, uint8_t * pUidLen,
    uint8_t ** ppData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_FastInventoryPageRead(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bPageNo, uint8_t bNoOfPages, uint8_t ** ppUid, uint8_t * pUidLen, uint8_t ** ppData,
    uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_GetRandomNumber(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t ** ppRnd, uint16_t * pRndLen);

phStatus_t phalICode_Sam_NonX_SetPassword(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bPwdIdentifier,
    uint8_t * pXorPwd);

phStatus_t phalICode_Sam_NonX_WritePassword(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bPwdIdentifier,
    uint8_t * pPwd);

phStatus_t phalICode_Sam_NonX_LockPassword(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bPwdIdentifier);

phStatus_t phalICode_Sam_NonX_ProtectPage(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bPPAdd_PageNo,
    uint8_t bProtectionStatus);

phStatus_t phalICode_Sam_NonX_LockPageProtectionCondition(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption,
    uint8_t bPageNo);

phStatus_t phalICode_Sam_NonX_GetMultipleBlockProtectionStatus(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bBlockNo,
    uint8_t bNoOfBlocks, uint8_t * pProtectionStates, uint16_t * pNumReceivedStates);

phStatus_t phalICode_Sam_NonX_Destroy(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pXorPwd);

phStatus_t phalICode_Sam_NonX_EnablePrivacy(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pXorPwd);

phStatus_t phalICode_Sam_NonX_64BitPasswordProtection(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sam_NonX_StayQuietPersistent(phalICode_SamAV3_NonX_DataParams_t * pDataParams);

phStatus_t phalICode_Sam_NonX_ReadSignature(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t ** ppSign, uint16_t * pSignLen);

phStatus_t phalICode_Sam_NonX_ReadConfig(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockAddr,
    uint8_t bNoOfBlocks, uint8_t ** ppData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_WriteConfig(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockAddr,
    uint8_t * pData);

phStatus_t phalICode_Sam_NonX_PickRandomID(phalICode_SamAV3_NonX_DataParams_t * pDataParams);

phStatus_t phalICode_Sam_NonX_ReadTT(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t ** ppResponse,
    uint16_t * pRspLen);

phStatus_t phalICode_Sam_NonX_ParameterRequest(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t * pBitRate, uint8_t * pTiming);

phStatus_t phalICode_Sam_NonX_ParameterSelect(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bBitRate, uint8_t bTiming);

phStatus_t phalICode_Sam_NonX_ReadSRAM(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockNo,
    uint8_t bNumBlocks, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sam_NonX_WriteSRAM(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockNo,
    uint8_t bNumBlocks, uint8_t * pData, uint16_t wDataLen);

phStatus_t phalICode_Sam_NonX_I2CMRead (phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bI2CParam, uint16_t wDataLen,
    uint8_t * pData);

phStatus_t phalICode_Sam_NonX_I2CMWrite (phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bI2CParam, uint8_t * pData,
    uint16_t wDataLen);

#ifdef NXPBUILD__PHAL_ICODE_INTERNAL
phStatus_t phalICode_Sam_NonX_IncrCnt(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bCounter, uint16_t wValue);

phStatus_t phalICode_Sam_NonX_ReadCnt(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bCounter, uint16_t * pValue);

phStatus_t phalICode_Sam_NonX_WriteCnt(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bCounter, uint16_t wValue);

phStatus_t phalICode_Sam_NonX_LockCertificate(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bOption, uint8_t bCertNo);

phStatus_t phalICode_Sam_NonX_FastReadCertificate(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t bCertNo, uint16_t wWordPtr,
    uint16_t wWordCount, uint8_t ** ppCertificate, uint16_t *pCertLen);

phStatus_t phalICode_Sam_NonX_FastReadBuffer(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t ** ppResponse, uint16_t * pRespLen);
#endif /* NXPBUILD__PHAL_ICODE_INTERNAL */





/* iCode Utility commands ------------------------------------------------------------------------------------------ */
phStatus_t phalICode_Sam_NonX_GetSerialNo(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t ** ppUid, uint16_t * pUidLen);

phStatus_t phalICode_Sam_NonX_SetSerialNo(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint8_t * pUid, uint8_t bUidLen);

phStatus_t phalICode_Sam_NonX_GetConfig(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalICode_Sam_NonX_SetConfig(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phalICode_Sam_NonX_GetTagType(phalICode_SamAV3_NonX_DataParams_t * pDataParams, uint16_t * pTagType);

#endif /* NXPBUILD__PHAL_ICODE_SAM_NONX */
#endif /* PHALICODE_SAM_NONX_H */
