/*
 * Copyright 2021 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software implementation of MIFARE DUOX application layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7464 $
 * $Date: 2025-08-29 16:56:35 +0530 (Fri, 29 Aug 2025) $
 *
 * History:
 *  Rajendran Kumar: Generated 14. Sep 2021
 *
 */

#ifndef PHALMFDUOX_SW_H
#define PHALMFDUOX_SW_H

#include <ph_Status.h>

#ifdef NXPBUILD__PHAL_MFDUOX_SW

#ifdef NXPBUILD__PHAL_MFDUOX_NDA
/* MIFARE DUOX Authentication commands -------------------------------------------------------------------------------------------------- */
phStatus_t phalMfDuoX_Sw_ISOGeneralAuthenticate(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bCARootKeyNo,
    uint16_t wKeyNo_PrivA, uint16_t wKeyPos_PrivA, uint8_t * pOptsA, uint8_t bOptsALen, uint8_t * pCertA, uint16_t wCertALen,
    uint8_t * pExpRspLen, uint8_t bExpRspLen, uint8_t * pE_PubB, uint16_t * pE_PubBLen, uint8_t ** ppResponse, uint16_t * pRspLen);
#endif /* NXPBUILD__PHAL_MFDUOX_NDA */

phStatus_t phalMfDuoX_Sw_ISOInternalAuthenticate(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bPrivKeyNo, uint8_t bCurveID,
    uint8_t * pPubBKey, uint16_t wPubBKeyLen, uint8_t * pOptsA, uint8_t bOptsALen, uint8_t * pExpRspLen, uint8_t bExpRspLen);

#ifdef NXPBUILD__PHAL_MFDUOX_NDA
phStatus_t phalMfDuoX_Sw_AuthenticateEv2(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bFirstAuth, uint16_t wOption, uint16_t wKeyNo,
    uint16_t wKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivLen, uint8_t * pPcdCapsIn, uint8_t bLenPcdCapsIn,
    uint8_t * pPcdCapsOut, uint8_t * pPdCapsOut);
#endif /* NXPBUILD__PHAL_MFDUOX_NDA */





/* MIFARE DUOX Memory and Configuration management commands ----------------------------------------------------------------------------- */
phStatus_t phalMfDuoX_Sw_FreeMem(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t ** ppMemInfo, uint16_t * pMemInfoLen);

#ifdef NXPBUILD__PHAL_MFDUOX_NDA
phStatus_t phalMfDuoX_Sw_Format(phalMfDuoX_Sw_DataParams_t * pDataParams);

phStatus_t phalMfDuoX_Sw_SetConfiguration(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pData,
    uint8_t bDataLen);

phStatus_t phalMfDuoX_Sw_GetConfiguration(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bExchangeOption,
    uint8_t ** ppData, uint16_t * pDataLen);
#endif /* NXPBUILD__PHAL_MFDUOX_NDA */

phStatus_t phalMfDuoX_Sw_GetVersion(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t ** ppVerInfo,
    uint16_t * pVerInfoLen);

#ifdef NXPBUILD__PHAL_MFDUOX_NDA
phStatus_t phalMfDuoX_Sw_GetCardUID(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t ** ppUid, uint16_t * pUidLen);
#endif /* NXPBUILD__PHAL_MFDUOX_NDA */





/* MIFARE DUOX Symmetric Key management commands ---------------------------------------------------------------------------------------- */
#ifdef NXPBUILD__PHAL_MFDUOX_NDA
phStatus_t phalMfDuoX_Sw_ChangeKey(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wOption, uint16_t wCurrKeyNo,
    uint16_t wCurrKeyVer, uint16_t wNewKeyNo, uint16_t wNewKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput,
    uint8_t bDivLen);

phStatus_t phalMfDuoX_Sw_ChangeKeyEv2(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wOption, uint16_t wCurrKeyNo,
    uint16_t wCurrKeyVer, uint16_t wNewKeyNo, uint16_t wNewKeyVer, uint8_t bKeySetNo, uint8_t bKeyNoCard,
    uint8_t * pDivInput, uint8_t bDivLen);

phStatus_t phalMfDuoX_Sw_InitializeKeySet(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bKeySetNo, uint8_t bKeyType);

phStatus_t phalMfDuoX_Sw_FinalizeKeySet(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bKeySetNo, uint8_t bKeySetVersion);

phStatus_t phalMfDuoX_Sw_RollKeySet(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bKeySetNo);
#endif /* NXPBUILD__PHAL_MFDUOX_NDA */

phStatus_t phalMfDuoX_Sw_GetKeySettings(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t ** ppResponse,
    uint16_t * pRspLen);

#ifdef NXPBUILD__PHAL_MFDUOX_NDA
phStatus_t phalMfDuoX_Sw_ChangeKeySettings(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bKeySettings);

phStatus_t phalMfDuoX_Sw_GetKeyVersion(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bKeyNo, uint8_t bKeySetNo,
    uint8_t ** ppResponse, uint16_t * pRspLen);
#endif /* NXPBUILD__PHAL_MFDUOX_NDA */





/* MIFARE DUOX ASymmetric Key management commands --------------------------------------------------------------------------------------- */
phStatus_t phalMfDuoX_Sw_ManageKeyPair(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bComOption, uint8_t bKeyNo,
    uint8_t bOption, uint8_t bCurveID, uint8_t * pKeyPolicy, uint8_t bWriteAccess, uint32_t dwKUCLimit,
    uint16_t wPrivKey_No, uint16_t wPrivKey_Pos, uint8_t ** ppResponse, uint16_t *pRspLen);

phStatus_t phalMfDuoX_Sw_ManageCARootKey(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bComOption, uint8_t bKeyNo,
    uint8_t bCurveID, uint8_t * pAccessRights, uint8_t bWriteAccess, uint8_t bReadAccess, uint8_t bCRLFile,
    uint8_t * pCRLFileAID, uint16_t wPubKey_No, uint16_t wPubKey_Pos, uint8_t * pIssuer, uint8_t bIssuerLen);

phStatus_t phalMfDuoX_Sw_ExportKey(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bComOption, uint8_t bOption,
    uint8_t bKeyNo, uint8_t ** ppResponse, uint16_t *pRspLen);





/* MIFARE DUOX Application management commands ------------------------------------------------------------------------------------------ */
phStatus_t phalMfDuoX_Sw_CreateApplication(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pAid,
    uint8_t bKeySettings1, uint8_t bKeySettings2, uint8_t bKeySettings3, uint8_t * pKeySetValues, uint8_t bKeySetValuesLen,
    uint8_t * pISOFileId, uint8_t * pISODFName, uint8_t bISODFNameLen);

phStatus_t phalMfDuoX_Sw_DeleteApplication(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t * pAid, uint8_t * pDAMMAC,
    uint8_t bDAMMAC_Len);

#ifdef NXPBUILD__PHAL_MFDUOX_NDA
phStatus_t phalMfDuoX_Sw_CreateDelegatedApplication(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pAid,
    uint8_t * pDamParams, uint8_t bDamParamsLen, uint8_t bKeySettings1, uint8_t bKeySettings2, uint8_t bKeySettings3,
    uint8_t * pKeySetValues, uint8_t bKeySetValuesLen, uint8_t * pISOFileId, uint8_t * pISODFName, uint8_t bISODFNameLen,
    uint8_t * pEncK, uint8_t bEncKLen, uint8_t * pDAMMAC, uint8_t bDAMMACLen, uint8_t * pInitK, uint8_t bInitKLen);
#endif /* NXPBUILD__PHAL_MFDUOX_NDA */

phStatus_t phalMfDuoX_Sw_SelectApplication(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pAppId,
    uint8_t * pAppId2);

phStatus_t phalMfDuoX_Sw_GetApplicationIDs(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t ** ppAidBuff,
    uint16_t * pAidLen);

phStatus_t phalMfDuoX_Sw_GetDFNames(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t ** ppDFBuffer,
    uint16_t * pDFInfoLen);

#ifdef NXPBUILD__PHAL_MFDUOX_NDA
phStatus_t phalMfDuoX_Sw_GetDelegatedInfo(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t * pDAMSlot, uint8_t * pDamSlotVer,
    uint8_t * pQuotaLimit, uint8_t * pFreeBlocks, uint8_t * pAid);
#endif /* NXPBUILD__PHAL_MFDUOX_NDA */




/* MIFARE DUOX File management commands ------------------------------------------------------------------------------------------------- */
phStatus_t phalMfDuoX_Sw_CreateStdDataFile(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo,
    uint8_t * pISOFileId, uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pFileSize);

phStatus_t phalMfDuoX_Sw_CreateBackupDataFile(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo,
    uint8_t * pISOFileId, uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pFileSize);

phStatus_t phalMfDuoX_Sw_CreateValueFile(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bFileNo, uint8_t bFileOption,
    uint8_t * pAccessRights, uint8_t * pLowerLmit, uint8_t * pUpperLmit, uint8_t * pValue, uint8_t bLimitedCredit);

phStatus_t phalMfDuoX_Sw_CreateLinearRecordFile(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo,
    uint8_t * pISOFileId, uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pRecordSize, uint8_t * pMaxNoOfRec);

phStatus_t phalMfDuoX_Sw_CreateCyclicRecordFile(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo,
    uint8_t * pISOFileId, uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pRecordSize, uint8_t * pMaxNoOfRec);

#ifdef NXPBUILD__PHAL_MFDUOX_NDA
phStatus_t phalMfDuoX_Sw_CreateTransactionMacFile(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bFileNo,
    uint8_t bFileOption, uint8_t * pAccessRights, uint8_t bTMKeyOption, uint8_t * pTMKey, uint8_t bTMKeyVer,
    uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pTMIExclFileMap, uint8_t bTSIGKeyNo);
#endif /* NXPBUILD__PHAL_MFDUOX_NDA */

phStatus_t phalMfDuoX_Sw_DeleteFile(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bFileNo);

phStatus_t phalMfDuoX_Sw_GetFileIDs(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t ** ppFileId, uint16_t * pFileIdLen);

phStatus_t phalMfDuoX_Sw_GetISOFileIDs(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t ** ppISOFileId, uint16_t * pISOFileIdLen);

phStatus_t phalMfDuoX_Sw_GetFileSettings(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bFileNo, uint8_t ** ppFSBuffer,
    uint16_t * pFSBufLen);

phStatus_t phalMfDuoX_Sw_GetFileCounters(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo,
    uint8_t ** ppFileCounters, uint16_t * pFileCounterLen);

phStatus_t phalMfDuoX_Sw_ChangeFileSettings(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo,
    uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pAddInfo, uint8_t bAddInfoLen);





/* MIFARE DUOX Data management commands ------------------------------------------------------------------------------------------------- */
phStatus_t phalMfDuoX_Sw_ReadData(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo,
    uint8_t * pOffset, uint8_t * pLength, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalMfDuoX_Sw_WriteData(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo,
    uint16_t wCRLVer, uint8_t * pOffset, uint8_t * pData, uint8_t * pLength);

phStatus_t phalMfDuoX_Sw_GetValue(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t ** ppValue,
    uint16_t * pValueLen);

phStatus_t phalMfDuoX_Sw_Credit(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pData);

phStatus_t phalMfDuoX_Sw_Debit(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pData);

phStatus_t phalMfDuoX_Sw_LimitedCredit(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pData);

phStatus_t phalMfDuoX_Sw_ReadRecords(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo,
    uint8_t * pRecNo, uint8_t * pRecCount, uint8_t * pRecSize, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalMfDuoX_Sw_WriteRecord(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo,
    uint8_t * pOffset, uint8_t * pData, uint8_t * pLength);

phStatus_t phalMfDuoX_Sw_UpdateRecord(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo,
    uint8_t * pRecNo, uint8_t * pOffset, uint8_t * pData, uint8_t * pLength);

phStatus_t phalMfDuoX_Sw_ClearRecordFile(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bFileNo);





/* MIFARE DUOX Transaction Management commands ------------------------------------------------------------------------------------------ */
phStatus_t phalMfDuoX_Sw_CommitTransaction(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t ** ppTMC,
    uint16_t * pTMCLen, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalMfDuoX_Sw_AbortTransaction(phalMfDuoX_Sw_DataParams_t * pDataParams);

phStatus_t phalMfDuoX_Sw_CommitReaderID(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t * pTMRI, uint8_t bTMRILen,
    uint8_t ** ppEncTMRI, uint16_t * pEncTMRILen);





/* MIFARE DUOX Cryptographic support commands ------------------------------------------------------------------------------------------- */
phStatus_t phalMfDuoX_Sw_CryptoRequest(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bComOption, uint8_t bAction,
    uint8_t * pInputData, uint16_t wInputLen, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalMfDuoX_Sw_CryptoRequestECCSign(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bComOption, uint8_t bOperation,
    uint8_t bAlgo, uint8_t bKeyNo, uint8_t bInputSource, uint8_t * pInputData, uint8_t bInputLen, uint8_t ** ppSign,
    uint16_t * pSignLen);

phStatus_t phalMfDuoX_Sw_CryptoRequestEcho(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bComOption, uint8_t * pInputData,
    uint8_t bInputLen, uint8_t ** ppResponse, uint16_t * pRspLen);





/* MIFARE DUOX GPIO Management commands ------------------------------------------------------------------------------------------------- */
phStatus_t phalMfDuoX_Sw_ManageGPIO(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bGPIONo, uint8_t bOperation,
    uint8_t * pNFCPauseRspData, uint16_t wNFCPauseRspDataLen, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalMfDuoX_Sw_ReadGPIO(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t ** ppResponse,
    uint16_t * pRspLen);





/* MIFARE DUOX ISO7816-4 commands ------------------------------------------------------------------------------------------------------- */
phStatus_t phalMfDuoX_Sw_IsoSelectFile(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bSelector, uint8_t * pFid,
    uint8_t * pDFname, uint8_t bDFnameLen, uint8_t bExtendedLenApdu, uint8_t ** ppFCI, uint16_t * pFCILen);

phStatus_t phalMfDuoX_Sw_IsoReadBinary(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bOffset, uint8_t bSfid,
    uint32_t dwBytesToRead, uint8_t bExtendedLenApdu, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalMfDuoX_Sw_IsoUpdateBinary(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOffset, uint8_t bSfid, uint8_t bExtendedLenApdu,
    uint8_t * pData, uint16_t wDataLen);

phStatus_t phalMfDuoX_Sw_IsoReadRecords(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bRecNo, uint8_t bReadAllRecords,
    uint8_t bSfid, uint32_t dwBytesToRead, uint8_t bExtendedLenApdu, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalMfDuoX_Sw_IsoAppendRecord(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bSfid, uint8_t bExtendedLenApdu, uint8_t * pData,
    uint16_t wDataLen);

phStatus_t phalMfDuoX_Sw_IsoGetChallenge(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bExpRsp, uint8_t bExtendedLenApdu,
    uint8_t ** ppResponse, uint16_t * pRspLen);





/* MIFARE DUOX EV Charging command ------------------------------------------------------------------------------------------------------ */
phStatus_t phalMfDuoX_Sw_VdeReadData(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bFileNo, uint16_t wBytesToRead,
    uint8_t bExtendedLenApdu, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalMfDuoX_Sw_VdeWriteData(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOperation, uint8_t bExtendedLenApdu,
    uint8_t * pData, uint16_t wDataLen);

phStatus_t phalMfDuoX_Sw_VdeECDSASign(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wBytesToRead, uint8_t bExtendedLenApdu,
    uint8_t * pData, uint16_t wDataLen, uint8_t ** ppResponse, uint16_t * pRspLen);





#ifdef NXPBUILD__PHAL_MFDUOX_NDA
/* MIFARE DUOX Post-DeliveryConfiguration command --------------------------------------------------------------------------------------- */
phStatus_t phalMfDuoX_Sw_AuthenticatePDC(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wKeyNoCard, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t bUpgradeInfo);
#endif /* NXPBUILD__PHAL_MFDUOX_NDA */





/* MIFARE DUOX Utility functions -------------------------------------------------------------------------------------------------------- */
phStatus_t phalMfDuoX_Sw_GetConfig(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalMfDuoX_Sw_SetConfig(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phalMfDuoX_Sw_ResetAuthentication(phalMfDuoX_Sw_DataParams_t * pDataParams);

#ifdef NXPBUILD__PHAL_MFDUOX_NDA
phStatus_t phalMfDuoX_Sw_ISOGeneralAuthenticateVerify(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t * pPubBKey, uint16_t wPubBKeyLen,
    uint8_t * pOptsB, uint8_t bOptsBLen, uint8_t * pE_PubBKey, uint16_t wE_PubBKeyLen, uint8_t * pSignature, uint16_t wSignLen);

phStatus_t phalMfDuoX_Sw_GenerateDAMEncKey(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wKeyNo_PICCDAMEncKey,
    uint16_t wKeyVer_PICCDAMEncKey, uint16_t wKeyNo_AppDAMDefault, uint16_t wKeyVer_AppDAMDefault, uint8_t bAppDAMDefaultKeyVer,
    uint8_t ** ppDAMEncKey, uint16_t * pDAMEncKeyLen);

phStatus_t phalMfDuoX_Sw_GenerateDAMMAC(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bOption, uint16_t wKeyNo_PICCDAMMAC,
    uint16_t wKeyVer_PICCDAMMAC, uint8_t * pAid, uint8_t * pDamParams, uint8_t bDamParamsLen, uint8_t bKeySettings1,
    uint8_t bKeySettings2, uint8_t bKeySettings3, uint8_t * pKeySetValues, uint8_t bKeySetValuesLen, uint8_t * pISOFileId,
    uint8_t * pISODFName, uint8_t bISODFNameLen, uint8_t * pEncK, uint8_t bEncKLen, uint8_t ** ppDAMMAC, uint16_t * pDAMMACLen);

phStatus_t phalMfDuoX_Sw_GenerateDAMMACSetConfig(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wKeyNo_PICCDAMMAC,
    uint16_t wKeyVer_PICCDAMMAC, uint8_t * pOld_ISODFName, uint8_t bOld_DFNameLen, uint8_t * pNew_ISODFName, uint8_t bNew_DFNameLen,
    uint8_t ** ppDAMMAC, uint16_t * pDAMMACLen);

phStatus_t phalMfDuoX_Sw_CalculateTMV(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wOption, uint16_t wKeyNoTMACKey,
    uint16_t wKeyVerTMACKey, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen,
    uint8_t * pTMI, uint16_t wTMILen, uint8_t ** ppTMV, uint16_t * pTMVLen);

phStatus_t phalMfDuoX_Sw_VerifyTransationSignature(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bCurveID, uint8_t * pPubKey,
    uint16_t wPubKey_Len, uint8_t * pTMI, uint16_t wTMILen, uint8_t * pTMC, uint8_t * pTSV, uint16_t wTSVLen);

phStatus_t phalMfDuoX_Sw_DecryptReaderID(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wOption, uint16_t wKeyNo_TMACKey,
    uint16_t wKeyVer_TMACKey, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen,
    uint8_t * pEncTMRI, uint8_t bEncTMRILen, uint8_t ** ppTMRIPrev, uint16_t * pTMRIPrevLen);

phStatus_t phalMfDuoX_Sw_CalculateMACSDM(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bSdmOption, uint16_t wKeyNo_SDMMac,
    uint16_t wKeyVer_SDMMac, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr, uint8_t * pInData, uint16_t wInDataLen,
    uint8_t ** ppSDMMAC, uint16_t * pSDMMACLen);

phStatus_t phalMfDuoX_Sw_VerifySDMSignature(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wPubKeyNo_SDMSig,
    uint16_t wPubKeyPos_SDMSig, uint8_t * pInData, uint16_t wInDataLen, uint8_t * pSignature, uint16_t wSigLen);

phStatus_t phalMfDuoX_Sw_DecryptSDMENCFileData(phalMfDuoX_Sw_DataParams_t * pDataParams, uint8_t bSdmOption,
    uint16_t wKeyNo_SDMEnc, uint16_t wKeyVer_SDMEnc, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr,
    uint8_t * pEncData, uint16_t wEncDataLen, uint8_t ** ppPlainData, uint16_t * pPlainDataLen);

phStatus_t phalMfDuoX_Sw_DecryptSDMPICCData(phalMfDuoX_Sw_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t * pEncData, uint16_t wEncDataLen, uint8_t ** ppPlainData, uint16_t * pPlainDataLen);
#endif /* NXPBUILD__PHAL_MFDUOX_NDA */

#endif /* NXPBUILD__PHAL_MFDUOX_SW */

#endif /* PHALMFDUOX_SW_H */
