/*
*         Copyright (c), NXP Semiconductors Bangalore / India
*
*                     (C)NXP Semiconductors
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
* particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

#ifndef PHALMFIDENTITY_SAM_X_INT_H
#define PHALMFIDENTITY_SAM_X_INT_H

#include <phalMfIdentity.h>

#define PHAL_MFIDENTITY_SAM_DATA_FRAME_LENGTH						224		/* Maximum data that can be exchanged in case of secure messaging computation by SAM. */
#define PHAL_MFIDENTITY_RESET_AUTH_OFF		0x00	/* Do not reset the internal parameters and Kill the PICC authentication */
#define PHAL_MFIDENTITY_RESET_AUTH_ON		0x01	/* Reset the internal parameters and Kill the PICC authentication */
#define PHAL_MFIDENTITY_MAX_WRITE_LEN		124	/* The default frame size is 64 bytes. So if the Write related commands need to transmitted to the PICC via SAM,
												 * the command including the data to be written and excluding PICC header comes to 124 bytes.
												 */


#define PHAL_MFIDENTITY_SAM_X_SESSION_ENC					0x01	/**< Optionto perform generate the TMAC / SDM session encryption keys. */
#define PHAL_MFIDENTITY_SAM_X_SESSION_MAC					0x02	/**< Optionto perform generate the TMAC / SDM session MAC keys. */

/* Resolves the component to be used. */
#define PHAL_MFIDENTITY_RESOLVE_DATAPARAMS(DataParams)	((phalMfIdentity_SamAV3_X_DataParams_t *) DataParams)

/* Resolves the Hal component to be used for communicating with Sam hardware in X mode. */
#define PHAL_MFIDENTITY_RESOLVE_HAL_DATAPARAMS(DataParams)																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFIDENTITY_SAMAV3_X_ID) ? ((phalMfIdentity_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams :	\
			NULL

phStatus_t phalMfIdentity_Sam_X_Int_ValidateResponse(void * pDataParams, uint8_t bResetAuth, uint16_t wStatus, uint8_t * pPiccRetCode);

phStatus_t phalMfIdentity_Sam_X_Int_Iso7816Wrap(uint8_t bFirstFrame, uint8_t bLengthPresent, uint8_t bLengthLen, uint8_t bLePresent, uint32_t dwTotDataLen, 
	uint8_t * pPlainData, uint16_t * pDataLen);

phStatus_t phalMfIdentity_Sam_X_Int_ResetAuthentication(void * pDataParams);

phStatus_t phalMfIdentity_Sam_X_Int_ComputeTMACSessionVectors(void * pDataParams, uint8_t bOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo, 
	uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen);

phStatus_t phalMfIdentity_Sam_X_Int_ComputeSDMSessionVectors(void * pDataParams, uint8_t bOption, uint8_t bSdmOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, 
	uint16_t wDstKeyNo, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr);

phStatus_t phalMfIdentity_Sam_X_Int_LoadSDMInitVector(void * pDataParams, uint8_t * pSDMReadCtr);

#endif /* PHALMFDFLIGHT_SAM_X_INT_H */
