/*
* Copyright (c), NXP Semiconductors Bangalore / India
*
* (C)NXP Semiconductors
* All rights are reserved. Reproduction in whole or in part is
* prohibited without the written consent of the copyright owner.
* NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
* particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
* arising from its use.
*/

#ifndef PHALMFIDENTITY_SW_H
#define PHALMFIDENTITY_SW_H

#ifdef NXPBUILD__PH_CRYPTOSYM
/* MIFARE Identity Secure Messaging commands. ------------------------------------------------------------------------------------------ */
phStatus_t phalMfIdentity_Sw_AuthenticateEv2(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bFirstAuth, uint16_t wOption, uint16_t wKeyNo,
	uint16_t wKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivLen, uint8_t bLenPcdCapsIn, uint8_t *pPcdCapsIn, uint8_t *pPcdCapsOut,
	uint8_t *pPdCapsOut);
#endif /* NXPBUILD__PH_CRYPTOSYM */




/* MIFARE Identity Memory and Configuration commands. ---------------------------------------------------------------------------------- */
#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalMfIdentity_Sw_SetConfiguration(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen);
#endif /* NXPBUILD__PH_CRYPTOSYM */

phStatus_t phalMfIdentity_Sw_GetVersion(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t * pVerInfo, uint8_t * pVerLength);

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalMfIdentity_Sw_GetCardUID(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t * pUid, uint8_t * pUidLength);
#endif /* NXPBUILD__PH_CRYPTOSYM */




#ifdef NXPBUILD__PH_CRYPTOSYM
/* MIFARE Identity Key Management commands. -------------------------------------------------------------------------------------------- */
phStatus_t phalMfIdentity_Sw_ChangeKey(phalMfIdentity_Sw_DataParams_t * pDataParams, uint16_t wOption, uint16_t wOldKeyNo, uint16_t wOldKeyVer,
	uint16_t wNewKeyNo, uint16_t wNewKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivLen);

phStatus_t phalMfIdentity_Sw_GetKeyVersion(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bKeyNo, uint8_t bKeySetNo, uint8_t * pKeyVersion,
	uint8_t * bRxLen);
#endif /* NXPBUILD__PH_CRYPTOSYM */




/* MIFARE Identity File Management commands. ------------------------------------------------------------------------------------------- */
#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalMfIdentity_Sw_CreateTransactionMacFile(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bFileNo, uint8_t bCommMode,
	uint8_t * pAccessRights, uint8_t bKeyType, uint8_t * bTMKey, uint8_t bTMKeyVer);
#endif /* NXPBUILD__PH_CRYPTOSYM */

phStatus_t phalMfIdentity_Sw_DeleteFile(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bFileNo);

phStatus_t phalMfIdentity_Sw_GetFileSettings(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bFileNo, uint8_t * pFSBuffer, uint8_t * bBufferLen);

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalMfIdentity_Sw_GetFileCounters(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pFileCounters,
	uint8_t * pRxLen);

phStatus_t phalMfIdentity_Sw_ChangeFileSettings(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bCommMode, uint8_t bFileNo, uint8_t bFileOption,
	uint8_t * pAccessRights, uint8_t bAdditionalInfoLen, uint8_t * bAdditionalInfo);

phStatus_t phalMfIdentity_Sw_ChangeFileSettingsSDM(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption,
	uint8_t *pAccessRights, uint8_t bSdmOptions, uint8_t *pSdmAccessRights, uint8_t *pPICCDataOffset, uint8_t *pSDMMACInputOffset, uint8_t *pSDMENCOffset,
	uint8_t *pSDMENCLen, uint8_t *pSDMMACOffset, uint8_t *pSDMReadCtrOffset, uint8_t *pTMCLimitValue);
#endif /* NXPBUILD__PH_CRYPTOSYM */




/* MIFARE Identity Data Management commands. ------------------------------------------------------------------------------------------- */
phStatus_t phalMfIdentity_Sw_ReadData(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo,
	uint8_t * pOffset, uint8_t * pLength, uint8_t ** ppRxdata, uint16_t * pRxdataLen);

phStatus_t phalMfIdentity_Sw_WriteData(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bCommOption, uint8_t bIns, uint8_t bFileNo,
	uint8_t * pOffset, uint8_t * pTxData, uint8_t * pTxDataLen);

phStatus_t phalMfIdentity_Sw_ReadRecords(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bCommOption, uint8_t bIns, uint8_t bFileNo,
	uint8_t * pRecNo, uint8_t * pRecCount, uint8_t * pRecSize, uint8_t ** ppRxdata, uint16_t * pRxdataLen);

phStatus_t phalMfIdentity_Sw_WriteRecord(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bCommOption, uint8_t bIns, uint8_t bFileNo,
	uint8_t * pOffset, uint8_t * pData, uint8_t * pDataLen);

phStatus_t phalMfIdentity_Sw_ClearRecordFile(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bFileNo);




/* MIFARE Identity Transaction Management commands. ------------------------------------------------------------------------------------ */
phStatus_t phalMfIdentity_Sw_CommitTransaction(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pTMC, uint8_t * pTMAC);

phStatus_t phalMfIdentity_Sw_AbortTransaction(phalMfIdentity_Sw_DataParams_t * pDataParams);

phStatus_t phalMfIdentity_Sw_CommitReaderID(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t * pTMRI, uint8_t * pEncTMRI);




/* MIFARE Identity ISO7816-4 commands. ------------------------------------------------------------------------------------------------- */
phStatus_t phalMfIdentity_Sw_IsoSelectFile(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bSelector, uint8_t * pFid,
	uint8_t * pDFname, uint8_t bDFnameLen, uint8_t	bExtendedLenApdu, uint8_t ** ppFCI, uint16_t * pwFCILen);




/* MIFARE Identity OriginalityCheck commands. ------------------------------------------------------------------------------------------ */
phStatus_t phalMfIdentity_Sw_ReadSign(phalMfIdentity_Sw_DataParams_t * pDataParams, uint8_t bAddr, uint8_t ** pSignature);




/* MIFARE DESFire Light Miscellaneous commands. ---------------------------------------------------------------------------------------- */
phStatus_t phalMfIdentity_Sw_GetConfig(phalMfIdentity_Sw_DataParams_t * pDataParams, uint16_t wConfig, uint8_t * pValue);

phStatus_t phalMfIdentity_Sw_SetConfig(phalMfIdentity_Sw_DataParams_t *pDataParams, uint16_t wConfig, uint8_t * pValue);

phStatus_t phalMfIdentity_Sw_ResetAuthentication(phalMfIdentity_Sw_DataParams_t * pDataParams);

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalMfIdentity_Sw_CalculateTMV(phalMfIdentity_Sw_DataParams_t *pDataParams, uint16_t wOption, uint16_t wKeyNoTMACKey,
	uint16_t wKeyVerTMACKey, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen,
	uint8_t * pTMI, uint32_t dwTMILen, uint8_t * pTMV);

phStatus_t phalMfIdentity_Sw_DecryptReaderID(phalMfIdentity_Sw_DataParams_t *pDataParams, uint16_t wOption, uint16_t wKeyNoTMACKey,
	uint16_t wKeyVerTMACKey, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen,
	uint8_t * pEncTMRI, uint8_t * pTMRIPrev);

phStatus_t phalMfIdentity_Sw_CalculateMACSDM(phalMfIdentity_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bSdmOption,
	uint16_t wSDMMacKeyNo, uint16_t wSDMMacKeyVer, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pUid, uint8_t bUidLen,
	uint8_t * SDMReadCtr, uint8_t * pInData, uint16_t wInDataLen, uint8_t * pRespMac);

phStatus_t phalMfIdentity_Sw_DecryptSDMENCFileData(phalMfIdentity_Sw_DataParams_t * pDataParams, uint16_t wOption, uint16_t wEncKeyNo,
	uint16_t wEncKeyVer, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr,
	uint8_t * pEncdata, uint16_t wEncDataLen, uint8_t * pPlainData);

phStatus_t phalMfIdentity_Sw_DecryptSDMPICCData(phalMfIdentity_Sw_DataParams_t * pDataParams, uint16_t wOption, uint16_t wKeyNo,
	uint16_t wKeyVer, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pIndata, uint16_t wInDataLen, uint8_t * pPlainData);
#endif /* NXPBUILD__PH_CRYPTOSYM */

#endif /* PHALMFIDENTITY_SW_H */
