/*
*         Copyright (c), NXP Semiconductors Bangalore / India
*
*                     (C)NXP Semiconductors
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
*particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

/** \file
* Internal functions of Software implementation of MIFARE IDENTITY application layer.
* $Author: Rajendran Kumar (nxp99556) $
* $Revision: 7230 $
* $Date: 2025-03-14 10:27:23 +0530 (Fri, 14 Mar 2025) $
*/

#ifndef PHALMFIDENTITY_INT_H
#define PHALMFIDENTITY_INT_H

#include <ph_Status.h>
#include <phalMfIdentity.h>

/* MIFARE Desfire Native Commands */
#define PHAL_MFIDENTITY_CMD_ABORT_TXN                     								0xA7	/* MFIDENTITY Abort transaction cmd. */
#define PHAL_MFIDENTITY_CMD_AUTHENTICATE                  								0x0A	/* MFIDENTITY Authenticate command. */
#define PHAL_MFIDENTITY_CMD_AUTHENTICATE_EV2_FIRST        								0x71	/* MFIDENTITY Authenticate Ev2 First command. */
#define PHAL_MFIDENTITY_CMD_AUTHENTICATE_EV2_NON_FIRST    								0x77	/* MFIDENTITY Authenticate Ev2 Non First command. */
#define PHAL_MFIDENTITY_CMD_CHANGE_FILE_SETTINGS          								0x5F	/* MFIDENTITY Change file settings cmd. */
#define PHAL_MFIDENTITY_CMD_CHANGE_KEY                    								0xC4	/* MFIDENTITY Change key cmd. */
#define PHAL_MFIDENTITY_CMD_CLEAR_RECORD_FILE             								0xEB	/* MFIDENTITY Clear records file cmd. */
#define PHAL_MFIDENTITY_CMD_COMMIT_READER_ID              								0xC8	/* MFIDENTITY Commit Reader ID cmd. */
#define PHAL_MFIDENTITY_CMD_COMMIT_TXN                    								0xC7	/* MFIDENTITY Commit transaction cmd. */
#define PHAL_MFIDENTITY_CMD_CREATE_TRANSACTION_MACFILE    								0xCE	/* MFIDENTITY Create Transaction MAC file cmd. */
#define PHAL_MFIDENTITY_CMD_DELETE_FILE                   								0xDF	/* MFIDENTITY Delete File cmd. */
#define PHAL_MFIDENTITY_CMD_GET_CARD_UID                  								0x51	/* MFIDENTITY Get Card UID cmd. */
#define PHAL_MFIDENTITY_CMD_GET_FILE_SETTINGS             								0xF5	/* MFIDENTITY Get File settings cmd. */
#define PHAL_MFIDENTITY_CMD_GET_FILE_COUNTERS             								0xF6	/* MFIDENTITY Get File Counters cmd. */
#define PHAL_MFIDENTITY_CMD_GET_KEY_VERSION               								0x64	/* MFIDENTITY Get Key Version. */
#define PHAL_MFIDENTITY_CMD_GET_VERSION                   								0x60	/* MFIDENTITY Get Version cmd. */
#define PHAL_MFIDENTITY_CMD_READ_DATA                     								0xBD	/* MFIDENTITY Read Data cmd. */
#define PHAL_MFIDENTITY_CMD_READ_DATA_ISO                 								0xAD	/* MFIDENTITY Read Data cmd using ISO chaining. */
#define PHAL_MFIDENTITY_CMD_READ_RECORDS                  								0xBB	/* MFIDENTITY Read Records cmd. */
#define PHAL_MFIDENTITY_CMD_READ_RECORDS_ISO              								0xAB	/* MFIDENTITY Read Records cmd using ISO chaining. */
#define PHAL_MFIDENTITY_CMD_READ_SIG					  								0x3C	/* MFIDENTITY Read Signature command */
#define PHAL_MFIDENTITY_CMD_SET_CONFIG                    								0x5C	/* MFIDENTITY Set Configuration Cmd. */
#define PHAL_MFIDENTITY_CMD_WRITE_DATA                    								0x3D	/* MFIDENTITY Write data cmd. */
#define PHAL_MFIDENTITY_CMD_WRITE_DATA_ISO                								0x8D	/* MFIDENTITY Write data cmd using ISO chaining. */
#define PHAL_MFIDENTITY_CMD_WRITE_RECORD                  								0x3B	/* MFIDENTITY Write Record cmd. */
#define PHAL_MFIDENTITY_CMD_WRITE_RECORD_ISO              								0x8B	/* MFIDENTITY Write Record cmd using ISO chaining. */


/* MIFARE Desfire Response Codes */
#define PHAL_MFIDENTITY_RESP_OPERATION_OK                 								0x00U	/* MFIDENTITY Response - Successful operation. */
#define PHAL_MFIDENTITY_RESP_OK			                  								0x90U	/* MFIDENTITY Response - Successful operation. */
#define PHAL_MFIDENTITY_RESP_NO_CHANGES                   								0x0CU	/* MFIDENTITY Response - No changes done to backup files. */
#define PHAL_MFIDENTITY_RESP_ERR_OUT_OF_EEPROM_ERROR      								0x0EU	/* MFIDENTITY Response - Insufficient NV-Memory. */
#define PHAL_MFIDENTITY_RESP_ILLEGAL_COMMAND_CODE        								0x1CU	/* MFIDENTITY command code not supported. */
#define PHAL_MFIDENTITY_RESP_ERR_INTEGRITY_ERROR          								0x1EU	/* MFIDENTITY CRC or MAC does not match data padding bytes not valid. */
#define PHAL_MFIDENTITY_RESP_NO_SUCH_KEY                  								0x40U	/* MFIDENTITY Invalid key number specified. */
#define PHAL_MFIDENTITY_RESP_CHAINING                     								0x71U	/* MFIDENTITY ISO Chaining Status. */
#define PHAL_MFIDENTITY_RESP_ERR_LENGTH_ERROR             								0x7EU	/* MFIDENTITY Length of command string invalid. */
#define PHAL_MFIDENTITY_RESP_PERMISSION_DENIED            								0x9DU	/* MFIDENTITY Current configuration/status does not allow the requested command. */
#define PHAL_MFIDENTITY_RESP_ERR_PARAMETER_ERROR          								0x9EU	/* MFIDENTITY Value of params invalid. */
#define PHAL_MFIDENTITY_RESP_APPLICATION_NOT_FOUND        								0xA0U	/* MFIDENTITY Requested AID not found on PICC. */
#define PHAL_MFIDENTITY_RESP_ERR_APPL_INTEGRITY_ERROR     								0xA1U	/* MFIDENTITY Unrecoverable error within application, appln will be disabled. */
#define PHAL_MFIDENTITY_RESP_ERR_AUTHENTICATION_ERROR     								0xAEU	/* MFIDENTITY Current authentication status does not allow the requested cmd. */
#define PHAL_MFIDENTITY_RESP_ERR_AUTHENTICATION_DELAY     								0xADU	/* Keep Waiting till Delay is met. */
#define PHAL_MFIDENTITY_RESP_ADDITIONAL_FRAME             								0xAFU	/* MFIDENTITY Additional data frame is expected to be sent. */
#define PHAL_MFIDENTITY_RESP_ERR_BOUNDARY_ERROR           								0xBEU	/* MFIDENTITY Attempt to read/write data from/to beyond the files/record's limits. */
#define PHAL_MFIDENTITY_RESP_ERR_PICC_INTEGRITY           								0xC1U	/* MFIDENTITY Unrecoverable error within PICC. PICC will be disabled. */
#define PHAL_MFIDENTITY_RESP_ERR_COMMAND_ABORTED          								0xCAU	/* MFIDENTITY Previous cmd not fully completed. Not all frames were requested or provided by the PCD. */
#define PHAL_MFIDENTITY_RESP_ERR_PIC_DISABLED            								0xCDU	/* MFIDENTITY PICC was disabled by an unrecoverable error. */
#define PHAL_MFIDENTITY_RESP_ERR_COUNT                    								0xCEU	/* MFIDENTITY Num. of applns limited to 28. No additional applications possible. */
#define PHAL_MFIDENTITY_RESP_ERR_DUPLICATE                								0xDEU	/* MFIDENTITY File/Application with same number already exists. */
#define PHAL_MFIDENTITY_RESP_ERR_EEPROM                   								0xEEU	/* MFIDENTITY Could not complete NV-Write operation due to loss of power. */
#define PHAL_MFIDENTITY_RESP_ERR_FILE_NOT_FOUND           								0xF0U	/* MFIDENTITY Specified file number does not exist. */
#define PHAL_MFIDENTITY_RESP_ERR_FILE_INTEGRITY											0xF1U	/* MFIDENTITY Unrecoverable error within file. File will be disabled. */


/* ISO 7816 Instructions */
#define PHAL_MFIDENTITY_CMD_ISO7816_SELECT_FILE       									0xA4	/* ISO Select File. */


/* MIFARE Desfire specific defines */
#define PHAL_MFIDENTITY_MAXWRAPPEDAPDU_SIZE												0x37u	/* Maximum size of wrapped APDU 55 bytes. */
#define PHAL_MFIDENTITY_MAXDFAPDU_SIZE													0x3Cu	/* Maximum size of DESFire APDU 60 bytes. */
#define PHAL_MFIDENTITY_DFAPPID_SIZE          											0x03u	/* Size of MFIDENTITY application Id. */
#define PHAL_MFIDENTITY_DATA_BLOCK_SIZE       											0x10u	/* Data block size need for internal purposes. */
#define PHAL_MFIDENTITY_MAX_FRAME_SIZE        											0x40u	/* Max size in a ISO 14443-4 frame. */

/* ISO 7816 DFEV2 return Codes */
#define PHAL_MFIDENTITY_ISO7816_SUCCESS													0x9000U	/* Correct execution. */
#define PHAL_MFIDENTITY_ISO7816_ERR_WRONG_LENGTH										0x6700U	/* Wrong length. */
#define PHAL_MFIDENTITY_ISO7816_ERR_INVALID_APPLN										0x6A82U	/* Application / file not found. */
#define PHAL_MFIDENTITY_ISO7816_ERR_WRONG_PARAMS										0x6A86U	/* Wrong parameters P1 and/or P2. */
#define PHAL_MFIDENTITY_ISO7816_ERR_WRONG_LC											0x6A87U /* Lc inconsistent with P1/p2. */
#define PHAL_MFIDENTITY_ISO7816_ERR_WRONG_LE											0x6C00U /* Wrong Le. */
#define PHAL_MFIDENTITY_ISO7816_ERR_NO_PRECISE_DIAGNOSTICS								0x6F00U /* No precise diagnostics. */
#define PHAL_MFIDENTITY_ISO7816_ERR_EOF_REACHED											0x6282U /* End of File reached. */
#define PHAL_MFIDENTITY_ISO7816_ERR_LIMITED_FUNCTIONALITY_INS							0x6283U /* Limited Functionality. */
#define PHAL_MFIDENTITY_ISO7816_ERR_FILE_ACCESS											0x6982U	/* File access not allowed. */
#define PHAL_MFIDENTITY_ISO7816_ERR_FILE_EMPTY											0x6985U	/* File empty or access conditions not satisfied. */
#define PHAL_MFIDENTITY_ISO7816_ERR_FILE_NOT_FOUND										0x6A82U /* File not found. */
#define PHAL_MFIDENTITY_ISO7816_ERR_MEMORY_FAILURE										0x6581U /* Memory failure (unsuccessful update). */
#define PHAL_MFIDENTITY_ISO7816_ERR_INCORRECT_PARAMS									0x6B00U /* Wrong parameter p1 or p2. READ RECORDS. */
#define PHAL_MFIDENTITY_ISO7816_ERR_WRONG_CLA											0x6E00U /* Wrong Class byte. */
#define PHAL_MFIDENTITY_ISO7816_ERR_UNSUPPORTED_INS										0x6D00U /* Instruction not supported. */

#define PHAL_MFIDENTITY_WRAP_HDR_LEN													0x05U   /* Wrapped APDU header length */
#define PHAL_MFIDENTITY_WRAPPEDAPDU_CLA													0x90U   /* Wrapped APDU default class. */
#define PHAL_MFIDENTITY_WRAPPEDAPDU_P1													0x00U   /* Wrapped APDU default P1. */
#define PHAL_MFIDENTITY_WRAPPEDAPDU_P2													0x00U   /* Wrapped APDU default P2. */
#define PHAL_MFIDENTITY_WRAPPEDAPDU_LE													0x00U   /* Wrapped APDU default LE. */

#define PHAL_MFIDENTITY_TRUNCATED_MAC_SIZE												8		/* Size of the truncated MAC. */
#define PHAL_MFIDENTITY_KEYSETVERSIONS													0x40U	/* 6th bit KeyNo used to retrieve all keyset versions. */
#define PHAL_MFIDENTITY_ISO_CHAINING_MODE												0x04	/* Option to enable ISO chaining. */
#define PHAL_MFIDENTITY_DEFAULT_MODE													0x00	/* Native Chaining. */
#define PHAL_MFIDENTITY_PC_RND_LEN														7		/* Size of the Proximity Check Random numbers. */
#define PHAL_MFIDENTITY_SIG_LENGTH														0x38	/* NXP Originality Signature length */
#define PHAL_MFIDENTITY_DEFAULT_UID_LENGTH												0x07	/* By default EV2 card is configures as 7 byte UID */
#define PHAL_MFIDENTITY_10B_UID_LENGTH													0x09	/* EV2 can also be configured as 10 byte UID. */
#define PHAL_MFIDENTITY_4B_UID_LENGTH													0x06	/* EV2 can also be configured as 4 byte UID. */
#define PHAL_MFIDENTITY_SDM_FILE_CTR_LENGTH  											0x05	/* SDMReadCounter(3B) + reserved(2B) */
#define PHAL_MFIDENTITY_DEF_VERSION_LENGTH												0x1C	/* Version String is of 28 bytes by default(If its 7 Byte UID) */
#define PHAL_MFIDENTITY_VERSION_LENGTH_WITH_FABKEY_ID   								0x1D	/* Version String is of 29 bytes by default(If its 7 Byte UID) */
#define PHAL_MFIDENTITY_10B_VERSION_LENGTH												0x1E	/* Version String is of 30 bytes If its 10B Byte UID */
#define PHAL_MFIDENTITY_4B_VERSION_LENGTH												0x1B	/* Version String is of 27 bytes If its 4B Byte UID */
#define PHAL_MFIDENTITY_ISO_CHAINING_MODE_MAPPED	(PHAL_MFIDENTITY_ISO_CHAINING_MODE << 2)	/* Option to enable ISO chaining mapped for internal use. */

#define PHAL_MFIDENTITY_ISO_7816_NO_LC_LE												0x00	/* Check if Lc=0 and Le=0 */
#define PHAL_MFIDENTITY_ISO_7816_LC_SHORT_APDU											0x01	/* Indicates Lc=1 byte */
#define PHAL_MFIDENTITY_ISO_7816_LC_EXT_APDU_3B											0x03	/* Indicates Lc=3 bytes */
#define PHAL_MFIDENTITY_ISO_7816_LE_SHORT_APDU			PHAL_MFIDENTITY_ISO_7816_LC_SHORT_APDU	/* Indicates Le=1 byte */
#define PHAL_MFIDENTITY_ISO_7816_LE_EXT_APDU_2B											0x02	/* Indicates Le=2 bytes */
#define PHAL_MFIDENTITY_ISO_7816_LE_EXT_APDU_3B			PHAL_MFIDENTITY_ISO_7816_LC_EXT_APDU_3B	/* Indicates Le=3 bytes */

/* Proximity Check return Codes */
#define PHAL_MFIDENTITY_RESP_NACK0														0x00U	/* MFIDENTITY NACK 0 (in ISO14443-3 mode). */
#define PHAL_MFIDENTITY_RESP_NACK1														0x01U	/* MFIDENTITY NACK 1 (in ISO14443-3 mode). */
#define PHAL_MFIDENTITY_RESP_NACK4														0x04U	/* MFIDENTITY NACK 4 (in ISO14443-3 mode). */
#define PHAL_MFIDENTITY_RESP_NACK5														0x05U	/* MFIDENTITY NACK 5 (in ISO14443-3 mode). */
#define PHAL_MFIDENTITY_RESP_ACK_ISO3													0x0AU	/* MFIDENTITY ACK (in ISO14443-3 mode). */
#define PHAL_MFIDENTITY_RESP_ACK_ISO4													0x90U	/* MFIDENTITY ACK (in ISO14443-4 mode). */
#define PHAL_MFIDENTITY_RESP_ERR_AUTH													0x06U	/* MFIDENTITY Authentication Error. */
#define PHAL_MFIDENTITY_RESP_ERR_CMD_OVERFLOW											0x07U	/* MFIDENTITY Command Overflow Error. */
#define PHAL_MFIDENTITY_RESP_ERR_MAC_PCD												0x08U	/* MFIDENTITY MAC Error. */
#define PHAL_MFIDENTITY_RESP_ERR_BNR													0x09U	/* MFIDENTITY Blocknumber Error. */
#define PHAL_MFIDENTITY_RESP_ERR_EXT													0x0AU	/* MFIDENTITY Extension Error. */
#define PHAL_MFIDENTITY_RESP_ERR_CMD_INVALID											0x0BU	/* MFIDENTITY Invalid Command Error. */
#define PHAL_MFIDENTITY_RESP_ERR_FORMAT													0x0CU	/* MFIDENTITY Format Error. */
#define PHAL_MFIDENTITY_RESP_ERR_GEN_FAILURE											0x0FU	/* MFIDENTITY Generic Error. */

/* To avoid unused variable warnings. */
#define PHAL_MFIDENTITY_UNUSED_VARIABLE(x)  {for( ( x ) = ( x ) ; ( x ) != ( x ) ; );}
#define PHAL_MFIDENTITY_UNUSED_ARRAY(x)  {for( ( (x)[0] ) = ( (x)[0] ) ; ( (x)[0] ) != ( (x)[0] ) ; );}

#define PHAL_MFIDENTITY_SDM_FILE_ID														0x00	/* MFIdentity File Id where NDEF data is stored. */
#define PHAL_MFIDENTITY_STANDARD_FILE_ID												0x1F 	/* MFIdentity File Id standard data is stored. */
#define PHAL_MFIDENTITY_PLAIN_MIRRORING													0x0E 	/* Plain Mirroring. */
#define PHAL_MFIDENTITY_NO_SDM_FOR_READING												0x0F 	/* No SDM For Reading. */
#define PHAL_MFIDENTITY_METADATARANGE													0x04 	/* Plain Mirroring. */
#define PHAL_MFIDENTITY_PICC_DATA_EV2													0x10 	/* PICCDATA EV2. */
#define PHAL_MFIDENTITY_PICC_DATA_LRP													0x18 	/* PICCDATA LRP. */
#define PHAL_MFIDENTITY_MAC_DATA														0x08 	/* MAC DATA. */

phStatus_t phalMfIdentity_Int_ComputeErrorResponse(void * pDataParams, uint16_t wStatus);

phStatus_t phalMfIdentity_ExchangeCmd(void * pDataParams, void * pPalMifareDataParams, uint8_t bWrappedMode, uint8_t * pCmd,
	uint16_t wCmdLen, uint8_t ** ppResponse, uint16_t * wRxlen);

phStatus_t phalMfIdentity_Int_Send7816Apdu(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t bIns,
	uint8_t p1, uint8_t p2, uint32_t Lc, uint8_t bExtendedLenApdu, uint8_t * pDataIn, uint32_t bLe, uint8_t ** pDataOut,
	uint16_t *pDataLen);

phStatus_t phalMfIdentity_Int_ISOSelectFile(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t * bCmdBuff,
	uint16_t wCmdLen, uint8_t bLc, uint8_t bExtendedLenApdu, uint8_t * pDataIn, uint8_t bLe, uint8_t ** ppDataOut, uint16_t *pDataLen);

#endif /* PHALMFIDENTITY_INT_H */
