/*
 * Copyright 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/**
 * \file
 * Software MIFARE DESFire Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  SDA: Generated 23. April 2010
 *
 */

#ifndef PHALMFDF_SAM_X_H
#define PHALMFDF_SAM_X_H

#include <phCryptoSym.h>
#include <phalMfdf.h>

phStatus_t phalMfdf_Sam_X_Authenticate(void *pDataParams, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdf_Sam_X_AuthenticateISO(void *pDataParams, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdf_Sam_X_AuthenticateAES(void *pDataParams, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);




phStatus_t phalMfdf_Sam_X_FreeMem(void * pDataParams, uint8_t * pMemInfo);

phStatus_t phalMfdf_Sam_X_FormatPICC(void * pDataParams);

phStatus_t phalMfdf_Sam_X_SetConfiguration(void * pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalMfdf_Sam_X_GetVersion(void * pDataParams, uint8_t * pVerInfo);

phStatus_t phalMfdf_Sam_X_GetCardUID(void * pDataParams, uint8_t * pUid);




phStatus_t phalMfdf_Sam_X_ChangeKey(void * pDataParams, uint16_t wOption, uint16_t wOldKeyNo, uint16_t wOldKeyVer, uint16_t wNewKeyNo, uint16_t wNewKeyVer, uint8_t bKeyNoCard,
	uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdf_Sam_X_GetKeySettings(void * pDataParams, uint8_t * pKeySettings);

phStatus_t phalMfdf_Sam_X_ChangeKeySettings(void * pDataParams, uint8_t bKeySettings);

phStatus_t phalMfdf_Sam_X_GetKeyVersion(void * pDataParams, uint8_t bKeyNo, uint8_t * pKeyVersion);




phStatus_t phalMfdf_Sam_X_CreateApplication(void * pDataParams, uint8_t bOption, uint8_t * pAid, uint8_t bKeySettings1, uint8_t bKeySettings2, uint8_t * pISOFileId,
	uint8_t * pISODFName, uint8_t bISODFNameLen);

phStatus_t phalMfdf_Sam_X_DeleteApplication(void * pDataParams, uint8_t * pAid);

phStatus_t phalMfdf_Sam_X_SelectApplication(void * pDataParams, uint8_t * pAid);

phStatus_t phalMfdf_Sam_X_GetApplicationIDs(void * pDataParams, uint8_t * pAidBuff, uint8_t * pNumAid);

phStatus_t phalMfdf_Sam_X_GetDFNames(void * pDataParams, uint8_t bOption, uint8_t * pDFBuffer, uint8_t * bNumOfEntries);




phStatus_t phalMfdf_Sam_X_CreateStdDataFile(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pISOFileId, uint8_t bFileOption, uint8_t * pAccessRights,
	uint8_t * pFileSize);

phStatus_t phalMfdf_Sam_X_CreateBackupDataFile(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pISOFileId, uint8_t bFileOption, uint8_t * pAccessRights,
	uint8_t * pFileSize);

phStatus_t phalMfdf_Sam_X_CreateValueFile(void * pDataParams, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights, uint8_t * pLowerLmit, uint8_t * pUpperLmit,
	uint8_t * pValue, uint8_t bLimitedCredit);

phStatus_t phalMfdf_Sam_X_CreateLinearRecordFile(void * pDataParams, uint8_t bOption, uint8_t  bFileNo, uint8_t * pISOFileId, uint8_t bFileOption, uint8_t * pAccessRights,
	uint8_t * pRecordSize, uint8_t * pMaxNoOfRec);

phStatus_t phalMfdf_Sam_X_CreateCyclicRecordFile(void * pDataParams, uint8_t bOption, uint8_t  bFileNo, uint8_t * pISOFileId, uint8_t bFileOption, uint8_t * pAccessRights,
	uint8_t * pRecordSize, uint8_t * pMaxNoOfRec);

phStatus_t phalMfdf_Sam_X_DeleteFile(void * pDataParams, uint8_t bFileNo);

phStatus_t phalMfdf_Sam_X_GetFileIDs(void * pDataParams, uint8_t * pFid, uint8_t * bNumFid);

phStatus_t phalMfdf_Sam_X_GetISOFileIDs(void * pDataParams, uint8_t * pFidBuffer, uint8_t * bNumFid);

phStatus_t phalMfdf_Sam_X_GetFileSettings(void * pDataParams, uint8_t bFileNo, uint8_t * pFSBuffer, uint8_t * pBufferLen);

phStatus_t phalMfdf_Sam_X_ChangeFileSettings(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights);




phStatus_t phalMfdf_Sam_X_ReadData(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pLength, uint8_t ** ppResponse,
	uint16_t * pRespLen);

phStatus_t phalMfdf_Sam_X_WriteData(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pData, uint8_t * pDataLen);

phStatus_t phalMfdf_Sam_X_GetValue(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdf_Sam_X_Credit(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdf_Sam_X_Debit(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdf_Sam_X_LimitedCredit(void * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdf_Sam_X_ReadRecords(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pRecNo, uint8_t * pRecCount, uint8_t * pRecSize,
	uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalMfdf_Sam_X_WriteRecord(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pData, uint8_t * pDataLen);

phStatus_t phalMfdf_Sam_X_ClearRecordFile(void * pDataParams, uint8_t bFileNo);




phStatus_t phalMfdf_Sam_X_CommitTransaction(void * pDataParams);

phStatus_t phalMfdf_Sam_X_AbortTransaction(void * pDataParams);




phStatus_t phalMfdf_Sam_X_IsoSelectFile(void * pDataParams, uint8_t bOption, uint8_t bSelector, uint8_t * pFid, uint8_t * pDFname, uint8_t bDFnameLen,
	uint8_t ** ppFCI, uint16_t * pFCILen);

phStatus_t phalMfdf_Sam_X_IsoReadBinary(void * pDataParams, uint16_t wOption, uint8_t bOffset, uint8_t bSfid, uint8_t bBytesToRead,
	uint8_t ** ppResponse, uint16_t * pBytesRead);

phStatus_t phalMfdf_Sam_X_IsoUpdateBinary(void * pDataParams, uint8_t bOffset, uint8_t bSfid, uint8_t * pData, uint8_t bDataLen );

phStatus_t phalMfdf_Sam_X_IsoReadRecords(void * pDataParams, uint16_t wOption, uint8_t bRecNo, uint8_t bReadAllFromP1, uint8_t bSfid, uint8_t bBytesToRead,
	uint8_t ** ppResponse, uint16_t * pBytesRead);

phStatus_t phalMfdf_Sam_X_IsoAppendRecord(void * pDataParams, uint8_t bSfid, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalMfdf_Sam_X_IsoGetChallenge(void * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint32_t dwLe, uint8_t * pRPICC1);

phStatus_t phalMfdf_Sam_X_IsoExternalAuthenticate(void * pDataParams, uint8_t * pDataIn, uint8_t bInputLen, uint8_t * pDataOut, uint8_t * pOutLen);

phStatus_t phalMfdf_Sam_X_IsoInternalAuthenticate(void * pDataParams, uint8_t * pDataIn, uint8_t bInputLen, uint8_t * pDataOut, uint8_t * pOutLen);

phStatus_t phalMfdf_Sam_X_IsoAuthenticate(void * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bKeyNoCard, uint8_t bIsPICCkey);




phStatus_t phalMfdf_Sam_X_ResetAuthStatus(void * pDataParams);

phStatus_t phalMfdf_Sam_X_GetConfig(void * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalMfdf_Sam_X_SetConfig(void * pDataParams, uint16_t wConfig, uint16_t wValue);

#endif /* PHALMFDF_SAM_X_H */
