/*
 * Copyright 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/**
 * \file
 * DESFire Light application SamAV3 NonX component of Reader Library framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALMFDFLIGHT_SAM_NONX_INT_H
#define PHALMFDFLIGHT_SAM_NONX_INT_H

#include <phalMfdfLight.h>
#include <phhalHw_SamAV3_Cmd.h>

/** Mifare Desfire LIGHT frame lengths */
#define PHALMFDFLIGHT_SAM_DATA_FRAME_LENGTH                     224     /* Maximum data that can be exchanged in case of secure messaging computation by SAM. */

/** MIFARE Desfire LIGHT ISO 7816-4 wrapped response information */
#define PHALMFDFLIGHT_RESP_WRAPPED_MSB_BYTE                 0x9100U     /* MSB response information in case of Iso7816 wrapping of Native commands. */

/** MIFARE Desfire LIGHT Sam Non X command options. This flag will be used to compute the MAc on command or not. */
#define PHALMFDFLIGHT_SAM_NONX_NO_MAC_ON_CMD                    0x00    /**< Mac on command is not available. */
#define PHALMFDFLIGHT_SAM_NONX_MAC_ON_CMD                       0x01    /**< Mac on commnd is available. */
#define PHALMFDFLIGHT_SAM_NONX_EXCHANGE_DATA_PICC               0x02    /**< Exchange the data to PICC. */
#define PHALMFDFLIGHT_SAM_NONX_EXCHANGE_PICC_STATUS             0x10    /**< Exchange the status. */
#define PHALMFDFLIGHT_SAM_NONX_PICC_STATUS_WRAPPED              0x80    /**< The PICC status is wrapped. */
#define PHALMFDFLIGHT_SAM_NONX_SESSION_TMAC_ENC                 0x01    /**< Optionto perform generate the TMAC session encryption keys. */
#define PHALMFDFLIGHT_SAM_NONX_SESSION_TMAC_MAC                 0x02    /**< Optionto perform generate the TMAC session MAC keys. */

/* Resolves the component to be used. */
#define PHAL_MFDFLIGHT_RESOLVE_DATAPARAMS(DataParams)   ((phalMfdfLight_SamAV3_NonX_DataParams_t *) DataParams)

/* Resolves the Hal component to be used for communicating with Sam hardware in NonX mode. */
#define PHAL_MFDFLIGHT_RESOLVE_HAL_DATAPARAMS(DataParams)                                                                                               \
            (PH_GET_COMPID(DataParams) == PHAL_MFDFLIGHT_SAMAV3_NONX_ID) ? ((phalMfdfLight_SamAV3_NonX_DataParams_t *) DataParams)->pHalSamDataParams : \
            NULL

/* APP level keys are invalid between 0x0D to 0x21. */
#define IS_INVALID_APP_KEY(keyNo) ((((keyNo) & 0x7f) > 0x0D)    && (((keyNo) & 0x7f) < 0x21))

/* VC keys are invalid after 0x23. */
#define IS_INVALID_VC_KEY(keyNo)    (((keyNo) & 0x7f) > 0x23)





phStatus_t phalMfdfLight_Sam_NonX_Int_ValidateResponse(void * pDataParams, uint16_t wStatus, uint16_t wPiccRetCode);

phStatus_t phalMfdfLight_Sam_NonX_Int_CardExchange(void * pDataParams, uint16_t bWrapCmd, uint16_t wBufferOption,
    uint16_t wTotDataLen, uint8_t bExchangeLE, uint8_t * pData, uint16_t wDataLen, uint8_t ** ppResponse,
    uint16_t * pRespLen, uint8_t * pPiccErrCode);

phStatus_t phalMfdfLight_Sam_NonX_Int_AuthenticatePICC(void * pDataParams, uint8_t bAuthType, uint8_t bAuthMode,
    uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen,
    uint8_t * pPcdCapsIn, uint8_t bPcdCapsInLen, uint8_t * pPCDCap2, uint8_t * pPDCap2);

phStatus_t phalMfdfLight_Sam_NonX_Int_ChangeKeyPICC(void * pDataParams, uint16_t wOption, uint8_t bKeyNoCard,
    uint16_t wCurrKeyNo, uint16_t wCurrKeyVer, uint16_t wNewKeyNo, uint16_t wNewKeyVer, uint8_t * pDivInput,
    uint8_t bDivInputLen);

phStatus_t phalMfdfLight_Sam_NonX_Int_GenerateSM(void * pDataParams, uint16_t wOption, uint8_t bCommMode, uint8_t * pCmdBuff,
    uint16_t wCmdBufLen, uint8_t * pData, uint16_t wDataLen, uint8_t ** ppOutBuffer, uint16_t * pOutBufLen);

phStatus_t phalMfdfLight_Sam_NonX_Int_VerifySM(void * pDataParams, uint16_t wOption, uint8_t bCommMode, uint8_t * pResponse,
    uint16_t wRespLen, uint8_t bPiccStat, uint8_t * pRespMac, uint16_t wRespMacLen, uint8_t ** ppOutBuffer, uint16_t * pOutBufLen);

phStatus_t phalMfdfLight_Sam_NonX_Int_ReadData(void * pDataParams, uint8_t bCmd_ComMode, uint8_t bResp_ComMode, uint8_t * pCmdBuff,
    uint16_t wCmdLen, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalMfdfLight_Sam_NonX_Int_WriteData(void * pDataParams, uint16_t wOption, uint8_t bIsDataCmd, uint8_t bCmd_ComMode,
    uint8_t bResp_ComMode, uint8_t bResetAuth, uint8_t * pCmdBuff, uint16_t wCmdLen, uint8_t * pData, uint32_t dwDataLen,
    uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalMfdfLight_Sam_NonX_Int_CreateTMFilePICC(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption,
    uint8_t * pAccessRights, uint8_t bTMKeyOption, uint8_t bKeyNo, uint8_t bKeyVer, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfLight_Sam_NonX_Int_ResetAuthStatus(void * pDataParams);

phStatus_t phalMfdfLight_Sam_NonX_Int_ComputeTMACSessionVectors(void * pDataParams, uint8_t bOption, uint16_t wSrcKeyNo,
    uint16_t wSrcKeyVer, uint16_t wDstKeyNo, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen);

phStatus_t phalMfdfLight_Sam_NonX_Int_GetFrameLen(void * pDataParams, uint16_t * pFrameLen);

#endif /* PHALMFDFLIGHT_SAM_NONX_INT_H */
