/*
 * Copyright 2017 - 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal functions of Software implementation of MIFARE DESFire Light application layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALMFDFLIGHT_INT_H
#define PHALMFDFLIGHT_INT_H

#include <ph_Status.h>
#include <phalMfdfLight.h>

/** \addtogroup phalMfdfLight
 * @{
 */

/** \name MIFARE DESFire Light Native Commands */
/** @{ */
#define PHAL_MFDFLIGHT_CMD_AUTHENTICATE_EV2_FIRST        				0x71	/**< MFDFLIGHT Authenticate Ev2 First command. */
#define PHAL_MFDFLIGHT_CMD_AUTHENTICATE_EV2_NON_FIRST    				0x77	/**< MFDFLIGHT Authenticate Ev2 Non First command. */
#define PHAL_MFDFLIGHT_CMD_CHANGE_KEY                    				0xC4	/**< MFDFLIGHT Change key cmd. */
#define PHAL_MFDFLIGHT_CMD_GET_KEY_VERSION               				0x64	/**< MFDFLIGHT Get Key Version. */
#define PHAL_MFDFLIGHT_CMD_GET_VERSION                   				0x60	/**< MFDFLIGHT Get Version cmd. */
#define PHAL_MFDFLIGHT_CMD_SET_CONFIG                    				0x5C	/**< MFDFLIGHT Set Configuration Cmd. */
#define PHAL_MFDFLIGHT_CMD_GET_CARD_UID                  				0x51	/**< MFDFLIGHT Get Card UID cmd. */
#define PHAL_MFDFLIGHT_CMD_DELETE_APPLN                  				0xDA	/**< MFDFLIGHT Delete Application cmd. */
#define PHAL_MFDFLIGHT_CMD_GET_FILE_IDS                  				0x6F	/**< MFDFLIGHT Get File IDs cmd. */
#define PHAL_MFDFLIGHT_CMD_GET_ISO_FILE_IDS              				0x61	/**< MFDFLIGHT Get ISO File IDs cmd. */
#define PHAL_MFDFLIGHT_CMD_GET_FILE_SETTINGS             				0xF5	/**< MFDFLIGHT Get File settings cmd. */
#define PHAL_MFDFLIGHT_CMD_CHANGE_FILE_SETTINGS          				0x5F	/**< MFDFLIGHT Change file settings cmd. */
#define PHAL_MFDFLIGHT_CMD_CREATE_TRANSACTION_MACFILE    				0xCE	/**< MFDFLIGHT Create Transaction MAC file cmd. */
#define PHAL_MFDFLIGHT_CMD_DELETE_FILE                   				0xDF	/**< MFDFLIGHT Delete File cmd. */
#define PHAL_MFDFLIGHT_CMD_READ_DATA                     				0xBD	/**< MFDFLIGHT Read Data cmd. */
#define PHAL_MFDFLIGHT_CMD_READ_DATA_ISO                 				0xAD	/**< MFDFLIGHT Read Data cmd using ISO chaining. */
#define PHAL_MFDFLIGHT_CMD_WRITE_DATA                    				0x3D	/**< MFDFLIGHT Write data cmd. */
#define PHAL_MFDFLIGHT_CMD_WRITE_DATA_ISO                				0x8D	/**< MFDFLIGHT Write data cmd using ISO chaining. */
#define PHAL_MFDFLIGHT_CMD_GET_VALUE                     				0x6C	/**< MFDFLIGHT Get Value cmd. */
#define PHAL_MFDFLIGHT_CMD_CREDIT                        				0x0C	/**< MFDFLIGHT Credit cmd. */
#define PHAL_MFDFLIGHT_CMD_DEBIT                         				0xDC	/**< MFDFLIGHT Debit cmd. */
#define PHAL_MFDFLIGHT_CMD_LIMITED_CREDIT                				0x1C	/**< MFDFLIGHT Limited Credit cmd. */
#define PHAL_MFDFLIGHT_CMD_WRITE_RECORD                  				0x3B	/**< MFDFLIGHT Write Record cmd. */
#define PHAL_MFDFLIGHT_CMD_WRITE_RECORD_ISO              				0x8B	/**< MFDFLIGHT Write Record cmd using ISO chaining. */
#define PHAL_MFDFLIGHT_CMD_UPDATE_RECORD                 				0xDB	/**< MFDFLIGHT Update Record cmd. */
#define PHAL_MFDFLIGHT_CMD_UPDATE_RECORD_ISO             				0xBA	/**< MFDFLIGHT Update Record cmd using ISO chaining. */
#define PHAL_MFDFLIGHT_CMD_READ_RECORDS                  				0xBB	/**< MFDFLIGHT Read Records cmd. */
#define PHAL_MFDFLIGHT_CMD_READ_RECORDS_ISO              				0xAB	/**< MFDFLIGHT Read Records cmd using ISO chaining. */
#define PHAL_MFDFLIGHT_CMD_CLEAR_RECORD_FILE             				0xEB	/**< MFDFLIGHT Clear records file cmd. */
#define PHAL_MFDFLIGHT_CMD_COMMIT_TXN                    				0xC7	/**< MFDFLIGHT Commit transaction cmd. */
#define PHAL_MFDFLIGHT_CMD_ABORT_TXN                    				0xA7	/**< MFDFLIGHT Abort transaction cmd. */
#define PHAL_MFDFLIGHT_CMD_COMMIT_READER_ID              				0xC8	/**< MFDFLIGHT Commit Reader ID cmd. */
#define PHAL_MFDFLIGHT_CMD_READ_SIG										0x3C	/**< MFDFLIGHT Verify read signature command. */
#define PHAL_MFDFLIGHT_CMD_CLEAR_RECORDS_FILE			 				0xEB	/**< MFDFLIGHT Clear records file cmd. */
/** @} */

/** \name MIFARE DESFire Light ISO7816 Commands */
/** @{ */
#define PHAL_MFDFLIGHT_CMD_ISO7816_SELECT_FILE							0xA4	/**< ISO Select File. */
#define PHAL_MFDFLIGHT_CMD_ISO7816_READ_BINARY       					0xB0	/**< ISO Read Binary. */
#define PHAL_MFDFLIGHT_CMD_ISO7816_UPDATE_BINARY     					0xD6	/**< ISO UPDATE Binary. */
#define PHAL_MFDFLIGHT_CMD_ISO7816_APPEND_RECORD     					0xE2	/**< ISO Append record. */
#define PHAL_MFDFLIGHT_CMD_ISO7816_UPDATE_RECORD     					0xD2	/**< ISO Update record. */
/** @} */

/**
 * @}
 */

#define PHAL_MFDFLIGHT_WRAP_HDR_LEN										0x05U	/* Wrapped APDU header length */
#define PHAL_MFDFLIGHT_WRAPPEDAPDU_CLA   								0x90U	/* Wrapped APDU default class. */
#define PHAL_MFDFLIGHT_WRAPPEDAPDU_P1    								0x00U	/* Wrapped APDU default P1. */
#define PHAL_MFDFLIGHT_WRAPPEDAPDU_P2    								0x00U	/* Wrapped APDU default P2. */
#define PHAL_MFDFLIGHT_WRAPPEDAPDU_LE    								0x00U	/* Wrapped APDU default LE. */

#define PHAL_MFDFLIGHT_TRUNCATED_MAC_SIZE									8	/**< Size of the truncated MAC. */
#define PHAL_MFDFLIGHT_ISO_CHAINING_MODE								0x04	/**< Option to enable ISO chaining. */
#define PHAL_MFDFLIGHT_DEFAULT_MODE										0x00	/**< Native Chaining. */
#define PHAL_MFDFLIGHT_SIG_LENGTH										0x38	/**< NXP Originality Signature length */
#define PHAL_MFDFLIGHT_DEFAULT_UID_LENGTH								0x07	/**< By default EV2 card is configures as 7 byte UID */
#define PHAL_MFDFLIGHT_10B_UID_LENGTH		    						0x09	/**< EV2 can also be configured as 10 byte UID. */
#define PHAL_MFDFLIGHT_4B_UID_LENGTH		    						0x06	/**< EV2 can also be configured as 4 byte UID. */
#define PHAL_MFDFLIGHT_DEF_VERSION_LENGTH								0x1C	/**< Version String is of 28 bytes by default(If its 7 Byte UID) */
#define PHAL_MFDFLIGHT_VERSION_LENGTH_WITH_FABKEY_ID		    		0x1D	/**< Version String is of 29 bytes by default(If its 7 Byte UID) */
#define PHAL_MFDFLIGHT_10B_VERSION_LENGTH	    						0x1E	/**< Version String is of 30 bytes If its 10B Byte UID */
#define PHAL_MFDFLIGHT_4B_VERSION_LENGTH	    						0x1B	/**< Version String is of 27 bytes If its 4B Byte UID */
#define PHAL_MFDFLIGHT_ISO_CHAINING_MODE_MAPPED	(PHAL_MFDFLIGHT_ISO_CHAINING_MODE << 2)	/**< Option to enable ISO chaining mapped for internal use. */

#define PHAL_MFDFLIGHT_MAXWRAPPEDAPDU_SIZE								0x37u	/**< Maximum size of wrapped APDU 55 bytes. */
#define PHAL_MFDFLIGHT_MAXDFAPDU_SIZE        							0x3Cu	/**< Maximum size of DESFire APDU 60 bytes. */
#define PHAL_MFDFLIGHT_MAX_FRAME_SIZE        							0x40u	/**< Max size in a ISO 14443-4 frame. */

/* To avoid unused variable warnings. */
#define PHAL_MFDFLIGHT_UNUSED_VARIABLE(x)	{for( ( x ) = ( x ) ; ( x ) != ( x ) ; );}
#define PHAL_MFDFLIGHT_UNUSED_ARRAY(x)		{for( ( (x)[0] ) = ( (x)[0] ) ; ( (x)[0] ) != ( (x)[0] ) ; );}

phStatus_t phalMfdfLight_Int_ComputeErrorResponse(void * pDataParams, uint16_t wStatus);

phStatus_t phalMfdfLight_ExchangeCmd(void * pDataParams, void * pPalMifareDataParams, uint8_t bWrappedMode, uint8_t * pCmd, uint16_t wCmdLen,
	uint8_t ** ppResponse, uint16_t * wRxlen);

phStatus_t phalMfdfLight_Int_Send7816Apdu(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t bIns, uint8_t p1, uint8_t p2,
	uint32_t Lc, uint8_t bExtendedLenApdu, uint8_t * pDataIn, uint32_t bLe, uint8_t ** pDataOut, uint16_t *pDataLen);

phStatus_t phalMfdfLight_Int_ISOSelectFile(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t * bCmdBuff, uint16_t wCmdLen,
	uint8_t bLc, uint8_t bExtendedLenApdu, uint8_t * pDataIn, uint8_t bLe, uint8_t ** ppDataOut, uint16_t *pDataLen);

phStatus_t phalMfdfLight_Int_ISOUpdateBinary(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t * bCmdBuff, uint16_t wCmdLen,
	uint32_t dwLc, uint8_t bExtendedLenApdu, uint8_t * pDataIn, uint8_t ** ppDataOut, uint16_t *pDataLen);

#endif /* PHALMFDFLIGHT_INT_H */
