/*
 * Copyright 2016 - 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef PHALMFPRIMENTAG_SW_H
#define PHALMFPRIMENTAG_SW_H

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalMfprimeNtag_Sw_AuthenticateEv2(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bFirstAuth, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer,
	uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivLen, uint8_t bLenPcdCapsIn, uint8_t *pPcdCapsIn, uint8_t *pPcdCapsOut, uint8_t *pPdCapsOut);




phStatus_t phalMfprimeNtag_Sw_SetConfiguration(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen);
#endif /* NXPBUILD__PH_CRYPTOSYM */

phStatus_t phalMfprimeNtag_Sw_GetVersion(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t * pVerInfo);



#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalMfprimeNtag_Sw_ChangeKey( phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint16_t wOption, uint16_t wOldKeyNo, uint16_t wOldKeyVer, uint16_t wNewKeyNo,
	uint16_t wNewKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivLen);
#endif /* NXPBUILD__PH_CRYPTOSYM */

phStatus_t phalMfprimeNtag_Sw_GetKeyVersion(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bKeyNo, uint8_t bKeySetNo, uint8_t * pKeyVersion, uint8_t * bRxLen);




phStatus_t phalMfprimeNtag_Sw_GetFileSettings(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bFileNo, uint8_t * pFSBuffer, uint8_t * bBufferLen);

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalMfprimeNtag_Sw_GetFileCountersSDM(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pFileCounters,
	uint8_t * pRxLen);
#endif /* NXPBUILD__PH_CRYPTOSYM */

phStatus_t phalMfprimeNtag_Sw_ChangeFileSettings(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bCommSett,
	uint8_t * pAccessRights, uint8_t bNumAddARs, uint8_t * pAddARs);

phStatus_t phalMfprimeNtag_Sw_ChangeFileSettingsSDM(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption,
	uint8_t *pAccessRights, uint8_t bSdmOptions, uint8_t *pSdmAccessRights, uint8_t *pVCUIDOffset, uint8_t *pSDMReadCtrOffset, uint8_t *pSDMMACInputOffset,
	uint8_t *pSDMMACOffset);




phStatus_t phalMfprimeNtag_Sw_ReadData(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bIns, uint8_t bFileNo, uint8_t * pOffset,
	uint8_t * pLength, uint8_t ** ppRxdata, uint16_t * pRxdataLen);

phStatus_t phalMfprimeNtag_Sw_WriteData(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bCommOption, uint8_t bIns, uint8_t bFileNo, uint8_t * pOffset,
	uint8_t * pTxData, uint8_t * pTxDataLen);




phStatus_t phalMfprimeNtag_Sw_IsoSelectFile(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bSelector, uint8_t * pFid, uint8_t * pDFname,
	uint8_t bDFnameLen, uint8_t	bExtendedLenApdu, uint8_t ** ppFCI, uint16_t * pwFCILen);

phStatus_t phalMfprimeNtag_Sw_IsoReadBinary(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bOffset, uint8_t bSfid, uint32_t dwBytesToRead,
	uint8_t bExtendedLenApdu, uint8_t ** ppRxBuffer, uint32_t * pBytesRead);

phStatus_t phalMfprimeNtag_Sw_IsoUpdateBinary(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bOffset, uint8_t bSfid, uint8_t bLcLen, uint8_t * pData,
	uint32_t dwDataLen);




phStatus_t phalMfprimeNtag_Sw_ReadSign(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint8_t bAddr, uint8_t ** pSignature);




phStatus_t phalMfprimeNtag_Sw_GetConfig(phalMfprimeNtag_Sw_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalMfprimeNtag_Sw_SetConfig(phalMfprimeNtag_Sw_DataParams_t *pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phalMfprimeNtag_Sw_ResetAuthentication(phalMfprimeNtag_Sw_DataParams_t * pDataParams);

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalMfprimeNtag_Sw_CalculateMACSDM(phalMfprimeNtag_Sw_DataParams_t *pDataParams, uint16_t wOption, uint8_t bSdmOption, uint16_t wSDMFileReadKeyNo,
	uint16_t wSDMFileReadKeyVer, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pUid, uint8_t   bUidLen, uint8_t * pSDMReadCtr, uint8_t * pIndata,
	uint16_t wInDataLen, uint8_t * pRespMac);
#endif /* NXPBUILD__PH_CRYPTOSYM */

#endif /* PHALMFPRIMENTAG_SW_H */
