/*
 * Copyright 2016 - 2018, 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * SamX MIFARE(R) Ultralight Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALMFUL_SAM_X_INT_H
#define PHALMFUL_SAM_X_INT_H

#include <ph_Status.h>

#ifdef NXPBUILD__PHAL_MFUL_SAM_X

phStatus_t phalMful_Sam_X_Int_UlcAuthenticate(void * pDataParams, uint8_t bOption, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pStatusCode);

phStatus_t phalMful_Sam_X_Int_MfRead(void * pDataParams, uint8_t * pBlocks, uint8_t bBlocksLen, uint8_t ** ppData,
    uint16_t * pDataLen);

phStatus_t phalMful_Sam_X_Int_MfWrite(void * pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen,
    uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalMful_Sam_X_Int_PwdAuthUL(void * pDataParams, uint8_t bOption, uint8_t bKeyNo, uint8_t bKeyVer,
    uint8_t * pPassword, uint8_t * pPack, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pStatusCode);
#endif /* NXPBUILD__PHAL_MFUL_SAM_X */

#endif /* PHALMFUL_SAM_X_INT_H */
