/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Inernal implementation of P40 CmdPriv
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */
#ifndef PHALP40CMDPRIV_INT_H
#define PHALP40CMDPRIV_INT_H

/** \addtogroup ph_Private
* @{
*/

/** \name I.PrivateCommand instruction codes
*/
/*@{*/
#define PHAL_P40CMDPRIV_GETVERSION_P		0xAAU
#define PHAL_P40CMDPRIV_WRITEMEMORY_P		0xBBU
#define PHAL_P40CMDPRIV_READMEMORY_P		0xCCU
#define PHAL_P40CMDPRIV_CALCULATECKSM_P		0xDDU
#define PHAL_P40CMDPRIV_EXECUTE_P			0xEEU
#define PHAL_P40CMDPRIV_AUTHENTICATE_P		0xFFU
#define PHAL_P40CMDPRIV_FASTTEST_P			0x99U
#define PHAL_P40CMDPRIV_SWITCH_LIFE_CYCLE_P 0x88U
/*@}*/

/** \name P40 error codes
*/
/*@{*/
#define PHAL_P40CMDPRIV_INT_ERR_OK          0x90U
#define PHAL_P40CMDPRIV_INT_ERR_BAD_CMD     0x6DU
#define PHAL_P40CMDPRIV_INT_ERR_PARAM       0x6BU
#define PHAL_P40CMDPRIV_INT_ERR_FORMAT      0x67U
#define PHAL_P40CMDPRIV_INT_ERR_INTERNAL    0x6FU
#define PHAL_P40CMDPRIV_INT_ERR_NOT_AUTH    0x69U
#define PHAL_P40CMDPRIV_INT_ERR_UNKNOWN     0xFFU   /* only used by RdLib to initialze variable*/
/*@}*/

/**
* \brief Translate CMDPRIV internally used return codes to general phStatus_t custom defined codes
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
*/
phStatus_t phalP40CmdPriv_Int_TranslateError(
    uint8_t bErrorCode
    );

/** @}
* end of ph_Private
*/

#endif /*PHALP40CMDPRIV_INT_H*/
