/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * ProxiLAB BAL Component of Reader Library Framework.
 * Author: santosh.d.araballi
 * Revision: 1.12
 * Date: Thu Apr 14 15:36:57 2011
 */
#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>
#include <string.h>
#include <oledb.h>
#include "phbalReg_ContactLAB_Int.h"

#ifdef NXPBUILD__PHBAL_REG_CONTACTLAB

phStatus_t phbalReg_ContactLAB_Init(
                                    phbalReg_ContactLAB_DataParams_t * pDataParams,
                                    uint16_t wSizeOfDataParams
                                    )
{
    if (sizeof(phbalReg_ContactLAB_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
    }
    PH_ASSERT_NULL (pDataParams);

    /* initialize the data parameters to default values */
    pDataParams->wId = PH_COMP_BAL | PHBAL_REG_CONTACTLAB_ID;
    pDataParams->pContactLAB = NULL;
    pDataParams->bBoardNumber[0] = 0;
    pDataParams->bHardwareVersion[0] = 0;
    pDataParams->bFirmwareVersion[0] = 0;
    pDataParams->bSoftwareVersion[0] = 0;
    pDataParams->bContactLABSerial[0] = 0;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phbalReg_ContactLAB_GetPortList(
                                           phbalReg_ContactLAB_DataParams_t * pDataParams,
                                           uint16_t wPortBufSize,
                                           uint8_t * pPortNames,
                                           uint16_t * pNumOfPorts
                                           )
{
    uint8_t abPortName[] = "ContactLAB Reader";
    uint16_t wLen;

    *pNumOfPorts = 0;

    /* Try to open port if successful return reader */
    if(phbalReg_OpenPort(pDataParams) == PH_ERR_SUCCESS)
    {
        phbalReg_ClosePort(pDataParams);
        if (wPortBufSize)
        {
            wLen = (uint16_t)strlen( (char *) abPortName);
            memcpy(pPortNames, abPortName, wLen); /* PRQA S 3200 */
            *pNumOfPorts = 1;
        }
        else
        {
            return PH_ADD_COMPCODE(PH_ERR_BUFFER_OVERFLOW, PH_COMP_BAL);
        }
    }
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phbalReg_ContactLAB_SetPort(
                                       phbalReg_ContactLAB_DataParams_t * pDataParams,
                                       uint8_t * pPortName
                                       )
{
    /* satisfy compiler */
    if(pDataParams || pPortName);

    /* No Port needs to be set for this reader so just return success */
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phbalReg_ContactLAB_Exchange(
                                        phbalReg_ContactLAB_DataParams_t * pDataParams,
                                        uint16_t wOption,
                                        uint8_t * pTxBuffer,
                                        uint16_t wTxLength,
                                        uint16_t wRxBufSize,
                                        uint8_t * pRxBuffer,
                                        uint16_t * pRxLength
                                        )
{
    /* satisfy compiler */
    if(pDataParams || wOption || pTxBuffer || wTxLength || wRxBufSize || pRxBuffer || pRxLength);
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phbalReg_ContactLAB_OpenPort(
                                        phbalReg_ContactLAB_DataParams_t * pDataParams
                                        )
{
    /* COM initialization */
    CoInitializeEx(NULL, COINIT_MULTITHREADED);

    /* Map to C++ code */
    return phbalReg_ContactLAB_Int_OpenPort(pDataParams);
}

phStatus_t phbalReg_ContactLAB_ClosePort(
                                         phbalReg_ContactLAB_DataParams_t * pDataParams
                                         )
{
    phStatus_t status;
    status = phbalReg_ContactLAB_Int_ClosePort(pDataParams);
    /* COM uninitialization */
    CoUninitialize();
    return status;
}

phStatus_t phbalReg_ContactLAB_SetConfig(
                                         phbalReg_ContactLAB_DataParams_t * pDataParams,
                                         uint16_t wConfig,
                                         uint16_t wValue
                                         )
{
    /* satisfy compiler */
    if(pDataParams || wConfig || wValue);
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phbalReg_ContactLAB_GetConfig(
                                       phbalReg_ContactLAB_DataParams_t * pDataParams,
                                       uint16_t wConfig,
                                       uint16_t * pValue
                                       )
{
    /* satisfy compiler */
    if(pDataParams || wConfig || pValue);
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

#endif /* NXPBUILD__PHBAL_REG_CONTACTLAB */
