/*
 * Copyright 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_MP300USB_EX_H
#define PHBALREG_MP300USB_EX_H

#include <ph_Status.h>
#include <phbalReg.h>

phStatus_t phbalReg_Mp300Usb_Ex_LoadFunctions(
    phbalReg_Mp300Usb_DataParams_t * pDataParams
    );

phStatus_t phbalReg_Mp300Usb_Ex_UnLoadFunctions(
    phbalReg_Mp300Usb_DataParams_t * pDataParams
    );

/* define the dll that has to be loaded */
#define PHBAL_REG_MP300USB_EX_DLL_LIBUSB_NAME       "libusb0.dll"

/* define the function names that have to be loaded */
#define PHBAL_REG_MP300USB_EX_INIT                  "usb_init"
#define PHBAL_REG_MP300USB_EX_FIND_BUSSES           "usb_find_busses"
#define PHBAL_REG_MP300USB_EX_FIND_DEVICES          "usb_find_devices"
#define PHBAL_REG_MP300USB_EX_GET_BUSSES            "usb_get_busses"
#define PHBAL_REG_MP300USB_EX_OPEN                  "usb_open"
#define PHBAL_REG_MP300USB_EX_CLOSE                 "usb_close"
#define PHBAL_REG_MP300USB_EX_CLAIM_INTERFACE       "usb_claim_interface"
#define PHBAL_REG_MP300USB_EX_RELEASE_INTERFACE     "usb_release_interface"
#define PHBAL_REG_MP300USB_EX_INTERRUPT_WRITE       "usb_interrupt_write"
#define PHBAL_REG_MP300USB_EX_BULK_WRITE            "usb_bulk_write"
#define PHBAL_REG_MP300USB_EX_INTERRUPT_READ        "usb_interrupt_read"
#define PHBAL_REG_MP300USB_EX_READ                  "usb_bulk_read"
#define PHBAL_REG_MP300USB_EX_GET_STRING_SIMPLE     "usb_get_string_simple"

#endif /* PHBALREG_MP300USB_EX_H */
