/*
 * Copyright 2017 - 2018, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * MP300 USB BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_MP300USB_IF_H
#define PHBALREG_MP300USB_IF_H

#include "external/lusb0_usb.h"

#ifndef BOOL
typedef int BOOL;
#endif

#ifndef ETRANSFER_TIMEDOUT
    /* Connection timed out */
    #define ETRANSFER_TIMEDOUT 116
#endif

#define DEFAULT_TIMEOUT_IN_MILLISECONDS 5000
#define INVALID_USB_HANDLE (uint8_t)(-1)

phStatus_t phbalReg_Mp300Usb_If_Open(phbalReg_Mp300Usb_DataParams_t * pDataParams);
phStatus_t phbalReg_Mp300Usb_If_Close(phbalReg_Mp300Usb_DataParams_t * pDataParams);
phStatus_t phbalReg_Mp300Usb_If_Exchange(phbalReg_Mp300Usb_DataParams_t * pDataParams,
                                           uint8_t* pTxBuffer,
                                           uint16_t wTxLength,
                                           uint16_t wRxBufSize,
                                           uint8_t* pRxBuffer,
                                           uint16_t* pRxLength);

phStatus_t phbalReg_Mp300Usb_If_ConvertError(int32_t dwError);

phStatus_t phbalReg_Mp300Usb_If_GetDeviceName(phbalReg_Mp300Usb_DataParams_t * pDataParams,
                                              struct usb_device * pUsbDev,
                                              usb_dev_handle * pUsbDevHandle,
                                              uint8_t * pNameBuffer,
                                              uint32_t dwNameBufferLength);

#endif /* PHBALREG_MP300USB_IF_H */
